/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Transform
implements Cloneable {
    private static double NORMAL_SIZE = 600.0;
    private double xmin_requested;
    private double xmax_requested;
    private double ymin_requested;
    private double ymax_requested;
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    private int x;
    private int y;
    private int width;
    private int height;
    private ArrayList<ChangeListener> changeListeners;
    private ChangeEvent changeEvent;
    private boolean fastDrawing;
    private double pixelWidth;
    private double pixelHeight;
    private boolean appliedTransform2D;
    private float strokeWidth;
    private AffineTransform transform;
    protected Graphics2D g;
    protected Graphics2D untransformedGraphics;

    public Transform() {
        this(-5.0, 5.0, -5.0, 5.0);
    }

    public Transform(double d, double d2, double d3, double d4) {
        this.setLimits(d, d2, d3, d4);
    }

    public Transform(double d) {
        double d2 = 0.5 * NORMAL_SIZE / d;
        this.setLimits(-d2, d2, -d2, d2);
    }

    public Transform(Transform transform) {
        this(transform.xmin_requested, transform.xmax_requested, transform.ymin_requested, transform.ymax_requested);
    }

    void setFastDrawing(boolean bl, boolean bl2) {
        if (bl != this.fastDrawing) {
            this.fastDrawing = bl;
            if (bl2) {
                this.fireTransformChangeEvent();
            }
        }
    }

    boolean getFastDrawing() {
        return this.fastDrawing;
    }

    public void setLimits(double d, double d2, double d3, double d4) {
        if (d == this.xmin && d3 == this.ymin && d2 == this.xmax && d4 == this.ymax) {
            return;
        }
        this.xmin = this.xmin_requested = d;
        this.xmax = this.xmax_requested = d2;
        this.ymin = this.ymin_requested = d3;
        this.ymax = this.ymax_requested = d4;
        this.height = 0;
        this.width = 0;
        this.y = 0;
        this.x = 0;
        this.fireTransformChangeEvent();
    }

    protected void resetLimits(double d, double d2, double d3, double d4) {
        this.xmin = d;
        this.xmax = d2;
        this.ymin = d3;
        this.ymax = d4;
    }

    public double getXmaxRequested() {
        return this.xmax_requested;
    }

    public double getXminRequested() {
        return this.xmin_requested;
    }

    public double getYmaxRequested() {
        return this.ymax_requested;
    }

    public double getYminRequested() {
        return this.ymin_requested;
    }

    public double getXmax() {
        return this.xmax;
    }

    public double getXmin() {
        return this.xmin;
    }

    public double getYmax() {
        return this.ymax;
    }

    public double getYmin() {
        return this.ymin;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean equals(Object object) {
        if (object == null || !Transform.class.equals(object.getClass())) {
            return false;
        }
        return this.hasSameViewTransform((Transform)object);
    }

    public boolean hasSameViewTransform(Transform transform) {
        if (transform == null) {
            return false;
        }
        return this.xmin == transform.xmin && this.xmax == transform.xmax && this.ymin == transform.ymin && this.ymax == transform.ymax && this.x == transform.x && this.y == transform.y && this.width == transform.width && this.height == transform.height;
    }

    public Object clone() {
        Transform transform = null;
        try {
            transform = (Transform)super.clone();
            transform.changeListeners = null;
            transform.changeEvent = null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return transform;
    }

    public void setUpDrawInfo(Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        double d;
        Stroke stroke;
        this.g = graphics2D;
        this.untransformedGraphics = null;
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.appliedTransform2D = bl2;
        this.transform = null;
        this.strokeWidth = 1.0f;
        this.pixelWidth = this.pixelHeight = (double)1.0f;
        if (n3 <= 0 || n4 <= 0) {
            this.height = 0;
            this.width = 0;
            return;
        }
        this.strokeWidth = 1.0f;
        this.pixelWidth = this.pixelHeight = (double)1.0f;
        if (graphics2D != null && (stroke = graphics2D.getStroke()) instanceof BasicStroke) {
            this.strokeWidth = ((BasicStroke)stroke).getLineWidth();
        }
        if (bl) {
            double d2 = (double)n3 / (double)n4;
            d = Math.abs((this.xmax_requested - this.xmin_requested) / (this.ymax_requested - this.ymin_requested));
            if (d2 < d) {
                double d3 = (this.ymin_requested + this.ymax_requested) / 2.0;
                double d4 = (this.ymax_requested - this.ymin_requested) * (d / d2);
                this.ymin = d3 - d4 / 2.0;
                this.ymax = d3 + d4 / 2.0;
                this.xmin = this.xmin_requested;
                this.xmax = this.xmax_requested;
            } else {
                double d5 = (this.xmin_requested + this.xmax_requested) / 2.0;
                double d6 = (this.xmax_requested - this.xmin_requested) * (d2 / d);
                this.xmin = d5 - d6 / 2.0;
                this.xmax = d5 + d6 / 2.0;
                this.ymin = this.ymin_requested;
                this.ymax = this.ymax_requested;
            }
        } else {
            this.xmin = this.xmin_requested;
            this.xmax = this.xmax_requested;
            this.ymin = this.ymin_requested;
            this.ymax = this.ymax_requested;
        }
        if (bl2 && graphics2D != null) {
            this.untransformedGraphics = (Graphics2D)graphics2D.create();
            this.pixelWidth = Math.abs(this.xmax - this.xmin) / (double)n3;
            this.pixelHeight = Math.abs(this.ymax - this.ymin) / (double)n4;
            double d7 = (double)n4 / (this.ymax - this.ymin);
            d = (double)n3 / (this.xmax - this.xmin);
            this.transform = new AffineTransform();
            this.transform.translate(n3 / 2, n4 / 2);
            this.transform.scale(d, -d7);
            this.transform.translate(-(this.xmin + this.xmax) / 2.0, -(this.ymin + this.ymax) / 2.0);
            graphics2D.transform(this.transform);
            this.strokeWidth *= (float)Math.min(this.pixelWidth, this.pixelHeight);
            graphics2D.setStroke(new BasicStroke(this.strokeWidth));
        }
    }

    public void finishDrawing() {
        this.g = null;
        if (this.untransformedGraphics != null) {
            this.untransformedGraphics.dispose();
        }
        this.untransformedGraphics = null;
    }

    public Graphics2D getGraphics() {
        return this.g;
    }

    public Graphics2D getUntransformedGraphics() {
        if (this.untransformedGraphics == null) {
            return this.g;
        }
        this.untransformedGraphics.setColor(this.g.getColor());
        this.untransformedGraphics.setFont(this.g.getFont());
        return this.untransformedGraphics;
    }

    public void viewportToWindow(Point2D point2D) {
        if (this.width == 0) {
            return;
        }
        double d = this.xmin + (point2D.getX() - (double)this.x) / (double)this.width * (this.xmax - this.xmin);
        double d2 = this.ymax - (point2D.getY() - (double)this.y) / (double)this.height * (this.ymax - this.ymin);
        point2D.setLocation(d, d2);
    }

    public void windowToViewport(Point2D point2D) {
        if (this.width == 0) {
            return;
        }
        double d = (double)this.x + (point2D.getX() - this.xmin) / (this.xmax - this.xmin) * (double)this.width;
        double d2 = (double)this.y + (this.ymax - point2D.getY()) / (this.ymax - this.ymin) * (double)this.height;
        point2D.setLocation(d, d2);
    }

    public void windowToDrawingCoords(Point2D point2D) {
        if (!this.appliedTransform2D && this.width != 0) {
            double d = (double)this.x + (point2D.getX() - this.xmin) / (this.xmax - this.xmin) * (double)this.width;
            double d2 = (double)this.y + (this.ymax - point2D.getY()) / (this.ymax - this.ymin) * (double)this.height;
            point2D.setLocation(d, d2);
        }
    }

    public double getPixelWidth() {
        if (this.width == 0) {
            return 1.0;
        }
        return this.pixelWidth;
    }

    public double getPixelHeight() {
        if (this.height == 0) {
            return 1.0;
        }
        return this.pixelHeight;
    }

    public float getDefaultStrokeSize() {
        if (this.width == 0) {
            return 1.0f;
        }
        return this.strokeWidth;
    }

    public boolean appliedTransform2D() {
        return this.appliedTransform2D;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            return;
        }
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
        }
        this.changeListeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (changeListener != null && this.changeListeners != null) {
            this.changeListeners.remove(changeListener);
            if (this.changeListeners.isEmpty()) {
                this.changeListeners = null;
            }
        }
    }

    protected synchronized void fireTransformChangeEvent() {
        if (this.changeListeners == null) {
            return;
        }
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            this.changeListeners.get(i).stateChanged(this.changeEvent);
        }
    }
}

