/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vmm.core.Animation;
import vmm.core.Display;
import vmm.core.Filmstrip;

public abstract class TimerAnimation
implements Animation {
    public static final int ONCE = 0;
    public static final int LOOP = 1;
    public static final int OSCILLATE = 2;
    private int looping = 0;
    private Timer timer;
    private int frames;
    private int millisecondsPerFrame;
    private int initialDelay;
    private boolean forward;
    private ArrayList<ChangeListener> changeListeners;
    private ChangeEvent changeEvent;
    private boolean fireFrameEvents;
    private boolean paused;
    private Filmstrip filmstrip;
    protected Display display;
    protected double timeDilation;
    protected int frameNumber;

    protected abstract void drawFrame();

    public TimerAnimation() {
        this(-1, 50, false);
    }

    public TimerAnimation(int n, int n2) {
        this(n, n2, false);
    }

    public TimerAnimation(int n, int n2, boolean bl) {
        if (n <= 0) {
            n = -1;
        }
        this.frames = n;
        if (n2 > 0) {
            this.millisecondsPerFrame = n2;
        }
        if (bl) {
            this.filmstrip = new Filmstrip();
        }
    }

    public boolean getUseFilmstrip() {
        return this.filmstrip != null;
    }

    public void setUseFilmstrip(boolean bl) {
        if (bl != (this.filmstrip != null)) {
            this.filmstrip = bl ? new Filmstrip() : null;
        }
    }

    public Filmstrip getFilmstrip() {
        return this.filmstrip;
    }

    public BufferedImage getFilmstripFrameImage() {
        if (this.filmstrip != null && this.filmstrip.getFrameCount() > this.frameNumber) {
            return this.filmstrip.getFrame(this.frameNumber);
        }
        return null;
    }

    void saveCurrentFrame(BufferedImage bufferedImage) {
        if (this.frameNumber >= 0 && (this.frames <= 0 || this.frameNumber <= this.frames)) {
            this.filmstrip.setFrame(this.frameNumber, bufferedImage);
        }
    }

    BufferedImage getCurrentFilmstripFrame() {
        if (this.filmstrip != null && this.frameNumber >= 0 && this.frameNumber < this.filmstrip.getFrameCount()) {
            return this.filmstrip.getFrame(this.frameNumber);
        }
        return null;
    }

    void setDisplay(Display display) {
        this.display = display;
    }

    void setFilmstrip(Filmstrip filmstrip) {
        this.filmstrip = filmstrip;
        if (filmstrip != null) {
            this.setFrames(filmstrip.getFrameCount() - 1);
        }
    }

    public void setLooping(int n) {
        if (n >= 0 && n <= 2) {
            this.looping = n;
            if (n != 2) {
                this.forward = true;
            }
        }
    }

    public int getLooping() {
        return this.looping;
    }

    public int getFrames() {
        return this.frames;
    }

    public void setFrames(int n) {
        if (n <= 0) {
            n = -1;
        }
        this.frames = n;
        if (n <= 0) {
            this.setLooping(0);
        }
    }

    public boolean getFireFrameEvents() {
        return this.fireFrameEvents;
    }

    public void setFireFrameEvents(boolean bl) {
        this.fireFrameEvents = bl;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(int n) {
        if (n >= 0) {
            this.initialDelay = n;
        }
    }

    public int getMillisecondsPerFrame() {
        return this.millisecondsPerFrame;
    }

    public void setMillisecondsPerFrame(int n) {
        if (n > 0) {
            this.millisecondsPerFrame = n;
            if (this.timer != null) {
                this.timer.setDelay(this.applyDilation(n));
            }
        }
    }

    public void setPaused(boolean bl) {
        if (this.timer == null || this.paused == bl) {
            return;
        }
        this.paused = bl;
        if (bl) {
            this.timer.stop();
        } else {
            this.timer.setInitialDelay(0);
            this.timer.restart();
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public synchronized void setTimeDilation(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d != this.timeDilation) {
            this.timeDilation = d;
            if (this.timer != null) {
                this.timer.setDelay(this.applyDilation(this.millisecondsPerFrame));
            }
        }
    }

    public double getTimeDilation() {
        return this.timeDilation;
    }

    private int applyDilation(int n) {
        int n2 = (int)((double)n * this.timeDilation + 0.49);
        if (n > 0 && n2 == 0) {
            return 1;
        }
        return n2;
    }

    public synchronized void start() {
        if (this.timer != null) {
            return;
        }
        this.timer = new Timer(this.applyDilation(this.millisecondsPerFrame), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TimerAnimation.this.nextFrame(actionEvent);
            }
        });
        this.timer.setInitialDelay(this.applyDilation(this.initialDelay));
        this.frameNumber = -1;
        this.forward = true;
        this.paused = false;
        this.animationStarting();
        this.fireAnimationChangeEvent();
        this.timer.start();
    }

    protected synchronized void nextFrame(ActionEvent actionEvent) {
        if (this.timer != actionEvent.getSource()) {
            return;
        }
        this.frameNumber = this.forward ? ++this.frameNumber : --this.frameNumber;
        switch (this.looping) {
            case 0: {
                if (this.frames <= 0 || this.frameNumber <= this.frames) break;
                this.cancel();
                return;
            }
            case 1: {
                if (this.frameNumber <= this.frames) break;
                this.frameNumber = 1;
                break;
            }
            case 2: {
                if (this.frameNumber > this.frames) {
                    this.forward = false;
                    this.frameNumber = this.frames - 1;
                    break;
                }
                if (this.frameNumber >= 0) break;
                this.forward = true;
                this.frameNumber = 1;
            }
        }
        if (this.timer != null) {
            if (this.filmstrip != null && this.filmstrip.getFrameCount() > this.frameNumber && this.filmstrip.getFrame(this.frameNumber) != null && this.display != null) {
                this.display.repaint();
            } else {
                this.drawFrame();
            }
            if (this.fireFrameEvents) {
                this.fireAnimationChangeEvent();
            }
            Thread.yield();
        }
    }

    public synchronized void cancel() {
        if (this.timer != null) {
            this.timer.stop();
            this.animationEnding();
            this.timer = null;
            this.paused = false;
            this.fireAnimationChangeEvent();
        }
    }

    protected void animationStarting() {
    }

    protected void animationEnding() {
    }

    public synchronized boolean isRunning() {
        return this.timer != null;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            return;
        }
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
        }
        this.changeListeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (changeListener != null && this.changeListeners != null) {
            this.changeListeners.remove(changeListener);
            if (this.changeListeners.isEmpty()) {
                this.changeListeners = null;
            }
        }
    }

    protected synchronized void fireAnimationChangeEvent() {
        if (this.changeListeners == null) {
            return;
        }
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            this.changeListeners.get(i).stateChanged(this.changeEvent);
        }
    }

    public String getStatusText(boolean bl) {
        return null;
    }
}

