/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vmm.core.Animation;

public abstract class ThreadedAnimation
implements Animation {
    private Thread runner;
    private volatile boolean running;
    private volatile boolean canceled;
    private volatile boolean paused;
    volatile double timeDilation;
    private ChangeEvent changeEvent;
    private ArrayList<ChangeListener> changeListeners;

    protected abstract void runAnimation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pause(int n) throws AnimationCanceledException {
        ThreadedAnimation threadedAnimation;
        if (this.canceled) {
            throw new AnimationCanceledException();
        }
        int n2 = (int)((double)n * this.timeDilation + 0.49);
        if (n > 0 && n2 == 0) {
            n2 = 1;
        }
        if (n2 <= 0) {
            Thread.yield();
        } else {
            threadedAnimation = this;
            synchronized (threadedAnimation) {
                try {
                    this.wait(n2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.canceled) {
            throw new AnimationCanceledException();
        }
        if (this.paused) {
            threadedAnimation = this;
            synchronized (threadedAnimation) {
                while (this.paused && !this.canceled) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (this.canceled) {
                throw new AnimationCanceledException();
            }
        }
    }

    public synchronized void start() {
        if (this.running) {
            return;
        }
        this.runner = new Thread(){

            public void run() {
                ThreadedAnimation.this.doRun();
            }
        };
        this.runner.start();
        this.running = true;
        this.canceled = false;
        this.paused = false;
        this.fireAnimationChangeEvent();
    }

    public synchronized void setPaused(boolean bl) {
        if (this.running) {
            this.paused = bl;
            this.notify();
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public synchronized void cancel() {
        if (!this.running) {
            return;
        }
        this.canceled = true;
        this.notify();
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    public void setTimeDilation(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.timeDilation = d;
    }

    public double getTimeDilation() {
        return this.timeDilation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun() {
        try {
            this.runAnimation();
        }
        catch (AnimationCanceledException animationCanceledException) {
        }
        catch (Exception exception) {
            System.out.println("Animation aborted by unexpected exception:  " + exception);
            exception.printStackTrace();
        }
        finally {
            this.doneRunning();
        }
    }

    private synchronized void doneRunning() {
        this.running = false;
        this.paused = false;
        this.runner = null;
        this.fireAnimationChangeEvent();
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            return;
        }
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
        }
        this.changeListeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (changeListener != null && this.changeListeners != null) {
            this.changeListeners.remove(changeListener);
            if (this.changeListeners.isEmpty()) {
                this.changeListeners = null;
            }
        }
    }

    protected synchronized void fireAnimationChangeEvent() {
        if (this.changeListeners == null) {
            return;
        }
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            this.changeListeners.get(i).stateChanged(this.changeEvent);
        }
    }

    public String getStatusText(boolean bl) {
        return null;
    }

    protected class AnimationCanceledException
    extends RuntimeException {
        protected AnimationCanceledException() {
        }
    }
}

