/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.util.ArrayList;
import java.util.Collection;
import vmm.functions.EvalStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskManager {
    private final ThreadPool threadPool;
    private boolean shutDown;
    private ArrayList<Job> activeJobs;
    private int nextJobForTask;

    public TaskManager() {
        this(0);
    }

    public TaskManager(int n) {
        if (n <= 0) {
            n = Runtime.getRuntime().availableProcessors();
        }
        this.activeJobs = new ArrayList();
        this.threadPool = new ThreadPool(this, n);
    }

    public synchronized void shutDown() {
        this.shutDown = true;
        for (Job job : this.activeJobs) {
            job.cancel();
        }
        this.notifyAll();
    }

    public int getThreadPoolSize() {
        return this.threadPool.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeAndWait(Collection<? extends Runnable> collection) {
        if (this.shutDown) {
            throw new IllegalStateException("Can't execute tasks after shutdown.");
        }
        if (collection == null) {
            throw new NullPointerException("The collection of tasks can't be null.");
        }
        if (this.getThreadPoolSize() == 1) {
            for (Runnable runnable : collection) {
                if (runnable == null) continue;
                runnable.run();
            }
        } else {
            Job job = this.executeAsync(collection);
            job.await(0);
        }
    }

    public synchronized Job executeAsync(Collection<? extends Runnable> collection) {
        if (this.shutDown) {
            throw new IllegalStateException("Can't execute tasks after shutdown.");
        }
        if (collection == null) {
            throw new NullPointerException("The collection of tasks can't be null.");
        }
        Job job = new Job(this, collection);
        job.close();
        this.activeJobs.add(job);
        this.notifyAll();
        return job;
    }

    public synchronized Job createJob() {
        if (this.shutDown) {
            throw new IllegalStateException("Can't execute tasks after shutdown.");
        }
        Job job = new Job(this, null);
        this.activeJobs.add(job);
        return job;
    }

    public synchronized boolean busy() {
        return this.activeJobs.size() > 0;
    }

    private synchronized void finish(Job job) {
        if (!this.shutDown) {
            int n = this.activeJobs.indexOf(job);
            if (n == -1) {
                return;
            }
            this.activeJobs.remove(n);
            if (n < this.nextJobForTask) {
                --this.nextJobForTask;
            }
        }
        this.notifyAll();
    }

    private synchronized Object[] nextTask() {
        Runnable runnable = null;
        Job job = null;
        while (runnable == null && !this.shutDown) {
            if (this.activeJobs.size() > 0) {
                if (this.nextJobForTask >= this.activeJobs.size()) {
                    this.nextJobForTask = 0;
                }
                int n = this.nextJobForTask;
                do {
                    job = this.activeJobs.get(n);
                    runnable = job.nextTask();
                    if (++n < this.activeJobs.size()) continue;
                    n = 0;
                } while (runnable == null && n != this.nextJobForTask);
            }
            if (runnable != null) continue;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.shutDown) {
            return null;
        }
        ++this.nextJobForTask;
        return new Object[]{runnable, job};
    }

    static /* synthetic */ Object[] access$300(TaskManager taskManager) {
        return taskManager.nextTask();
    }

    private static class ThreadPool {
        final Worker[] pool;
        final TaskManager owner;
        boolean shutDown;

        ThreadPool(TaskManager taskManager, int n) {
            this.owner = taskManager;
            this.pool = new Worker[n];
            int n2 = Thread.currentThread().getPriority();
            for (int i = 0; i < n; ++i) {
                this.pool[i] = new Worker();
                this.pool[i].setDaemon(true);
                try {
                    this.pool[i].setPriority(n2 - 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.pool[i].start();
            }
        }

        int getSize() {
            return this.pool.length;
        }

        class Worker
        extends Thread {
            Worker() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void run() {
                block11: {
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        if ((var3_3 = TaskManager.access$300(ThreadPool.this.owner)) == null) {
                            break block11;
                        }
                        var2_2 = (Runnable)var3_3[0];
                        var1_1 = (Job)var3_3[1];
                        var4_4 = true;
                        try {
                            var2_2.run();
                        }
                        catch (Throwable var5_5) {
                            var4_4 = false;
                        }
                        finally {
                            if (var4_4) {
                                Job.access$400(var1_1, var2_2);
                                continue;
                            }
                            Job.access$500(var1_1, var2_2);
                            continue;
                        }
                        break;
                    }
                    ** GOTO lbl-1000
                    finally {
                        EvalStack.perThreadRelease(this);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Job {
        private final TaskManager owner;
        private final ArrayList<Runnable> tasks;
        private volatile boolean closed;
        private volatile boolean finished;
        private volatile boolean canceled;
        private int nextTask;
        private volatile int finishedTaskCount;
        private volatile int failedTaskCount;
        private final ArrayList<Runnable> waitingFinishedTasks;
        private final ArrayList<Runnable> waitingFailedTasks;

        private Job(TaskManager taskManager, Collection<? extends Runnable> collection) {
            this.owner = taskManager;
            this.tasks = collection == null ? new ArrayList() : new ArrayList<Runnable>(collection);
            for (int i = this.tasks.size() - 1; i >= 0; --i) {
                if (this.tasks.get(i) != null) continue;
                this.tasks.remove(i);
            }
            this.waitingFinishedTasks = new ArrayList();
            this.waitingFailedTasks = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finish(Runnable runnable) {
            TaskManager taskManager = this.owner;
            synchronized (taskManager) {
                if (this.finished) {
                    return;
                }
                ++this.finishedTaskCount;
                this.waitingFinishedTasks.add(runnable);
                if (this.closed && this.finishedTaskCount + this.failedTaskCount == this.tasks.size()) {
                    this.finished = true;
                    this.owner.finish(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fail(Runnable runnable) {
            TaskManager taskManager = this.owner;
            synchronized (taskManager) {
                if (this.finished) {
                    return;
                }
                ++this.failedTaskCount;
                this.waitingFailedTasks.add(runnable);
                if (this.closed && this.finishedTaskCount + this.failedTaskCount == this.tasks.size()) {
                    this.finished = true;
                    this.owner.finish(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Runnable nextTask() {
            TaskManager taskManager = this.owner;
            synchronized (taskManager) {
                if (this.finished || this.nextTask >= this.tasks.size()) {
                    return null;
                }
                return this.tasks.get(this.nextTask++);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Runnable runnable) {
            if (runnable == null) {
                return;
            }
            if (this.closed) {
                throw new IllegalStateException("Can't add a new task to a job after the job has been closed.");
            }
            TaskManager taskManager = this.owner;
            synchronized (taskManager) {
                this.tasks.add(runnable);
                this.owner.notifyAll();
            }
        }

        public synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.finishedTaskCount + this.failedTaskCount == this.tasks.size()) {
                this.finished = true;
                this.owner.finish(this);
            }
        }

        public double fractionDone() {
            if (this.tasks.size() == 0) {
                return 1.0;
            }
            return (double)(this.finishedTaskCount + this.failedTaskCount) / (double)this.tasks.size();
        }

        public int finishedTaskCount() {
            return this.finishedTaskCount;
        }

        public int failedTaskCount() {
            return this.failedTaskCount;
        }

        public int totalTaskCount() {
            return this.tasks.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            TaskManager taskManager = this.owner;
            synchronized (taskManager) {
                this.finished = true;
                this.canceled = true;
                this.closed = true;
                this.owner.finish(this);
                this.owner.notifyAll();
            }
        }

        public boolean isFinished() {
            return this.finished;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Runnable[] finishedTasks() {
            TaskManager taskManager = this.owner;
            synchronized (taskManager) {
                if (this.waitingFinishedTasks.size() == 0) {
                    return new Runnable[0];
                }
                Runnable[] runnableArray = new Runnable[this.waitingFinishedTasks.size()];
                this.waitingFinishedTasks.toArray(runnableArray);
                this.waitingFinishedTasks.clear();
                return runnableArray;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Runnable[] failedTasks() {
            TaskManager taskManager = this.owner;
            synchronized (taskManager) {
                if (this.waitingFailedTasks.size() == 0) {
                    return new Runnable[0];
                }
                Runnable[] runnableArray = new Runnable[this.waitingFailedTasks.size()];
                this.waitingFailedTasks.toArray(runnableArray);
                this.waitingFailedTasks.clear();
                return runnableArray;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean await(int n) {
            TaskManager taskManager = this.owner;
            synchronized (taskManager) {
                if (this.finished) {
                    return true;
                }
                try {
                    if (n <= 0) {
                        this.owner.wait();
                    } else {
                        this.owner.wait(n);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.finished;
            }
        }

        static /* synthetic */ void access$400(Job job, Runnable runnable) {
            job.finish(runnable);
        }

        static /* synthetic */ void access$500(Job job, Runnable runnable) {
            job.fail(runnable);
        }
    }
}

