/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import vmm.core.I18n;

public abstract class SettingsDialog
extends JDialog {
    protected JButton okButton;
    protected JButton defaultsButton;
    protected JButton cancelButton;
    protected JButton applyButton;
    protected boolean canceled;
    protected JPanel contentPanel;
    protected JPanel buttonBar;

    protected SettingsDialog(Component component, String string) {
        this(component, string, true, true);
    }

    protected SettingsDialog(Component component, String string, boolean bl, boolean bl2) {
        super(SettingsDialog.frameAncestor(component), string, true);
        this.setDefaultCloseOperation(0);
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout());
        this.buttonBar = new JPanel();
        this.buttonBar.setLayout(new FlowLayout(2, 7, 7));
        this.buttonBar.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.contentPanel.add((Component)this.buttonBar, "South");
        this.setContentPane(this.contentPanel);
        this.okButton = new JButton(I18n.tr("buttonNames.OK"));
        this.defaultsButton = new JButton(I18n.tr("buttonNames.Defaults"));
        this.cancelButton = new JButton(I18n.tr("buttonNames.Cancel"));
        this.applyButton = new JButton(I18n.tr("buttonNames.Apply"));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == SettingsDialog.this.okButton) {
                    if (SettingsDialog.this.doOK()) {
                        SettingsDialog.this.canceled = false;
                        SettingsDialog.this.dispose();
                    }
                } else if (object == SettingsDialog.this.applyButton) {
                    SettingsDialog.this.doApply();
                } else if (object == SettingsDialog.this.defaultsButton) {
                    SettingsDialog.this.doDefaults();
                } else if (object == SettingsDialog.this.cancelButton) {
                    SettingsDialog.this.doCancel();
                }
            }
        };
        this.okButton.addActionListener(actionListener);
        this.defaultsButton.addActionListener(actionListener);
        this.cancelButton.addActionListener(actionListener);
        this.applyButton.addActionListener(actionListener);
        this.buttonBar.add(this.cancelButton);
        if (bl) {
            this.buttonBar.add(this.defaultsButton);
        }
        if (bl2) {
            this.buttonBar.add(this.applyButton);
        }
        this.buttonBar.add(this.okButton);
        this.setDefaultCloseOperation(0);
        this.buttonBar.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "cancel");
        this.buttonBar.getInputMap(2).put(KeyStroke.getKeyStroke("ENTER"), "ok");
        this.buttonBar.getActionMap().put("cancel", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SettingsDialog.this.cancelButton.doClick();
            }
        });
        this.buttonBar.getActionMap().put("ok", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SettingsDialog.this.okButton.doClick();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SettingsDialog.this.doCancel();
            }
        });
        JFrame jFrame = SettingsDialog.frameAncestor(component);
        if (jFrame != null) {
            Point point = jFrame.getLocation();
            this.setLocation(point.x + 25, point.y + 45);
        }
        this.setResizable(false);
    }

    private static JFrame frameAncestor(Component component) {
        while (component != null && !(component instanceof JFrame)) {
            component = component.getParent();
        }
        return (JFrame)component;
    }

    protected void addInputPanel(JComponent jComponent) {
        jComponent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.contentPanel.add((Component)jComponent, "Center");
        this.pack();
    }

    protected void addInfoLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.contentPanel.add((Component)jLabel, "North");
        this.pack();
    }

    protected JButton defaultsButton() {
        return this.defaultsButton;
    }

    protected JPanel borderedPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), string), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        return jPanel;
    }

    protected void doDefaults() {
    }

    protected void doCancel() {
        this.canceled = true;
        this.dispose();
    }

    protected void doApply() {
        this.doOK();
    }

    protected abstract boolean doOK();
}

