/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import vmm.core.I18n;
import vmm.core.ParameterInput;
import vmm.core.RealParam;
import vmm.core.SettingsDialog;
import vmm.core.Transform;
import vmm.core.View;

public class SetXYWindowDialog
extends SettingsDialog {
    private RealParam xmin;
    private RealParam xmax;
    private RealParam ymin;
    private RealParam ymax;
    private ParameterInput xminInput;
    private ParameterInput xmaxInput;
    private ParameterInput yminInput;
    private ParameterInput ymaxInput;
    private View view;

    public static void showDialog(View view) {
        new SetXYWindowDialog(view).setVisible(true);
    }

    protected SetXYWindowDialog(View view) {
        super(view.getDisplay(), I18n.tr("vmm.core.dialogtitle.SetXYWindowDialog"), true, true);
        this.view = view;
        Transform transform = view.getTransform();
        this.xmin = new RealParam("vmm.core.dialogtitle.SetXYWindowDialog.xmin", transform.getXminRequested());
        this.xmax = new RealParam("vmm.core.dialogtitle.SetXYWindowDialog.xmax", transform.getXmaxRequested());
        this.ymin = new RealParam("vmm.core.dialogtitle.SetXYWindowDialog.ymin", transform.getYminRequested());
        this.ymax = new RealParam("vmm.core.dialogtitle.SetXYWindowDialog.ymax", transform.getYmaxRequested());
        this.xminInput = new ParameterInput(this.xmin);
        this.xmaxInput = new ParameterInput(this.xmax);
        this.yminInput = new ParameterInput(this.ymin);
        this.ymaxInput = new ParameterInput(this.ymax);
        this.xminInput.setColumns(7);
        this.xmaxInput.setColumns(7);
        this.yminInput.setColumns(7);
        this.ymaxInput.setColumns(7);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 4, 5, 5));
        jPanel.add(new JLabel(this.xmin.getTitle() + ": ", 4));
        jPanel.add(this.xminInput);
        jPanel.add(new JLabel(this.xmax.getTitle() + ": ", 4));
        jPanel.add(this.xmaxInput);
        jPanel.add(new JLabel(this.ymin.getTitle() + ": ", 4));
        jPanel.add(this.yminInput);
        jPanel.add(new JLabel(this.ymax.getTitle() + ": ", 4));
        jPanel.add(this.ymaxInput);
        this.addInputPanel(jPanel);
        this.addInfoLabel(I18n.tr("vmm.core.SetXYWindowDialog.info"));
    }

    protected boolean doOK() {
        String string = this.xminInput.checkContents();
        if (string != null) {
            JOptionPane.showMessageDialog(this, string, I18n.tr("vmm.core.SettingsDialog.errorTitle"), 0);
            this.xminInput.selectAll();
            this.xminInput.requestFocus();
            return false;
        }
        string = this.xmaxInput.checkContents();
        if (string != null) {
            JOptionPane.showMessageDialog(this, string, I18n.tr("vmm.core.SettingsDialog.errorTitle"), 0);
            this.xmaxInput.selectAll();
            this.xmaxInput.requestFocus();
            return false;
        }
        string = this.yminInput.checkContents();
        if (string != null) {
            JOptionPane.showMessageDialog(this, string, I18n.tr("vmm.core.SettingsDialog.errorTitle"), 0);
            this.yminInput.selectAll();
            this.yminInput.requestFocus();
            return false;
        }
        string = this.ymaxInput.checkContents();
        if (string != null) {
            JOptionPane.showMessageDialog(this, string, I18n.tr("vmm.core.SettingsDialog.errorTitle"), 0);
            this.ymaxInput.selectAll();
            this.ymaxInput.requestFocus();
            return false;
        }
        this.xminInput.setValueFromContents();
        this.xmaxInput.setValueFromContents();
        this.yminInput.setValueFromContents();
        this.ymaxInput.setValueFromContents();
        if (this.xmin.getValue() >= this.xmax.getValue()) {
            JOptionPane.showMessageDialog(this, I18n.tr("vmm.core.SetXYWindowDialog.XmaxLessThanXminError"), I18n.tr("vmm.core.SettingsDialog.errorTitle"), 0);
            this.xminInput.selectAll();
            this.xminInput.requestFocus();
            return false;
        }
        if (this.ymin.getValue() >= this.ymax.getValue()) {
            JOptionPane.showMessageDialog(this, I18n.tr("vmm.core.SetXYWindowDialog.YmaxLessThanYminError"), I18n.tr("vmm.core.SettingsDialog.errorTitle"), 0);
            this.yminInput.selectAll();
            this.yminInput.requestFocus();
            return false;
        }
        this.view.getTransform().setLimits(this.xmin.getValue(), this.xmax.getValue(), this.ymin.getValue(), this.ymax.getValue());
        return true;
    }

    protected void doDefaults() {
        double[] dArray = this.view.getExhibit().getDefaultWindow();
        this.xminInput.setText("" + dArray[0]);
        this.xmaxInput.setText("" + dArray[1]);
        this.yminInput.setText("" + dArray[2]);
        this.ymaxInput.setText("" + dArray[3]);
    }
}

