/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import vmm.core.Exhibit;
import vmm.core.Filmstrip;
import vmm.core.I18n;
import vmm.core.IntegerParam;
import vmm.core.ParameterInput;
import vmm.core.SettingsDialog;
import vmm.core.View;

public class SetNumberOfFramesDialog
extends SettingsDialog {
    private Exhibit exhibit;
    private IntegerParam numberOfFramesForMorphing;
    private JCheckBox useFilmstripForMorphing;
    protected ParameterInput numberOfFramesForMorphingInput;

    public static void showDialog(View view) {
        new SetNumberOfFramesDialog(view).setVisible(true);
    }

    private SetNumberOfFramesDialog(View view) {
        super(view.getDisplay(), I18n.tr("vmm.core.dialogtitle.SetNumberOfFrames"), false, false);
        this.exhibit = view.getExhibit();
        this.numberOfFramesForMorphing = new IntegerParam(I18n.tr("vmm.core.SetNumberOfFramesDialog.FramesForMorphing", "x"), this.exhibit.getFramesForMorphing());
        this.numberOfFramesForMorphingInput = new ParameterInput(this.numberOfFramesForMorphing);
        this.numberOfFramesForMorphingInput.setColumns(4);
        this.numberOfFramesForMorphing.setMinimumValueForInput(2);
        this.numberOfFramesForMorphing.setMaximumValueForInput(1000);
        this.useFilmstripForMorphing = new JCheckBox(I18n.tr("vmm.core.SetNumberOfFramesDialog.UseFilmstrip"));
        this.useFilmstripForMorphing.setSelected(this.exhibit.getUseFilmstripForMorphing());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 1, 8, 8));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(8, 8));
        jPanel2.add((Component)this.numberOfFramesForMorphingInput, "Center");
        jPanel2.add((Component)new JLabel(this.numberOfFramesForMorphing.getName() + ": "), "West");
        jPanel.add(jPanel2);
        jPanel.add(this.useFilmstripForMorphing);
        int n = Filmstrip.maxFrames(view.getDisplay().getWidth(), view.getDisplay().getHeight(), true);
        if (n > 0) {
            --n;
        }
        jPanel.add(new JLabel(I18n.tr("vmm.core.SetNumberOfFramesDialog.FramesAvailable", "" + n), 4));
        this.addInputPanel(jPanel);
    }

    protected boolean doOK() {
        String string = this.numberOfFramesForMorphingInput.checkContents();
        if (string != null) {
            JOptionPane.showMessageDialog(this, string, I18n.tr("vmm.core.SettingsDialog.errorTitle"), 0);
            return false;
        }
        this.numberOfFramesForMorphingInput.setValueFromContents();
        this.exhibit.setFramesForMorphing(this.numberOfFramesForMorphing.getValue());
        this.exhibit.setUseFilmstripForMorphing(this.useFilmstripForMorphing.isSelected());
        return true;
    }
}

