/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import vmm.core.Animateable;
import vmm.core.Complex;
import vmm.core.ComplexParam;
import vmm.core.Decoration;
import vmm.core.Exhibit;
import vmm.core.I18n;
import vmm.core.IntegerParam;
import vmm.core.Parameter;
import vmm.core.RealParam;
import vmm.core.Transform;
import vmm.core.UserExhibit;
import vmm.core.Util;
import vmm.core.VMMSave;
import vmm.core.View;

public class SaveAndRestore {
    public static Exhibit readExhibitFromXML(File file) throws IOException {
        return SaveAndRestore.readExhibitFromXML(new FileInputStream(file), file.getName());
    }

    public static Exhibit convertXMLToExhibit(Document document) {
        try {
            Exhibit exhibit;
            Element element = document.getDocumentElement();
            if (!element.getTagName().equals("exhibit-info")) {
                throw new IllegalArgumentException();
            }
            Element element2 = SaveAndRestore.getChildElement(element, "exhibit");
            if (element2 == null) {
                throw new IllegalArgumentException();
            }
            if (element.getElementsByTagName("exhibit").getLength() > 1) {
                throw new IllegalArgumentException();
            }
            try {
                exhibit = SaveAndRestore.buildExhibitFromElement(element2);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException();
            }
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || !((Element)node).getTagName().equals("view")) continue;
                Element element3 = (Element)node;
                SaveAndRestore.buildViewFromElement(element3, exhibit);
            }
            return exhibit;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(I18n.tr("vmm.core.SaveAndRestore.error.NotValidExhibitDocument"));
        }
    }

    public static Exhibit readExhibitFromXML(InputStream inputStream, String string) throws IOException {
        Exhibit exhibit;
        Document document = SaveAndRestore.readXMLDocument(inputStream, string);
        Element element = document.getDocumentElement();
        if (!element.getTagName().equals("exhibit-info")) {
            throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.NotAnExhibitInfoFile", string, element.getTagName()));
        }
        Element element2 = SaveAndRestore.getChildElement(element, "exhibit");
        if (element2 == null) {
            throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.MissingExhibitElement", string));
        }
        if (element.getElementsByTagName("exhibit").getLength() > 1) {
            throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.TooManyExhibitElements", string));
        }
        try {
            exhibit = SaveAndRestore.buildExhibitFromElement(element2);
        }
        catch (Exception exception) {
            throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.IllegalDataInFile", string, exception.getMessage()));
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !((Element)node).getTagName().equals("view")) continue;
            Element element3 = (Element)node;
            SaveAndRestore.buildViewFromElement(element3, exhibit);
        }
        return exhibit;
    }

    public static Document readXMLDocument(File file) throws IOException {
        return SaveAndRestore.readXMLDocument(new FileInputStream(file), file.getName());
    }

    public static Document readXMLDocument(InputStream inputStream, String string) throws IOException {
        Document document;
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exception) {
            throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.CantGetDocumentBuilder"));
        }
        try {
            document = documentBuilder.parse(inputStream);
        }
        catch (SAXException sAXException) {
            throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.IllegalXMLFile", string, sAXException.getMessage()));
        }
        catch (IOException iOException) {
            throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.InputError", string, iOException.getMessage()));
        }
        return document;
    }

    public static Document exhibitToXML(Exhibit exhibit, View view) {
        View[] viewArray;
        if (view == null) {
            viewArray = null;
        } else {
            View[] viewArray2 = new View[1];
            viewArray = viewArray2;
            viewArray2[0] = view;
        }
        return SaveAndRestore.exhibitToXML(exhibit, viewArray);
    }

    public static Document exhibitToXML(Exhibit exhibit) {
        ArrayList<View> arrayList = exhibit.getViews();
        if (arrayList == null || arrayList.size() == 0) {
            return SaveAndRestore.exhibitToXML(exhibit, (View[])null);
        }
        View[] viewArray = new View[arrayList.size()];
        arrayList.toArray(viewArray);
        return SaveAndRestore.exhibitToXML(exhibit, viewArray);
    }

    public static Document exhibitToXML(Exhibit exhibit, View[] viewArray) {
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exception) {
            throw new RuntimeException(I18n.tr("vmm.core.SaveAndRestore.error.CantGetDocumentBuilder"));
        }
        Document document = documentBuilder.getDOMImplementation().createDocument(null, "exhibit-info", null);
        Element element = document.getDocumentElement();
        Element element2 = document.createElement("exhibit");
        element.appendChild(element2);
        SaveAndRestore.buildExhibitElement(document, element2, exhibit);
        if (viewArray != null) {
            for (int i = 0; i < viewArray.length; ++i) {
                Element element3 = document.createElement("view");
                SaveAndRestore.buildViewElement(document, element3, viewArray[i]);
                element.appendChild(element3);
            }
        }
        return document;
    }

    public static void writeXMLDocument(PrintWriter printWriter, Document document) {
        printWriter.println("<?xml version=\"1.0\"?>");
        SaveAndRestore.writeElement(printWriter, document.getDocumentElement(), "");
    }

    public static void addProperties(Object object, String[] stringArray, Document document, Element element) {
        for (int i = 0; i < stringArray.length; ++i) {
            SaveAndRestore.addProperty(object, stringArray[i], document, element);
        }
    }

    public static void addProperty(Object object, String string, Document document, Element element) {
        Element element2 = document.createElement("property");
        try {
            Method method = new PropertyDescriptor(string, object.getClass()).getReadMethod();
            Object object2 = method.invoke(object, (Object[])null);
            String string2 = Util.toExternalString(object2);
            element2.setAttribute("name", string);
            element2.setAttribute("value", string2);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Can't access property \"" + string + "\".");
        }
        element.appendChild(element2);
    }

    public static void readProperties(Object object, Element element) throws IOException {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !((Element)node).getTagName().equals("property")) continue;
            Element element2 = (Element)node;
            String string = element2.getAttribute("name").trim();
            if (string.length() == 0) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.MissingPropertyName"));
            }
            if (!element2.hasAttribute("value")) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.MissingValueAttribute", "property/" + string));
            }
            try {
                Method method;
                String string2 = element2.getAttribute("value");
                try {
                    method = new PropertyDescriptor(string, object.getClass()).getWriteMethod();
                }
                catch (IntrospectionException introspectionException) {
                    continue;
                }
                Class<?>[] classArray = method.getParameterTypes();
                Object object2 = Util.externalStringToValue(string2, classArray[0]);
                method.invoke(object, object2);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.ErrorReadingProperty", string, exception.getMessage()));
            }
        }
    }

    public static void addDecorationElement(Document document, Element element, Decoration decoration) {
        Element element2 = document.createElement("decoration");
        String string = decoration.getClass().getName();
        element2.setAttribute("class", string);
        SaveAndRestore.addSavedProperties(decoration, document, element2);
        decoration.addExtraXML(document, element2);
        element.appendChild(element2);
    }

    public static void addElement(Document document, Element element, String string, Object object) {
        Element element2 = document.createElement(string);
        element2.setAttribute("value", Util.toExternalString(object));
        element.appendChild(element2);
    }

    public static Object getChildElementValue(Element element, String string, Class clazz) {
        Element element2 = SaveAndRestore.getChildElement(element, string);
        if (element2 == null) {
            return null;
        }
        String string2 = element2.getAttribute("value");
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        try {
            return Util.externalStringToValue(string2, clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Element makeTransformElement(String string, Document document, Transform transform) {
        Element element = document.createElement(string);
        element.setAttribute("class", transform.getClass().getName());
        Element element2 = document.createElement("window");
        element2.setAttribute("limits", transform.getXminRequested() + " " + transform.getXmaxRequested() + " " + transform.getYminRequested() + " " + transform.getYmaxRequested());
        element.appendChild(element2);
        SaveAndRestore.addSavedProperties(transform, document, element);
        return element;
    }

    public static Transform buildTransformFromElement(Element element) throws IOException {
        Transform transform;
        String string = element.getAttribute("class");
        try {
            transform = (Transform)SaveAndRestore.createObjectFromClassName(string, null);
        }
        catch (Exception exception) {
            throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.CantMakeObject", string));
        }
        Element element2 = SaveAndRestore.getChildElement(element, "window");
        if (element2 != null) {
            double[] dArray;
            String string2 = element2.getAttribute("limits");
            try {
                dArray = (double[])Util.externalStringToValue(string2, double[].class);
            }
            catch (Exception exception) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", string2, "window"));
            }
            if (dArray.length != 4) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", string2, "window"));
            }
            transform.setLimits(dArray[0], dArray[1], dArray[2], dArray[3]);
        }
        if (transform != null) {
            SaveAndRestore.readProperties(transform, element);
        }
        return transform;
    }

    public static Element getChildElement(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !((Element)node).getTagName().equals(string)) continue;
            return (Element)node;
        }
        return null;
    }

    private static Object createObjectFromClassName(String string, Object object) throws Exception {
        Class<?> clazz = Class.forName(string);
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            Class<?>[] classArray;
            int n;
            if (object == null) {
                throw new Exception();
            }
            Object var3_4 = null;
            Constructor<?>[] constructorArray = clazz.getConstructors();
            for (n = 0; n < constructorArray.length; ++n) {
                classArray = constructorArray[n].getParameterTypes();
                if (classArray == null || classArray.length != 1 || !classArray[0].isInstance(object)) continue;
                var3_4 = constructorArray[n].newInstance(object);
                break;
            }
            if (var3_4 == null && object instanceof View && ((View)object).getExhibit() != null) {
                object = ((View)object).getExhibit();
                for (n = 0; n < constructorArray.length; ++n) {
                    classArray = constructorArray[n].getParameterTypes();
                    if (classArray == null || classArray.length != 1 || !classArray[0].isInstance(object)) continue;
                    var3_4 = constructorArray[n].newInstance(object);
                    break;
                }
            }
            if (var3_4 == null) {
                throw new Exception();
            }
            return var3_4;
        }
    }

    private static void writeElement(PrintWriter printWriter, Element element, String string) {
        NodeList nodeList;
        String string2 = element.getTagName();
        printWriter.print(string + "<" + string2);
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                printWriter.print(" " + attr.getName() + "=\"" + attr.getValue() + "\"");
            }
        }
        if ((nodeList = element.getChildNodes()).getLength() == 0) {
            printWriter.println("/>");
        } else {
            printWriter.println(">");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                SaveAndRestore.writeElement(printWriter, (Element)nodeList.item(i), string + "   ");
            }
            printWriter.println(string + "</" + string2 + ">");
        }
    }

    private static void buildExhibitElement(Document document, Element element, Exhibit exhibit) {
        Class<?> clazz;
        String string = exhibit.getClass().getName();
        element.setAttribute("class", string);
        if (!string.equals(exhibit.getName())) {
            element.setAttribute("name", exhibit.getName());
        }
        Parameter[] parameterArray = exhibit.getParameters();
        for (int i = parameterArray.length - 1; i >= 0; --i) {
            Element element2 = document.createElement("parameter");
            SaveAndRestore.buildParameterElement(document, element2, parameterArray[i]);
            element.appendChild(element2);
        }
        Decoration[] decorationArray = exhibit.getDecorations();
        for (int i = 0; i < decorationArray.length; ++i) {
            clazz = decorationArray[i].getClass();
            if (clazz.getAnnotation(VMMSave.class) == null) continue;
            SaveAndRestore.addDecorationElement(document, element, decorationArray[i]);
        }
        SaveAndRestore.addSavedProperties(exhibit, document, element);
        exhibit.addExtraXML(document, element);
        if (exhibit instanceof UserExhibit) {
            UserExhibit.Support support = ((UserExhibit)((Object)exhibit)).getUserExhibitSupport();
            clazz = document.createElement("userdata");
            support.addToXML(document, (Element)((Object)clazz));
            element.appendChild((Node)((Object)clazz));
        }
    }

    static void buildParameterElement(Document document, Element element, Parameter parameter) {
        String string = parameter.getClass().getName();
        element.setAttribute("class", string);
        String string2 = parameter.getName();
        if (string2 != null) {
            element.setAttribute("name", string2);
        }
        Element element2 = document.createElement("value");
        element2.setAttribute("value", parameter.getValueAsString());
        element2.setAttribute("default", parameter.getDefaultValueAsString());
        if (parameter instanceof IntegerParam) {
            int n = ((IntegerParam)parameter).getMinimumValueForInput();
            int n2 = ((IntegerParam)parameter).getMaximumValueForInput();
            if (n > Integer.MIN_VALUE) {
                element2.setAttribute("min", "" + n);
            }
            if (n2 < Integer.MAX_VALUE) {
                element2.setAttribute("max", "" + n2);
            }
        } else if (parameter instanceof RealParam) {
            double d = ((RealParam)parameter).getMinimumValueForInput();
            double d2 = ((RealParam)parameter).getMaximumValueForInput();
            if (d > Double.NEGATIVE_INFINITY) {
                element2.setAttribute("min", Util.toExternalString(new Double(d)));
            }
            if (d2 < Double.POSITIVE_INFINITY) {
                element2.setAttribute("max", Util.toExternalString(new Double(d2)));
            }
        } else if (parameter instanceof ComplexParam) {
            Complex complex = ((ComplexParam)parameter).getMinimumValueForInput();
            Complex complex2 = ((ComplexParam)parameter).getMaximumValueForInput();
            if (complex.re > Double.NEGATIVE_INFINITY) {
                element2.setAttribute("min_re", Util.toExternalString(new Double(complex.re)));
            }
            if (complex2.re < Double.POSITIVE_INFINITY) {
                element2.setAttribute("max_re", Util.toExternalString(new Double(complex2.re)));
            }
            if (complex.im > Double.NEGATIVE_INFINITY) {
                element2.setAttribute("min_im", Util.toExternalString(new Double(complex.im)));
            }
            if (complex2.im < Double.POSITIVE_INFINITY) {
                element2.setAttribute("max_im", Util.toExternalString(new Double(complex2.im)));
            }
        }
        element.appendChild(element2);
        if (parameter instanceof Animateable) {
            Animateable animateable = (Animateable)((Object)parameter);
            Element element3 = document.createElement("start");
            element3.setAttribute("value", animateable.getAnimationStartAsString());
            element3.setAttribute("default", animateable.getDefaultAnimationStartAsString());
            element.appendChild(element3);
            Element element4 = document.createElement("end");
            element4.setAttribute("value", animateable.getAnimationEndAsString());
            element4.setAttribute("default", animateable.getDefaultAnimationEndAsString());
            element.appendChild(element4);
        }
    }

    private static void buildViewElement(Document document, Element element, View view) {
        Class<?> clazz;
        String string = view.getClass().getName();
        element.setAttribute("class", string);
        if (!string.equals(view.getName())) {
            element.setAttribute("name", view.getName());
        }
        Parameter[] parameterArray = view.getParameters();
        for (int i = parameterArray.length - 1; i >= 0; --i) {
            Element element2 = document.createElement("parameter");
            SaveAndRestore.buildParameterElement(document, element2, parameterArray[i]);
            element.appendChild(element2);
        }
        Decoration[] decorationArray = view.getDecorations();
        for (int i = 0; i < decorationArray.length; ++i) {
            clazz = decorationArray[i].getClass();
            if (clazz.getAnnotation(VMMSave.class) == null) continue;
            SaveAndRestore.addDecorationElement(document, element, decorationArray[i]);
        }
        Transform transform = view.getTransform();
        if (transform != null) {
            clazz = SaveAndRestore.makeTransformElement("transform", document, transform);
            element.appendChild((Node)((Object)clazz));
        }
        SaveAndRestore.addSavedProperties(view, document, element);
        view.addExtraXML(document, element);
    }

    private static void addSavedProperties(Object object, Document document, Element element) {
        Class<?> clazz = object.getClass();
        while (!clazz.equals(Object.class)) {
            Field[] fieldArray;
            for (Field field : fieldArray = clazz.getDeclaredFields()) {
                if (field.getAnnotation(VMMSave.class) == null) continue;
                String string = field.getName();
                SaveAndRestore.addProperty(object, string, document, element);
            }
            clazz = clazz.getSuperclass();
        }
    }

    private static Exhibit buildExhibitFromElement(Element element) throws IOException {
        Exhibit exhibit;
        String string = element.getAttribute("class").trim();
        if (string.trim().length() == 0) {
            throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.MissingClassNameForExhibit"));
        }
        try {
            exhibit = (Exhibit)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.CantMakeObject", string));
        }
        String string2 = element.getAttribute("name").trim();
        if (string2.length() > 0) {
            exhibit.setName(string2);
        }
        NodeList nodeList = element.getChildNodes();
        Element element2 = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Element element3;
            Node node = nodeList.item(i);
            if (node instanceof Element && ((Element)node).getTagName().equals("parameter")) {
                element3 = (Element)node;
                string = element3.getAttribute("class").trim();
                if (string.length() == 0) {
                    throw new IOException("vmm.core.SaveAndRestore.error.MissingClassNameForParameter");
                }
                string2 = element3.getAttribute("name").trim();
                object = null;
                if (string2.length() > 0) {
                    object = exhibit.getParameterByName(string2);
                }
                if (object == null) {
                    try {
                        object = (Parameter)SaveAndRestore.createObjectFromClassName(string, exhibit);
                    }
                    catch (Exception exception) {
                        throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.CantMakeObject", string));
                    }
                    if (string2.length() > 0) {
                        ((Parameter)object).setName(string2);
                    }
                    exhibit.addParameter((Parameter)object);
                }
                SaveAndRestore.setParamInfoFromElement((Parameter)object, element3);
                continue;
            }
            if (node instanceof Element && ((Element)node).getTagName().equals("decoration")) {
                element3 = (Element)node;
                string = element3.getAttribute("class");
                if (string.length() == 0) {
                    throw new IOException("vmm.core.SaveAndRestore.error.MissingClassNameForDecoration");
                }
                try {
                    object = (Decoration)SaveAndRestore.createObjectFromClassName(string, exhibit);
                }
                catch (Exception exception) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.CantMakeObject", string));
                }
                SaveAndRestore.readProperties(object, element3);
                ((Decoration)object).readExtraXML(element3);
                exhibit.addDecoration((Decoration)object);
                continue;
            }
            if (!(node instanceof Element) || !((Element)node).getTagName().equals("userdata")) continue;
            element2 = (Element)node;
        }
        SaveAndRestore.readProperties(exhibit, element);
        exhibit.readExtraXML(element);
        if (exhibit instanceof UserExhibit) {
            if (element2 == null) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.MissingUserData"));
            }
            UserExhibit.Support support = ((UserExhibit)((Object)exhibit)).getUserExhibitSupport();
            support.readFromXML(element2);
        }
        return exhibit;
    }

    static void setParamInfoFromElement(Parameter parameter, Element element) throws IOException {
        Object object;
        String string;
        Object object2;
        Element element2 = SaveAndRestore.getChildElement(element, "value");
        if (element2 != null) {
            object2 = element2.getAttribute("value").trim();
            string = element2.getAttribute("default").trim();
            if (((String)object2).length() == 0) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.MissingValueAttribute", "value"));
            }
            try {
                parameter.setValueFromString((String)object2);
            }
            catch (Exception exception) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", object2, "value"));
            }
            if (string.length() > 0) {
                try {
                    parameter.setDefaultValueFromString(string);
                }
                catch (Exception exception) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", object2, "default"));
                }
            }
        }
        if (parameter instanceof IntegerParam) {
            object2 = element2.getAttribute("min").trim();
            string = element2.getAttribute("max").trim();
            if (((String)object2).length() > 0) {
                try {
                    ((IntegerParam)parameter).setMinimumValueForInput(Integer.parseInt((String)object2));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", object2, "min"));
                }
            }
            if (string.length() > 0) {
                try {
                    ((IntegerParam)parameter).setMaximumValueForInput(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", string, "max"));
                }
            }
        } else if (parameter instanceof RealParam) {
            object2 = element2.getAttribute("min").trim();
            string = element2.getAttribute("max").trim();
            if (((String)object2).length() > 0) {
                try {
                    object = (Double)Util.externalStringToValue((String)object2, Double.TYPE);
                    ((RealParam)parameter).setMinimumValueForInput((Double)object);
                }
                catch (Exception exception) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", object2, "min"));
                }
            }
            if (string.length() > 0) {
                try {
                    object = (Double)Util.externalStringToValue(string, Double.TYPE);
                    ((RealParam)parameter).setMaximumValueForInput((Double)object);
                }
                catch (Exception exception) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", string, "max"));
                }
            }
        } else if (parameter instanceof ComplexParam) {
            Double d;
            object2 = element2.getAttribute("min_re").trim();
            string = element2.getAttribute("max_re").trim();
            object = element2.getAttribute("min_im").trim();
            String string2 = element2.getAttribute("max_im").trim();
            Complex complex = new Complex(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            Complex complex2 = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            if (((String)object2).length() > 0) {
                try {
                    d = (Double)Util.externalStringToValue((String)object2, Double.TYPE);
                    complex.re = d;
                }
                catch (Exception exception) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", object2, "min_re"));
                }
            }
            if (((String)object).length() > 0) {
                try {
                    d = (Double)Util.externalStringToValue((String)object, Double.TYPE);
                    complex.im = d;
                }
                catch (Exception exception) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", object, "min_in"));
                }
            }
            if (string.length() > 0) {
                try {
                    d = (Double)Util.externalStringToValue(string, Double.TYPE);
                    complex2.re = d;
                }
                catch (Exception exception) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", string, "max_re"));
                }
            }
            if (string2.length() > 0) {
                try {
                    d = (Double)Util.externalStringToValue(string2, Double.TYPE);
                    complex2.im = d;
                }
                catch (Exception exception) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", string2, "max_in"));
                }
            }
            ((ComplexParam)parameter).setMinimumValueForInput(complex);
            ((ComplexParam)parameter).setMaximumValueForInput(complex2);
        }
        if (!(parameter instanceof Animateable)) {
            return;
        }
        object2 = (Animateable)((Object)parameter);
        element2 = SaveAndRestore.getChildElement(element, "start");
        if (element2 != null) {
            string = element2.getAttribute("value").trim();
            object = element2.getAttribute("default").trim();
            if (string.length() == 0) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.MissingValueAttribute", "value"));
            }
            try {
                object2.setAnimationStartFromString(string);
            }
            catch (Exception exception) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", string, "value"));
            }
            if (((String)object).length() > 0) {
                try {
                    object2.setDefaultAnimationStartFromString((String)object);
                }
                catch (Exception exception) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", string, "default"));
                }
            }
        }
        if ((element2 = SaveAndRestore.getChildElement(element, "end")) != null) {
            string = element2.getAttribute("value").trim();
            object = element2.getAttribute("default").trim();
            if (string.length() == 0) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.MissingValueAttribute", "value"));
            }
            try {
                object2.setAnimationEndFromString(string);
            }
            catch (Exception exception) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", string, "value"));
            }
            if (((String)object).length() > 0) {
                try {
                    object2.setDefaultAnimationEndFromString((String)object);
                }
                catch (Exception exception) {
                    throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.BadValueAttribute", string, "default"));
                }
            }
        }
    }

    private static void buildViewFromElement(Element element, Exhibit exhibit) throws IOException {
        Object object;
        View view;
        String string = element.getAttribute("class").trim();
        if (string.trim().length() == 0) {
            throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.MissingClassNameForView"));
        }
        try {
            view = (View)SaveAndRestore.createObjectFromClassName(string, exhibit);
        }
        catch (Exception exception) {
            throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.CantMakeObject", string));
        }
        String string2 = element.getAttribute("name").trim();
        if (string2.length() > 0) {
            view.setName(string2);
        }
        view.setExhibit(exhibit);
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object2;
            Element element2;
            object = nodeList.item(i);
            if (object instanceof Element && ((Element)object).getTagName().equals("parameter")) {
                element2 = (Element)object;
                string = element2.getAttribute("class").trim();
                if (string.length() == 0) {
                    throw new IOException("vmm.core.SaveAndRestore.error.MissingClassNameForParameter");
                }
                string2 = element2.getAttribute("name").trim();
                object2 = null;
                if (string2.length() > 0) {
                    object2 = view.getParameterByName(string2);
                }
                if (object2 == null) {
                    try {
                        object2 = (Parameter)SaveAndRestore.createObjectFromClassName(string, view);
                    }
                    catch (Exception exception) {
                        throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.CantMakeObject", string));
                    }
                    if (string2.length() > 0) {
                        ((Parameter)object2).setName(string2);
                    }
                    view.addParameter((Parameter)object2);
                }
                SaveAndRestore.setParamInfoFromElement((Parameter)object2, element2);
                continue;
            }
            if (!(object instanceof Element) || !((Element)object).getTagName().equals("decoration")) continue;
            element2 = (Element)object;
            string = element2.getAttribute("class");
            if (string.length() == 0) {
                throw new IOException("vmm.core.SaveAndRestore.error.MissingClassNameForDecoration");
            }
            try {
                object2 = (Decoration)SaveAndRestore.createObjectFromClassName(string, view);
            }
            catch (Exception exception) {
                throw new IOException(I18n.tr("vmm.core.SaveAndRestore.error.CantMakeObject", string));
            }
            SaveAndRestore.readProperties(object2, element2);
            ((Decoration)object2).readExtraXML(element2);
            view.addDecoration((Decoration)object2);
        }
        SaveAndRestore.readProperties(view, element);
        Element element3 = SaveAndRestore.getChildElement(element, "transform");
        if (element3 != null) {
            object = SaveAndRestore.buildTransformFromElement(element3);
            view.setTransform((Transform)object);
        }
        view.readExtraXML(element);
    }
}

