/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import vmm.core.Animateable;
import vmm.core.RealParam;

public class RealParamAnimateable
extends RealParam
implements Animateable {
    private double animationStart;
    private double animationEnd;
    private double defaultAnimationStart;
    private double defaultAnimationEnd;
    private String animationStartString;
    private String animationEndString;
    private String defaultStartString;
    private String defaultEndString;

    public RealParamAnimateable() {
        this((String)null, 0.0);
    }

    public RealParamAnimateable(String string, double d) {
        this(string, d, d, d);
    }

    public RealParamAnimateable(String string, double d, double d2, double d3) {
        super(string, d);
        this.animationStart = this.defaultAnimationStart = d2;
        this.animationEnd = this.defaultAnimationEnd = d3;
    }

    public RealParamAnimateable(String string, String string2) {
        this(string, string2, string2, string2);
    }

    public RealParamAnimateable(String string, String string2, String string3, String string4) {
        super(string, string2);
        this.setAnimationStartFromString(string3);
        this.setAnimationEndFromString(string4);
        this.setDefaultAnimationStartFromString(string3);
        this.setDefaultAnimationEndFromString(string4);
    }

    public void reset(double d) {
        this.reset(new Double(d));
        this.setAnimationLimitsAndDefaults(d, d);
    }

    public void reset(double d, double d2, double d3) {
        this.reset(new Double(d));
        this.setAnimationLimitsAndDefaults(d2, d3);
    }

    public void reset(String string) {
        this.reset(string, string, string);
    }

    public void reset(String string, String string2, String string3) {
        super.reset(string);
        this.setAnimationStartFromString(string2);
        this.setAnimationEndFromString(string3);
        this.setDefaultAnimationStartFromString(string2);
        this.setDefaultAnimationEndFromString(string3);
    }

    public double getDefaultAnimationStart() {
        return this.defaultAnimationStart;
    }

    public double getDefaultAnimationEnd() {
        return this.defaultAnimationEnd;
    }

    public void setDefaultAnimationLimits(double d, double d2) {
        this.defaultAnimationStart = d;
        this.defaultAnimationEnd = d2;
        this.defaultEndString = null;
        this.defaultStartString = null;
    }

    public String getDefaultAnimationStartAsString() {
        return this.defaultStartString != null ? this.defaultStartString : "" + this.defaultAnimationStart;
    }

    public String getDefaultAnimationEndAsString() {
        return this.defaultEndString != null ? this.defaultEndString : "" + this.defaultAnimationEnd;
    }

    public void setDefaultAnimationStartFromString(String string) {
        Double d = (Double)this.stringToValueObject(string);
        this.defaultAnimationStart = d;
        this.defaultStartString = string;
    }

    public void setDefaultAnimationEndFromString(String string) {
        Double d = (Double)this.stringToValueObject(string);
        this.defaultAnimationEnd = d;
        this.defaultEndString = string;
    }

    public void setAnimationLimits(double d, double d2) {
        this.animationStart = d;
        this.animationEnd = d2;
    }

    public void setAnimationLimitsAndDefaults(double d, double d2) {
        this.setAnimationLimits(d, d2);
        this.setDefaultAnimationLimits(d, d2);
    }

    public void setAnimationStart(double d) {
        this.animationStart = d;
        this.animationStartString = null;
    }

    public void setAnimationEnd(double d) {
        this.animationEnd = d;
        this.animationEndString = null;
    }

    public double getAnimationStart() {
        return this.animationStart;
    }

    public double getAnimationEnd() {
        return this.animationEnd;
    }

    public void setAnimationStartFromString(String string) {
        Double d = (Double)this.stringToValueObject(string);
        this.animationStart = d;
        this.animationStartString = string;
    }

    public void setAnimationEndFromString(String string) {
        Double d = (Double)this.stringToValueObject(string);
        this.animationEnd = d;
        this.animationEndString = string;
    }

    public String getAnimationStartAsString() {
        return this.animationStartString != null ? this.animationStartString : "" + this.animationStart;
    }

    public String getAnimationEndAsString() {
        return this.animationEndString != null ? this.animationEndString : "" + this.animationEnd;
    }

    public void setFractionComplete(double d) {
        this.setValue(this.animationStart + d * (this.animationEnd - this.animationStart));
    }

    public boolean reallyAnimated() {
        return this.animationStart != this.animationEnd;
    }
}

