/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import vmm.core.I18n;
import vmm.core.Parameter;
import vmm.core.Util;
import vmm.functions.Expression;
import vmm.functions.ParseError;

public class RealParam
extends Parameter {
    private double minimumValueForInput = Double.NEGATIVE_INFINITY;
    private double maximumValueForInput = Double.POSITIVE_INFINITY;

    public RealParam() {
        this((String)null, 0.0);
    }

    public RealParam(String string, double d) {
        super(string, new Double(d));
    }

    public RealParam(String string, String string2) throws NumberFormatException {
        super(string, string2);
    }

    public void reset(double d) {
        this.reset(new Double(d));
    }

    public void setValue(double d) {
        this.setValueObject(new Double(d));
    }

    public double getValue() {
        Double d = (Double)this.getValueObject();
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public void setDefaultValue(double d) {
        this.setDefaultValueObject(new Double(d));
    }

    public void setValueAndDefault(double d) {
        Double d2 = new Double(d);
        this.setValueObject(d2);
        this.setDefaultValueObject(d2);
    }

    public double getDefaultValue() {
        Double d = (Double)this.getDefaultValueObject();
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public double getMaximumValueForInput() {
        return this.maximumValueForInput;
    }

    public void setMaximumValueForInput(double d) {
        this.maximumValueForInput = d;
    }

    public double getMinimumValueForInput() {
        return this.minimumValueForInput;
    }

    public void setMinimumValueForInput(double d) {
        this.minimumValueForInput = d;
    }

    protected Object stringToValueObject(String string) throws NumberFormatException {
        Expression expression;
        Double d = null;
        try {
            d = new Double(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (d != null) {
            if (d.isNaN() || d.isInfinite()) {
                throw new NumberFormatException(I18n.tr("vmm.core.RealParam.undefined", string));
            }
            return d;
        }
        try {
            expression = Util.parseConstantExpression(string);
        }
        catch (ParseError parseError) {
            if (string != null) {
                try {
                    return Util.externalStringToValue(string, Double.TYPE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new NumberFormatException(I18n.tr("vmm.core.RealParam.badExpression", string, parseError.getMessage()));
        }
        double d2 = expression.value();
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            throw new NumberFormatException(I18n.tr("vmm.core.RealParam.undefined", string));
        }
        return new Double(d2);
    }

    protected String valueObjectToString(Object object) {
        return Util.toExternalString((double)((Double)object));
    }
}

