/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import vmm.core3D.Vector3D;

public class Quaternion {
    public static final Quaternion ZERO = new Quaternion();
    public static final Quaternion q1 = new Quaternion(1.0, 0.0, 0.0, 0.0);
    public static final Quaternion qI = new Quaternion(0.0, 1.0, 0.0, 0.0);
    public static final Quaternion qJ = new Quaternion(0.0, 0.0, 1.0, 0.0);
    public static final Quaternion qK = new Quaternion(0.0, 0.0, 0.0, 1.0);
    public double a;
    public double b;
    public double c;
    public double d;

    public Quaternion() {
    }

    public Quaternion(double d, double d2, double d3, double d4) {
        this.a = d;
        this.b = d2;
        this.c = d3;
        this.d = d4;
    }

    public Quaternion(Quaternion quaternion) {
        this.a = quaternion.a;
        this.b = quaternion.b;
        this.c = quaternion.c;
        this.d = quaternion.d;
    }

    public boolean equals(Object object) {
        try {
            Quaternion quaternion = (Quaternion)object;
            return this.a == quaternion.a && this.b == quaternion.b && this.c == quaternion.c && this.d == quaternion.d;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String toString() {
        return "(" + this.a + "," + this.b + "," + this.c + "," + this.d + ")";
    }

    public double dot(Quaternion quaternion) {
        return this.a * quaternion.a + this.b * quaternion.b + this.c * quaternion.c + this.d * quaternion.d;
    }

    public double norm() {
        return Math.sqrt(this.a * this.a + this.b * this.b + this.c * this.c + this.d * this.d);
    }

    public Quaternion conj() {
        return new Quaternion(this.a, -this.b, -this.c, -this.d);
    }

    public Quaternion plus(Quaternion quaternion) {
        return new Quaternion(this.a + quaternion.a, this.b + quaternion.b, this.c + quaternion.c, this.d + quaternion.d);
    }

    public Quaternion minus(Quaternion quaternion) {
        return new Quaternion(this.a - quaternion.a, this.b - quaternion.b, this.c - quaternion.c, this.d - quaternion.d);
    }

    public Quaternion times(Quaternion quaternion) {
        return new Quaternion(this.a * quaternion.a - this.b * quaternion.b - this.c * quaternion.c - this.d * quaternion.d, this.a * quaternion.b + this.b * quaternion.a + this.c * quaternion.d - this.d * quaternion.c, this.a * quaternion.c - this.b * quaternion.d + this.c * quaternion.a + this.d * quaternion.b, this.a * quaternion.d + this.b * quaternion.c - this.c * quaternion.b + this.d * quaternion.a);
    }

    public Quaternion times(double d) {
        return new Quaternion(this.a * d, this.b * d, this.c * d, this.d * d);
    }

    public Quaternion inverse() {
        double d = this.a * this.a + this.b * this.b + this.c * this.c + this.d * this.d;
        return new Quaternion(this.a / d, -this.b / d, -this.c / d, -this.d / d);
    }

    public Quaternion dividedBy(Quaternion quaternion) {
        return this.times(quaternion.inverse());
    }

    public Quaternion rotateAroundHopfFibre(double d) {
        return new Quaternion(this.a, this.b, this.c * Math.cos(d) - this.d * Math.sin(d), this.c * Math.sin(d) + this.d * Math.cos(d));
    }

    public Quaternion rotateAroundHopfFibre(double d, Quaternion quaternion) {
        Quaternion quaternion2 = new Quaternion(this.times(quaternion.inverse()));
        quaternion2 = quaternion2.rotateAroundHopfFibre(d);
        return quaternion2.times(quaternion);
    }

    public Vector3D StereographicProjection() {
        return new Vector3D(this.b / (1.0 + this.a), this.c / (1.0 + this.a), this.d / (1.0 + this.a));
    }
}

