/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;

public class Prefs {
    private static Prefs prefs;
    protected static final String DEFAULT_PREFIX = "/org/virtualmathmuseum/vmm/";
    private HashMap<String, String> map;
    private Preferences preferencesRoot;

    public static synchronized boolean save() {
        if (prefs == null) {
            return true;
        }
        return prefs.doSave();
    }

    public static synchronized boolean save(String string) {
        if (prefs == null) {
            return true;
        }
        return prefs.doSave(string);
    }

    public static synchronized void put(String string, String string2) {
        if (prefs == null) {
            prefs = new Prefs();
        }
        prefs.doPut(string, string2);
    }

    public static synchronized boolean putAndSave(String string, String string2) {
        prefs.doPut(string, string2);
        return prefs.doSave(string);
    }

    public static synchronized String get(String string) {
        if (prefs == null) {
            prefs = new Prefs();
        }
        return prefs.doGet(string);
    }

    public static void putInt(String string, int n) {
        Prefs.put(string, "" + n);
    }

    public static void putDouble(String string, double d) {
        if (Double.isNaN(d)) {
            Prefs.put(string, "NaN");
        } else if (d == Double.POSITIVE_INFINITY) {
            Prefs.put(string, "+INF");
        } else if (d == Double.NEGATIVE_INFINITY) {
            Prefs.put(string, "-INF");
        } else {
            Prefs.put(string, "" + d);
        }
    }

    public static void putBoolean(String string, boolean bl) {
        Prefs.put(string, bl ? "true" : "false");
    }

    public static String get(String string, String string2) {
        String string3 = Prefs.get(string);
        return string3 == null ? string2 : string3;
    }

    public static int getInt(String string, int n) {
        String string2 = Prefs.get(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static double getDouble(String string, double d) {
        String string2 = Prefs.get(string);
        if (string2 == null) {
            return d;
        }
        if (string2.equals("NaN")) {
            return Double.NaN;
        }
        if (string2.equals("+INF")) {
            return Double.POSITIVE_INFINITY;
        }
        if (string2.equals("-INF")) {
            return Double.NEGATIVE_INFINITY;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (Exception exception) {
            return d;
        }
    }

    public static boolean getBoolean(String string, boolean bl) {
        String string2 = Prefs.get(string);
        if (string2 == null) {
            return bl;
        }
        if (string2.equalsIgnoreCase("true")) {
            return true;
        }
        if (string2.equalsIgnoreCase("false")) {
            return false;
        }
        return bl;
    }

    public static void setPrefs(Prefs prefs) {
        Prefs.prefs = prefs;
    }

    public static Prefs getPrefs() {
        if (prefs == null) {
            prefs = new Prefs();
        }
        return prefs;
    }

    protected Prefs() {
    }

    protected String doGet(String string) {
        String string2;
        if (string == null || string.length() == 0) {
            return null;
        }
        if (this.map == null) {
            this.map = new HashMap();
        }
        if (this.map.containsKey(string = DEFAULT_PREFIX + string)) {
            return this.map.get(string);
        }
        try {
            if (this.preferencesRoot == null) {
                this.preferencesRoot = Preferences.userRoot();
            }
            string2 = this.preferencesRoot.get(string, null);
        }
        catch (Exception exception) {
            string2 = null;
        }
        this.map.put(string, string2);
        return string2;
    }

    protected void doPut(String string, String string2) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("key string must be non-null and non-empty.");
        }
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.map.put(DEFAULT_PREFIX + string, string2);
    }

    protected boolean doSave() {
        if (this.map == null || this.map.size() == 0) {
            return true;
        }
        try {
            if (this.preferencesRoot == null) {
                this.preferencesRoot = Preferences.userRoot();
            }
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                String string3 = this.preferencesRoot.get(string, null);
                if (string2 == null && string3 != null) {
                    this.preferencesRoot.remove(string);
                    continue;
                }
                if (string2 == null || string2.equals(string3)) continue;
                this.preferencesRoot.put(string, string2);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean doSave(String string) {
        if (this.map == null || this.map.size() == 0) {
            return true;
        }
        string = DEFAULT_PREFIX + string;
        if (!this.map.containsKey(string)) {
            return true;
        }
        String string2 = this.map.get(string);
        try {
            if (this.preferencesRoot == null) {
                this.preferencesRoot = Preferences.userRoot();
            }
            String string3 = this.preferencesRoot.get(string, null);
            if (string2 == null && string3 != null) {
                this.preferencesRoot.remove(string);
            } else if (string2 != null && !string2.equals(string3)) {
                this.preferencesRoot.put(string, string2);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

