/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import javax.swing.JTextField;
import vmm.core.Animateable;
import vmm.core.Complex;
import vmm.core.ComplexParam;
import vmm.core.I18n;
import vmm.core.IntegerParam;
import vmm.core.Parameter;
import vmm.core.RealParam;
import vmm.core.RealParamAnimateable;
import vmm.functions.ParseError;
import vmm.functions.Parser;

public class ParameterInput
extends JTextField {
    private Parameter param;
    private int inputType;
    private String originalString;
    private static Parser parser = new Parser();
    public static final int VALUE = 0;
    public static final int ANIMATION_START = 1;
    public static final int ANIMATION_END = 2;

    public ParameterInput(Parameter parameter) {
        this(parameter, 0);
    }

    public ParameterInput(Parameter parameter, int n) {
        super(12);
        this.param = parameter;
        if (parameter instanceof Animateable) {
            this.inputType = n;
            if (this.inputType != 0 && this.inputType != 2 && this.inputType != 1) {
                this.inputType = 0;
            }
            switch (this.inputType) {
                case 0: {
                    this.originalString = parameter.getValueAsString();
                    break;
                }
                case 1: {
                    this.originalString = ((Animateable)((Object)parameter)).getAnimationStartAsString();
                    break;
                }
                default: {
                    this.originalString = ((Animateable)((Object)parameter)).getAnimationEndAsString();
                    break;
                }
            }
        } else {
            this.inputType = 0;
            this.originalString = parameter.getValueAsString();
        }
        this.setText(this.originalString);
        String string = null;
        if (parameter instanceof IntegerParam) {
            string = "<html>" + I18n.tr("vmm.core.ParameterInput.isInteger");
            int n2 = ((IntegerParam)parameter).getMinimumValueForInput();
            int n3 = ((IntegerParam)parameter).getMaximumValueForInput();
            if (n3 == Integer.MAX_VALUE) {
                if (n2 == 1) {
                    string = string + "<br>" + I18n.tr("vmm.core.ParameterInput.positive");
                } else if (n2 == 0) {
                    string = string + "<br>" + I18n.tr("vmm.core.ParameterInput.nonnegative");
                } else if (n2 > Integer.MIN_VALUE) {
                    string = string + "<br>" + I18n.tr("vmm.core.ParameterInput.greater", n2);
                }
            } else {
                string = n2 == Integer.MIN_VALUE ? string + "<br>" + I18n.tr("vmm.core.ParameterInput.less", n3) : string + "<br>" + I18n.tr("vmm.core.ParameterInput.range", n2, n3);
            }
        } else if (parameter instanceof RealParam) {
            string = "<html>" + I18n.tr("vmm.core.ParameterInput.isReal");
            double d = ((RealParam)parameter).getMinimumValueForInput();
            double d2 = ((RealParam)parameter).getMaximumValueForInput();
            if (d2 == Double.POSITIVE_INFINITY) {
                if (d == Double.MIN_VALUE) {
                    string = string + "<br>" + I18n.tr("vmm.core.ParameterInput.positive");
                } else if (d == 0.0) {
                    string = string + "<br>" + I18n.tr("vmm.core.ParameterInput.nonnegative");
                } else if (d > Double.NEGATIVE_INFINITY) {
                    string = string + "<br>" + I18n.tr("vmm.core.ParameterInput.greater", d);
                }
            } else {
                string = d == Double.NEGATIVE_INFINITY ? string + "<br>" + I18n.tr("vmm.core.ParameterInput.less", d2) : string + "<br>" + I18n.tr("vmm.core.ParameterInput.range", d, d2);
            }
        } else if (parameter instanceof ComplexParam) {
            string = "<html>" + I18n.tr("vmm.core.ParameterInput.isComplex");
            Complex complex = ((ComplexParam)parameter).getMinimumValueForInput();
            Complex complex2 = ((ComplexParam)parameter).getMaximumValueForInput();
            if (complex.re == Double.NEGATIVE_INFINITY && complex2.re < Double.POSITIVE_INFINITY) {
                string = string + "<br>" + I18n.tr("vmm.core.ParameterInput.less.realpart", complex2.re);
            } else if (complex.re > Double.NEGATIVE_INFINITY && complex2.re == Double.POSITIVE_INFINITY) {
                string = string + "<br>" + I18n.tr("vmm.core.ParameterInput.greater.realpart", complex.re);
            } else if (complex.re > Double.NEGATIVE_INFINITY && complex2.re < Double.POSITIVE_INFINITY) {
                string = string + "<br>" + I18n.tr("vmm.core.ParameterInput.range.realpart", complex.re, complex2.re);
            }
            if (complex.im == Double.NEGATIVE_INFINITY && complex2.im < Double.POSITIVE_INFINITY) {
                string = string + "<br>" + I18n.tr("vmm.core.ParameterInput.less.imaginarypart", complex2.im);
            } else if (complex.im > Double.NEGATIVE_INFINITY && complex2.im == Double.POSITIVE_INFINITY) {
                string = string + "<br>" + I18n.tr("vmm.core.ParameterInput.greater.imaginarypart", complex.im);
            } else if (complex.im > Double.NEGATIVE_INFINITY && complex2.im < Double.POSITIVE_INFINITY) {
                string = string + "<br>" + I18n.tr("vmm.core.ParameterInput.range.imaginarypart", complex.im, complex2.im);
            }
        }
        this.setToolTipText(string);
    }

    public void setColumns(int n) {
        double d;
        super.setColumns(n);
        String string = this.getText();
        if (string.length() < n || !string.equals(this.originalString) || !(this.param instanceof RealParam)) {
            return;
        }
        switch (this.inputType) {
            case 0: {
                d = ((RealParam)this.param).getValue();
                break;
            }
            case 1: {
                d = ((RealParamAnimateable)this.param).getAnimationStart();
                break;
            }
            default: {
                d = ((RealParamAnimateable)this.param).getAnimationEnd();
            }
        }
        String string2 = String.format("%" + n + "g", d);
        this.setText(string2);
        this.originalString = string2;
    }

    public Parameter getParameter() {
        return this.param;
    }

    public String checkContents() {
        String string = this.getText();
        double d = 0.0;
        Complex complex = null;
        try {
            if (this.param instanceof ComplexParam) {
                complex = parser.parseComplexExpression(string).value();
            } else {
                d = parser.parse(string).value();
            }
        }
        catch (ParseError parseError) {
            this.requestFocus();
            this.selectAll();
            if (this.inputType == 0) {
                return I18n.tr("vmm.core.ParameterInput.badExpression", this.param.getTitle(), string, parseError.getMessage());
            }
            if (this.inputType == 1) {
                return I18n.tr("vmm.core.ParameterInput.badStartExpression", this.param.getTitle(), string, parseError.getMessage());
            }
            return I18n.tr("vmm.core.ParameterInput.badEndExpression", this.param.getTitle(), string, parseError.getMessage());
        }
        if (complex == null && (Double.isNaN(d) || Double.isInfinite(d)) || complex != null && (Double.isNaN(complex.re) || Double.isInfinite(complex.re) || Double.isNaN(complex.im) || Double.isInfinite(complex.im))) {
            this.requestFocus();
            this.selectAll();
            if (this.inputType == 0) {
                return I18n.tr("vmm.core.ParameterInput.undefinedExpression", this.param.getTitle(), string);
            }
            if (this.inputType == 1) {
                return I18n.tr("vmm.core.ParameterInput.undefinedStartExpression", this.param.getTitle(), string);
            }
            return I18n.tr("vmm.core.ParameterInput.undefinedEndExpression", this.param.getTitle(), string);
        }
        if (this.param instanceof IntegerParam) {
            IntegerParam integerParam = (IntegerParam)this.param;
            int n = d > 0.0 ? (int)(d + 1.0E-8) : (int)(d - 1.0E-8);
            if (Math.abs(d - (double)n) > 5.0E-9) {
                this.requestFocus();
                this.selectAll();
                return I18n.tr("vmm.core.ParameterInput.badint", this.param.getTitle());
            }
            if (n < integerParam.getMinimumValueForInput() || n > integerParam.getMaximumValueForInput()) {
                this.requestFocus();
                this.selectAll();
                return I18n.tr("vmm.core.ParameterInput.intOutOfRange", this.param.getTitle(), "" + integerParam.getMinimumValueForInput(), "" + integerParam.getMaximumValueForInput());
            }
        } else if (this.param instanceof RealParam) {
            RealParam realParam = (RealParam)this.param;
            if (d < realParam.getMinimumValueForInput() || d > realParam.getMaximumValueForInput()) {
                this.requestFocus();
                this.selectAll();
                if (realParam.getMinimumValueForInput() == Double.MIN_VALUE) {
                    if (realParam.getMaximumValueForInput() == Double.POSITIVE_INFINITY) {
                        return I18n.tr("vmm.core.ParameterInput.rangeError1", this.param.getTitle());
                    }
                    return I18n.tr("vmm.core.ParameterInput.rangeError2", this.param.getTitle(), "" + realParam.getMaximumValueForInput());
                }
                if (realParam.getMaximumValueForInput() == Double.POSITIVE_INFINITY) {
                    return I18n.tr("vmm.core.ParameterInput.rangeError3", this.param.getTitle(), "" + realParam.getMinimumValueForInput());
                }
                if (realParam.getMinimumValueForInput() == Double.NEGATIVE_INFINITY) {
                    return I18n.tr("vmm.core.ParameterInput.rangeError4", this.param.getTitle(), "" + realParam.getMaximumValueForInput());
                }
                return I18n.tr("vmm.core.ParameterInput.rangeError5", this.param.getTitle(), "" + realParam.getMinimumValueForInput(), "" + realParam.getMaximumValueForInput());
            }
        } else if (this.param instanceof ComplexParam) {
            ComplexParam complexParam = (ComplexParam)this.param;
            if (complex.re < complexParam.getMinimumValueForInput().re || complex.re > complexParam.getMaximumValueForInput().re || complex.im < complexParam.getMinimumValueForInput().im || complex.im > complexParam.getMaximumValueForInput().im) {
                this.requestFocus();
                this.selectAll();
                return I18n.tr("vmm.core.ParameterInput.rangeErrorComplex");
            }
        }
        return null;
    }

    public void setValueFromContents() {
        String string = this.getText();
        if (string.equals(this.originalString)) {
            return;
        }
        try {
            switch (this.inputType) {
                case 0: {
                    this.param.setValueFromString(string);
                    break;
                }
                case 1: {
                    ((Animateable)((Object)this.param)).setAnimationStartFromString(string);
                    break;
                }
                default: {
                    ((Animateable)((Object)this.param)).setAnimationEndFromString(string);
                }
            }
            this.originalString = string;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setValueAndDefaultFromContents() {
        String string = this.getText();
        if (string.equals(this.originalString)) {
            return;
        }
        try {
            switch (this.inputType) {
                case 0: {
                    this.param.setValueAndDefaultFromString(string);
                    break;
                }
                case 1: {
                    ((Animateable)((Object)this.param)).setAnimationStartFromString(string);
                    ((Animateable)((Object)this.param)).setDefaultAnimationStartFromString(string);
                    break;
                }
                default: {
                    ((Animateable)((Object)this.param)).setAnimationEndFromString(string);
                    ((Animateable)((Object)this.param)).setDefaultAnimationEndFromString(string);
                }
            }
            this.originalString = string;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void revert() {
        this.setText(this.originalString);
    }

    public void defaultVal() {
        switch (this.inputType) {
            case 0: {
                this.setText(this.param.getDefaultValueAsString());
                break;
            }
            case 1: {
                this.setText(((Animateable)((Object)this.param)).getDefaultAnimationStartAsString());
                break;
            }
            default: {
                this.setText(((Animateable)((Object)this.param)).getDefaultAnimationEndAsString());
            }
        }
    }
}

