/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import vmm.core.I18n;
import vmm.core.Parameter;
import vmm.core.ParameterInput;
import vmm.core.SettingsDialog;

public class ParameterDialog
extends SettingsDialog {
    private Parameter[] parameters;
    private ParameterInput[] inputBoxes;

    public static boolean showDialog(Component component, String string, Parameter[] parameterArray) {
        ParameterDialog parameterDialog = new ParameterDialog(component, string, parameterArray);
        parameterDialog.setVisible(true);
        return !parameterDialog.canceled;
    }

    public ParameterDialog(Component component, String string, Parameter[] parameterArray) {
        super(component, string, true, true);
        this.parameters = parameterArray;
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new GridLayout(1, 0, 5, 5));
        jPanel.add(new JLabel(I18n.tr("vmm.core.ParameterDialog.ParameterName"), 0));
        jPanel.add(new JLabel(I18n.tr("vmm.core.ParameterDialog.ParameterValue"), 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.inputBoxes = new ParameterInput[parameterArray.length];
        jPanel2.setLayout(new GridLayout(0, 2, 5, 5));
        for (int i = 0; i < parameterArray.length; ++i) {
            JLabel jLabel = new JLabel(parameterArray[i].getTitle() + " = ", 4);
            final String string2 = parameterArray[i].getHint();
            if (string2 == null) {
                jPanel2.add(jLabel);
            } else {
                JPanel jPanel3 = new JPanel();
                jPanel2.add(jPanel3);
                jPanel3.setLayout(new BorderLayout());
                jPanel3.add((Component)jLabel, "Center");
                JButton jButton = new JButton("?");
                jButton.setPreferredSize(new Dimension(40, jButton.getPreferredSize().height));
                jPanel3.add((Component)jButton, "West");
                final String string3 = parameterArray[i].getTitle();
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        JOptionPane.showMessageDialog(ParameterDialog.this, new JLabel(string2), string3, 1);
                    }
                });
            }
            this.inputBoxes[i] = parameterArray[i].createParameterInput(0);
            jPanel2.add(this.inputBoxes[i]);
            this.inputBoxes[i].setMargin(new Insets(3, 3, 3, 3));
        }
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(6, 6));
        jPanel4.add((Component)jPanel, "North");
        jPanel4.add((Component)jPanel2, "Center");
        this.addInputPanel(jPanel4);
    }

    protected boolean doOK() {
        int n;
        for (n = 0; n < this.parameters.length; ++n) {
            String string = this.inputBoxes[n].checkContents();
            if (string == null) continue;
            JOptionPane.showMessageDialog(this, string, I18n.tr("vmm.core.ParameterDialog.errorTitle"), 0);
            return false;
        }
        for (n = 0; n < this.parameters.length; ++n) {
            this.inputBoxes[n].setValueFromContents();
        }
        return true;
    }

    protected void doDefaults() {
        for (int i = 0; i < this.parameters.length; ++i) {
            this.inputBoxes[i].defaultVal();
        }
    }
}

