/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import vmm.core.I18n;
import vmm.core.ParameterInput;
import vmm.core.Parameterizable;

public abstract class Parameter {
    private Object value;
    private String valueString;
    private Object defaultValue;
    private String defaultValueString;
    private Parameterizable owner;
    private String name;

    protected Parameter(String string, Object object) {
        if (object != null) {
            this.setValueObject(object);
        }
        this.name = string;
    }

    public Parameter(String string, String string2) {
        if (string2 != null) {
            this.setValueFromString(string2);
        }
        this.name = string;
    }

    protected void reset(Object object) {
        this.setDefaultValueObject(object);
        this.setValueObject(object);
    }

    public void reset(String string) {
        this.setValueAndDefaultFromString(string);
    }

    protected String valueObjectToString(Object object) {
        return object == null ? "0" : object.toString();
    }

    protected abstract Object stringToValueObject(String var1);

    public Parameterizable getOwner() {
        return this.owner;
    }

    public void setOwner(Parameterizable parameterizable) {
        this.owner = parameterizable;
    }

    public Object getValueObject() {
        return this.value;
    }

    public void setValueObject(Object object) {
        Object object2 = this.value;
        this.value = object;
        this.valueString = null;
        if (object != null && this.defaultValue == null) {
            this.setDefaultValueObject(object);
        }
        if (this.owner != null) {
            if (object2 == null ? object == null : object2.equals(object)) {
                return;
            }
            this.owner.parameterChanged(this, object2, object);
        }
    }

    public void setDefaultValueObject(Object object) {
        this.defaultValue = object;
        this.defaultValueString = null;
    }

    public Object getDefaultValueObject() {
        return this.defaultValue;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        String string = this.getName();
        if (string == null) {
            return I18n.tr("unnamed.parameter");
        }
        return I18n.tr(string);
    }

    public String getHint() {
        String string = this.getName();
        String string2 = null;
        if (string != null) {
            string2 = I18n.trIfFound(string + ".hint");
        }
        return string2;
    }

    public final String getValueAsString() {
        if (this.valueString != null) {
            return this.valueString;
        }
        if (this.value == null) {
            return "0";
        }
        return this.valueObjectToString(this.value);
    }

    public String getDefaultValueAsString() {
        if (this.defaultValueString != null) {
            return this.defaultValueString;
        }
        if (this.defaultValue == null) {
            return "0";
        }
        return this.valueObjectToString(this.defaultValue);
    }

    public final void setValueFromString(String string) {
        boolean bl = this.defaultValue == null;
        this.setValueObject(this.stringToValueObject(string));
        this.valueString = string;
        if (bl) {
            this.defaultValueString = string;
        }
    }

    public final void setDefaultValueFromString(String string) {
        this.setDefaultValueObject(this.stringToValueObject(string));
        this.defaultValueString = string;
    }

    public final void setValueAndDefaultFromString(String string) {
        Object object = this.stringToValueObject(string);
        this.setValueObject(object);
        this.valueString = string;
        this.setDefaultValueObject(object);
        this.defaultValueString = string;
    }

    public ParameterInput createParameterInput(int n) {
        return new ParameterInput(this, n);
    }

    public String toString() {
        return this.getTitle() + "(" + this.getValueAsString() + ")";
    }
}

