/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import vmm.core.I18n;
import vmm.core.Parameter;
import vmm.core.Util;
import vmm.functions.Expression;
import vmm.functions.ParseError;

public class IntegerParam
extends Parameter {
    private int minimumValueForInput = Integer.MIN_VALUE;
    private int maximumValueForInput = Integer.MAX_VALUE;

    public IntegerParam() {
        this((String)null, 0);
    }

    public IntegerParam(String string, int n) {
        super(string, new Integer(n));
    }

    public IntegerParam(String string, String string2) throws NumberFormatException {
        super(string, string2);
    }

    public void reset(int n) {
        this.reset(new Integer(n));
    }

    public void setValue(int n) {
        this.setValueObject(new Integer(n));
    }

    public int getValue() {
        Integer n = (Integer)this.getValueObject();
        if (n == null) {
            return 0;
        }
        return n;
    }

    public void setDefaultValue(int n) {
        this.setDefaultValueObject(new Integer(n));
    }

    public void setValueAndDefault(int n) {
        Integer n2 = new Integer(n);
        this.setValueObject(n2);
        this.setDefaultValueObject(n2);
    }

    public int getDefaultValue() {
        Object object = this.getDefaultValueObject();
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    public int getMaximumValueForInput() {
        return this.maximumValueForInput;
    }

    public void setMaximumValueForInput(int n) {
        this.maximumValueForInput = n;
    }

    public int getMinimumValueForInput() {
        return this.minimumValueForInput;
    }

    public void setMinimumValueForInput(int n) {
        this.minimumValueForInput = n;
    }

    protected Object stringToValueObject(String string) throws NumberFormatException {
        try {
            return new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            Expression expression;
            try {
                expression = Util.parseConstantExpression(string);
            }
            catch (ParseError parseError) {
                throw new NumberFormatException(I18n.tr("vmm.core.IntegerParam.badExpression", string, parseError.getMessage()));
            }
            double d = expression.value();
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                throw new NumberFormatException(I18n.tr("vmm.core.IntegerParam.undefined", string));
            }
            int n = d > 0.0 ? (int)(d + 1.0E-8) : (int)(d - 1.0E-8);
            if (Math.abs((double)n - d) > 5.0E-9) {
                throw new NumberFormatException(I18n.tr("vmm.core.IntegerParam.notAnInteger", string));
            }
            return new Integer(n);
        }
    }
}

