/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18n {
    private static ArrayList<ResourceBundle> bundles = new ArrayList();
    private static ArrayList<String> bundleNames = new ArrayList();
    private static Locale locale;
    private static String defaultPropertiesFileName;

    public static void setLocale(Locale locale) {
        I18n.setLocale(locale, true);
    }

    public static synchronized void setLocale(Locale locale, boolean bl) {
        I18n.locale = locale;
        if (bl) {
            bundles.clear();
            ArrayList<String> arrayList = bundleNames;
            bundleNames = new ArrayList();
            for (int i = 0; i < arrayList.size(); ++i) {
                I18n.load(arrayList.get(i));
            }
        }
    }

    public static Locale getLocale() {
        if (locale == null) {
            return Locale.getDefault();
        }
        return locale;
    }

    public static synchronized boolean addFile(String string) {
        ResourceBundle resourceBundle;
        if (string == null) {
            return false;
        }
        for (int i = 0; i < bundleNames.size(); ++i) {
            if (!bundleNames.get(i).equals(string)) continue;
            return bundles.get(i) != null;
        }
        if (bundles.size() == 0 && !string.equals(defaultPropertiesFileName)) {
            I18n.load(defaultPropertiesFileName);
        }
        return (resourceBundle = I18n.load(string)) != null;
    }

    private static synchronized ResourceBundle load(String string) {
        ResourceBundle resourceBundle;
        if (string == null) {
            return null;
        }
        try {
            resourceBundle = locale == null ? ResourceBundle.getBundle(string) : ResourceBundle.getBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundle = null;
        }
        bundles.add(resourceBundle);
        bundleNames.add(string);
        return resourceBundle;
    }

    public static String tr(String string) {
        String string2 = I18n.trIfFound(string);
        return string2 == null ? string : string2;
    }

    public static String tr(String string, Object ... objectArray) {
        return MessageFormat.format(I18n.tr(string), objectArray);
    }

    public static String trIfFound(String string) {
        if (string == null) {
            return null;
        }
        if (bundles.size() == 0) {
            I18n.load(defaultPropertiesFileName);
        }
        for (int i = bundles.size() - 1; i >= 0; --i) {
            ResourceBundle resourceBundle = bundles.get(i);
            if (resourceBundle == null) continue;
            try {
                return resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String trIfFound(String string, Object ... objectArray) {
        String string2 = I18n.trIfFound(string);
        if (string2 == null) {
            return null;
        }
        return MessageFormat.format(string2, objectArray);
    }

    static {
        defaultPropertiesFileName = "vmm.resources.strings";
    }
}

