/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.core.Animateable;
import vmm.core.Animation;
import vmm.core.AnimationLimitsDialog;
import vmm.core.BasicAnimator;
import vmm.core.Decorateable;
import vmm.core.Decoration;
import vmm.core.I18n;
import vmm.core.Parameter;
import vmm.core.ParameterDialog;
import vmm.core.Parameterizable;
import vmm.core.SetNumberOfFramesDialog;
import vmm.core.SetXYWindowDialog;
import vmm.core.Transform;
import vmm.core.VMMSave;
import vmm.core.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Exhibit
implements Parameterizable,
Decorateable,
ChangeListener {
    private ArrayList<ChangeListener> changeListeners;
    private ArrayList<View> views;
    private ChangeEvent changeEvent;
    private String name;
    private Color defaultForeground = Color.black;
    private Color defaultBackground = Color.white;
    @VMMSave
    private double[] defaultWindow;
    @VMMSave
    private int framesForMorphing = 50;
    @VMMSave
    private boolean useFilmstripForMorphing;
    protected boolean isMorphing;
    protected View morphingView;
    protected ArrayList<Parameter> parameters;
    protected ArrayList<Decoration> decorations;
    protected boolean exhibitNeedsRedraw = true;
    protected Transform previousTransform;

    public String getName() {
        if (this.name == null) {
            return this.getClass().getName();
        }
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getTitle() {
        return I18n.tr(this.getName());
    }

    public int getFramesForMorphing() {
        return this.framesForMorphing;
    }

    public void setFramesForMorphing(int n) {
        if (n > 1) {
            this.framesForMorphing = n;
        }
    }

    public boolean getUseFilmstripForMorphing() {
        return this.useFilmstripForMorphing;
    }

    public void setUseFilmstripForMorphing(boolean bl) {
        this.useFilmstripForMorphing = bl;
    }

    public void addExtraXML(Document document, Element element) {
    }

    public void readExtraXML(Element element) throws IOException {
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            return;
        }
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
        }
        this.changeListeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (changeListener != null && this.changeListeners != null) {
            this.changeListeners.remove(changeListener);
            if (this.changeListeners.isEmpty()) {
                this.changeListeners = null;
            }
        }
    }

    protected synchronized void fireExhibitChangeEvent() {
        if (this.changeListeners == null) {
            return;
        }
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        if (this.isMorphing && this.morphingView != null) {
            for (int i = 0; i < this.changeListeners.size(); ++i) {
                View view;
                if (!(this.changeListeners.get(i) instanceof View) || (view = (View)this.changeListeners.get(i)).getDisplay() != this.morphingView.getDisplay()) continue;
                view.stateChanged(this.changeEvent);
            }
        } else {
            for (int i = 0; i < this.changeListeners.size(); ++i) {
                this.changeListeners.get(i).stateChanged(this.changeEvent);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.fireExhibitChangeEvent();
    }

    public Parameter[] getParameters() {
        if (this.parameters == null) {
            return new Parameter[0];
        }
        Parameter[] parameterArray = new Parameter[this.parameters.size()];
        for (int i = parameterArray.length - 1; i >= 0; --i) {
            parameterArray[parameterArray.length - i - 1] = this.parameters.get(i);
        }
        return parameterArray;
    }

    public Parameter getParameterByName(String string) {
        if (this.parameters != null && string != null) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (!string.equals(this.parameters.get(i).getName())) continue;
                return this.parameters.get(i);
            }
        }
        return null;
    }

    protected void addParameter(Parameter parameter) {
        if (parameter == null) {
            return;
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        if (this.parameters.contains(parameter)) {
            return;
        }
        this.parameters.add(parameter);
        parameter.setOwner(this);
    }

    protected void removeParameter(Parameter parameter) {
        if (parameter == null || this.parameters == null || !this.parameters.contains(parameter)) {
            return;
        }
        this.parameters.remove(parameter);
        parameter.setOwner(null);
    }

    @Override
    public void parameterChanged(Parameter parameter, Object object, Object object2) {
        this.forceRedraw();
    }

    public ActionList getActionsForView(final View view) {
        ActionList actionList = new ActionList();
        AbstractActionVMM abstractActionVMM = new AbstractActionVMM(I18n.tr("vmm.core.commands.Create"), "K"){

            public void actionPerformed(ActionEvent actionEvent) {
                Animation animation = Exhibit.this.getCreateAnimation(view);
                if (animation != null) {
                    if (view != null && view.getDisplay() != null) {
                        view.getDisplay().installAnimation(animation);
                    } else {
                        animation.start();
                    }
                } else {
                    Exhibit.this.forceRedraw();
                }
            }
        };
        actionList.add(abstractActionVMM);
        return actionList;
    }

    public ActionList getSettingsCommandsForView(final View view) {
        ActionList actionList = new ActionList();
        AbstractActionVMM abstractActionVMM = new AbstractActionVMM(I18n.tr("vmm.core.commands.SetParameters")){

            public void actionPerformed(ActionEvent actionEvent) {
                view.getDisplay().stopAnimation();
                Parameter[] parameterArray = view.getViewAndExhibitParameters();
                ParameterDialog.showDialog(view.getDisplay(), I18n.tr("vmm.core.dialogtitle.SetParameters"), parameterArray);
            }
        };
        AbstractActionVMM abstractActionVMM2 = new AbstractActionVMM(I18n.tr("vmm.core.commands.SetAnimationParameters")){

            public void actionPerformed(ActionEvent actionEvent) {
                view.getDisplay().stopAnimation();
                Parameter[] parameterArray = view.getViewAndExhibitParameters();
                AnimationLimitsDialog.showDialog(view.getDisplay(), I18n.tr("vmm.core.dialogtitle.SetAnimationParameters"), parameterArray);
            }
        };
        AbstractActionVMM abstractActionVMM3 = new AbstractActionVMM(I18n.tr("vmm.core.commands.SetNumberOfFrames")){

            public void actionPerformed(ActionEvent actionEvent) {
                view.getDisplay().stopAnimation();
                SetNumberOfFramesDialog.showDialog(view);
            }
        };
        AbstractActionVMM abstractActionVMM4 = new AbstractActionVMM(I18n.tr("vmm.core.commands.SetXYWindow")){

            public void actionPerformed(ActionEvent actionEvent) {
                view.getDisplay().stopAnimation();
                SetXYWindowDialog.showDialog(view);
            }
        };
        Parameter[] parameterArray = view.getViewAndExhibitParameters();
        boolean bl = false;
        for (int i = 0; i < parameterArray.length; ++i) {
            if (!(parameterArray[i] instanceof Animateable)) continue;
            bl = true;
            break;
        }
        abstractActionVMM.setEnabled(parameterArray.length > 0);
        abstractActionVMM2.setEnabled(bl);
        abstractActionVMM3.setEnabled(bl);
        actionList.add(abstractActionVMM);
        actionList.add(abstractActionVMM2);
        actionList.add(abstractActionVMM3);
        actionList.add(abstractActionVMM4);
        return actionList;
    }

    public ActionList getAdditionalAnimationsForView(View view) {
        return new ActionList();
    }

    public void addView(View view) {
        if (view == null) {
            return;
        }
        if (this.views == null) {
            this.views = new ArrayList();
        }
        if (!this.views.contains(view)) {
            this.views.add(view);
        }
    }

    public void removeView(View view) {
        if (this.views != null) {
            this.views.remove(view);
        }
    }

    public ArrayList<View> getViews() {
        return this.views;
    }

    @Override
    public void addDecoration(Decoration decoration) {
        if (decoration == null) {
            return;
        }
        if (this.decorations == null) {
            this.decorations = new ArrayList();
        }
        if (this.decorations.contains(decoration)) {
            return;
        }
        this.decorations.add(decoration);
        decoration.addChangeListener(this);
        this.fireExhibitChangeEvent();
    }

    @Override
    public void removeDecoration(Decoration decoration) {
        if (this.decorations != null && decoration != null && this.decorations.contains(decoration)) {
            this.decorations.remove(decoration);
            decoration.removeChangeListener(this);
            if (this.decorations.size() == 0) {
                this.decorations = null;
            }
            this.fireExhibitChangeEvent();
        }
    }

    public void clearDecorations() {
        if (this.decorations != null) {
            for (int i = 0; i < this.decorations.size(); ++i) {
                this.decorations.get(i).removeChangeListener(this);
            }
            this.decorations = null;
            this.fireExhibitChangeEvent();
        }
    }

    public Decoration[] getDecorations() {
        if (this.decorations == null) {
            return new Decoration[0];
        }
        Decoration[] decorationArray = new Decoration[this.decorations.size()];
        this.decorations.toArray(decorationArray);
        return decorationArray;
    }

    public View getDefaultView() {
        return new View();
    }

    public View[] getAlternativeViews() {
        return null;
    }

    public double[] getDefaultWindow() {
        if (this.defaultWindow != null) {
            return this.defaultWindow;
        }
        return new double[]{-5.0, 5.0, -5.0, 5.0};
    }

    public void setDefaultWindow(double d, double d2, double d3, double d4) {
        this.defaultWindow = new double[]{d, d2, d3, d4};
    }

    public void setDefaultWindow(double[] dArray) {
        this.setDefaultWindow(dArray[0], dArray[1], dArray[2], dArray[3]);
    }

    public Transform getDefaultTransform(View view) {
        double[] dArray = this.getDefaultWindow();
        return new Transform(dArray[0], dArray[1], dArray[2], dArray[3]);
    }

    public Color getDefaultBackground() {
        return this.defaultBackground;
    }

    public void setDefaultBackground(Color color) {
        this.defaultBackground = color == null ? Color.white : color;
        if (this.defaultBackground.getRed() < 150 && this.defaultBackground.getGreen() < 120 && this.defaultBackground.getBlue() < 150) {
            this.setDefaultForeground(Color.white);
        } else {
            this.setDefaultForeground(Color.black);
        }
    }

    public Color getDefaultForeground() {
        return this.defaultForeground;
    }

    public void setDefaultForeground(Color color) {
        this.defaultForeground = color == null ? Color.black : color;
    }

    public Animation getCreateAnimation(View view) {
        return null;
    }

    public BasicAnimator getMorphingAnimation(final View view, int n) {
        Parameter[] parameterArray = view.getViewAndExhibitParameters();
        if (parameterArray == null) {
            return null;
        }
        boolean bl = false;
        for (int i = 0; i < parameterArray.length; ++i) {
            if (!(parameterArray[i] instanceof Animateable) || !((Animateable)((Object)parameterArray[i])).reallyAnimated()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return null;
        }
        BasicAnimator basicAnimator = new BasicAnimator(this.framesForMorphing){

            public void animationStarting() {
                Exhibit.this.morphingView = view;
                Exhibit.this.isMorphing = true;
            }

            public void animationEnding() {
                Exhibit.this.morphingView = null;
                Exhibit.this.isMorphing = false;
            }
        };
        if (this.useFilmstripForMorphing) {
            basicAnimator.setUseFilmstrip(true);
            basicAnimator.setMillisecondsPerFrame(100);
        }
        for (int i = 0; i < parameterArray.length; ++i) {
            if (!(parameterArray[i] instanceof Animateable)) continue;
            basicAnimator.addAnimatedItem((Animateable)((Object)parameterArray[i]));
        }
        basicAnimator.setLooping(n);
        return basicAnimator;
    }

    public Animation getBuildAnimation(View view) {
        return null;
    }

    public void forceRedraw() {
        this.exhibitNeedsRedraw = true;
        this.fireExhibitChangeEvent();
    }

    public void render(Graphics2D graphics2D, View view, Transform transform, ArrayList<Decoration> arrayList) {
        Object object;
        int n;
        int n2 = (this.decorations == null ? 0 : this.decorations.size()) + (arrayList == null ? 0 : arrayList.size());
        Decoration[] decorationArray = null;
        if (n2 > 0) {
            int n3;
            int n4;
            int n5 = 0;
            decorationArray = new Decoration[n2];
            if (this.decorations != null) {
                for (n = 0; n < this.decorations.size(); ++n) {
                    object = this.decorations.get(n);
                    for (n4 = 0; n4 < n5 && ((Decoration)object).getLayer() >= decorationArray[n4].getLayer(); ++n4) {
                    }
                    for (n3 = n5; n3 > n4; --n3) {
                        decorationArray[n3] = decorationArray[n3 - 1];
                    }
                    decorationArray[n4] = object;
                    ++n5;
                }
            }
            if (arrayList != null) {
                for (n = 0; n < arrayList.size(); ++n) {
                    object = arrayList.get(n);
                    for (n4 = 0; n4 < n5 && ((Decoration)object).getLayer() >= decorationArray[n4].getLayer(); ++n4) {
                    }
                    for (n3 = n5; n3 > n4; --n3) {
                        decorationArray[n3] = decorationArray[n3 - 1];
                    }
                    decorationArray[n4] = object;
                    ++n5;
                }
            }
        }
        Animation animation = null;
        if (!view.getFastDrawing() && view.getDisplay() != null && view.getDisplay().getStatus() != "running" && view.getDisplay().getStatus() != "paused") {
            animation = this.getBuildAnimation(view);
        }
        this.computeDrawDataHook(view, transform);
        if (decorationArray != null) {
            for (n = 0; n < decorationArray.length; ++n) {
                decorationArray[n].computeDrawData(view, this.exhibitNeedsRedraw, this.previousTransform, transform);
                decorationArray[n].decorationNeedsRedraw = false;
            }
        }
        this.exhibitNeedsRedraw = false;
        if (decorationArray != null) {
            for (n = 0; n < decorationArray.length && decorationArray[n].getLayer() < 0; ++n) {
                decorationArray[n].doDraw(graphics2D, view, transform);
            }
        }
        if (animation == null) {
            this.doDrawHook(graphics2D, view, transform);
            if (decorationArray != null) {
                while (n < decorationArray.length) {
                    decorationArray[n].doDraw(graphics2D, view, transform);
                    ++n;
                }
            }
        } else {
            final Animation animation2 = animation;
            object = view;
            Decoration[] decorationArray2 = null;
            if (decorationArray != null && n < decorationArray.length) {
                decorationArray2 = new Decoration[decorationArray.length - n];
                for (int i = n; i < decorationArray.length; ++i) {
                    decorationArray2[i - n] = decorationArray[i];
                }
            }
            Decoration[] decorationArray3 = decorationArray2;
            view.installBuildAnimation(animation);
            animation.addChangeListener(new ChangeListener((View)object, decorationArray3){
                final /* synthetic */ View val$theView;
                final /* synthetic */ Decoration[] val$theDecs;
                {
                    this.val$theView = view;
                    this.val$theDecs = decorationArray;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    if (!animation2.isRunning() && animation2 == this.val$theView.getBuildAnimation()) {
                        this.val$theView.installBuildAnimation(null);
                        if (this.val$theDecs != null && this.val$theView.beginDrawToOffscreenImage()) {
                            for (int i = 0; i < this.val$theDecs.length; ++i) {
                                this.val$theDecs[i].doDraw(this.val$theView.getTransform().getGraphics(), this.val$theView, this.val$theView.getTransform());
                            }
                            this.val$theView.endDrawToOffscreenImage();
                            this.val$theView.getDisplay().repaint();
                        }
                    }
                }
            });
        }
    }

    protected void computeDrawDataHook(View view, Transform transform) {
        this.computeDrawData(view, this.exhibitNeedsRedraw, this.previousTransform, transform);
        this.previousTransform = (Transform)transform.clone();
    }

    protected void doDrawHook(Graphics2D graphics2D, View view, Transform transform) {
        this.doDraw(graphics2D, view, transform);
    }

    protected void computeDrawData(View view, boolean bl, Transform transform, Transform transform2) {
    }

    protected void doDraw(Graphics2D graphics2D, View view, Transform transform) {
    }
}

