/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vmm.core.Animation;
import vmm.core.Exhibit;
import vmm.core.Filmstrip;
import vmm.core.I18n;
import vmm.core.MouseTask;
import vmm.core.TimerAnimation;
import vmm.core.View;

public class Display
extends JPanel {
    private View mainView;
    private Animation animation;
    private MouseTask mouseTask;
    private MouseTask oneShotMouseTask;
    private View auxiliaryView;
    private int auxiliaryViewPosition;
    private MouseTask auxiliaryMouseTask;
    private boolean oneShotMouseTaskIsForMainView;
    private double auxiliaryViewFraction;
    private boolean auxiliaryViewIsResizable;
    private Rectangle mainViewRect;
    private Rectangle auxViewRect;
    private Rectangle dividingBarRect;
    private Rectangle basisUsedForComputingRects;
    private MouseTask dragTask;
    private boolean draggingInMainView;
    private boolean mouseInMainView = true;
    private boolean mouseInAuxView = false;
    private double timeDilationForAnimations = 1.0;
    private boolean stopAnimationsOnResize = true;
    private Filmstrip savedFilmstrip;
    private int savedFilmstripLooping;
    private String status;
    private Font saveOriginalFont;
    private DisplayHolder holder;
    private boolean showStatusBar = true;
    private Timer resizeTimer;
    public static final String FILMSTRIP_AVAILABLE_PROPERTY = "FilmstripAvailable";
    public static final String STATUS_PROPERTY = "Status";
    public static final String STATUS_EMPTY = "empty";
    public static final String STATUS_IDLE = "idle";
    public static final String STATUS_ANIMATION_RUNNING = "running";
    public static final String STATUS_ANIMATION_PAUSED = "paused";
    public static final String STATUS_ONE_SHOT_MOUSE_TASK = "mouse task";
    public static final int AUX_VIEW_ON_LEFT = 0;
    public static final int AUX_VIEW_ON_RIGHT = 1;
    public static final int AUX_VIEW_ON_TOP = 2;
    public static final int AUX_VIEW_ON_BOTTOM = 3;
    private Dimension previousSize;

    public Display() {
        this.enableEvents(1L);
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
        this.setOpaque(true);
        this.status = STATUS_EMPTY;
        this.saveOriginalFont = this.getFont();
    }

    public String getStatus() {
        return this.status;
    }

    private void setStatus(String string) {
        if (string == STATUS_IDLE && this.getExhibit() == null) {
            string = STATUS_EMPTY;
        }
        if (string != this.status) {
            String string2 = this.status;
            this.status = string;
            this.firePropertyChange(STATUS_PROPERTY, string2, string);
        }
        this.setStatusText(null);
    }

    private void setSavedFilmstrip(Filmstrip filmstrip, int n) {
        boolean bl;
        if (this.savedFilmstrip == filmstrip && this.savedFilmstripLooping == n) {
            return;
        }
        boolean bl2 = this.savedFilmstrip != null;
        this.savedFilmstrip = filmstrip;
        this.savedFilmstripLooping = n;
        boolean bl3 = bl = this.savedFilmstrip != null;
        if (bl != bl2) {
            this.firePropertyChange(FILMSTRIP_AVAILABLE_PROPERTY, new Boolean(bl2), new Boolean(bl));
        }
    }

    public Filmstrip getSavedFilmstrip() {
        return this.savedFilmstrip;
    }

    public int getSavedFilmstripLooping() {
        if (this.savedFilmstrip == null) {
            return -1;
        }
        return this.savedFilmstripLooping;
    }

    public synchronized void install(View view, Exhibit exhibit) {
        this.stopAnimation();
        this.cancelMouseTasks();
        this.resetHolder();
        this.auxiliaryView = null;
        this.mouseInMainView = true;
        this.mainViewRect = null;
        if (this.auxiliaryView != null) {
            this.auxiliaryView.setExhibit(null);
            this.auxiliaryView.finish();
        }
        this.setFont(this.saveOriginalFont);
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
        this.setStopAnimationsOnResize(true);
        if (exhibit != null && view == null) {
            view = exhibit.getDefaultView();
        }
        if (this.mainView != null && view != this.mainView) {
            this.mainView.setExhibit(null);
            this.mainView.finish();
        }
        if (this.mainView != null) {
            this.mainView.setDisplay(null);
        }
        if (view == null) {
            this.mainView = null;
            this.repaint();
            this.setStatus(STATUS_EMPTY);
            this.setSavedFilmstrip(null, 0);
            return;
        }
        if (exhibit != null) {
            view.setExhibit(exhibit);
        } else {
            exhibit = view.getExhibit();
        }
        this.mainView = view;
        view.setDisplay(this);
        this.installMouseTask(view.getDefaultMouseTask());
        this.setStatus(exhibit == null ? STATUS_EMPTY : STATUS_IDLE);
        this.setSavedFilmstrip(null, 0);
        this.repaint();
    }

    public View getView() {
        return this.mainView;
    }

    public synchronized boolean installAuxiliaryView(View view, View view2) {
        return this.installAuxiliaryView(view, view2, 0, 0.5, false);
    }

    public synchronized boolean installAuxiliaryView(View view, View view2, int n, double d, boolean bl) {
        if (this.mainView != view) {
            return false;
        }
        this.stopAnimation();
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("Illegal auxiliary view positon.");
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Illegal fractional size for view.");
        }
        if (this.oneShotMouseTask != null) {
            this.oneShotMouseTask.finish(this, view);
            this.oneShotMouseTask = null;
        }
        if (this.auxiliaryView != null && this.auxiliaryMouseTask != null) {
            this.auxiliaryMouseTask.finish(this, this.auxiliaryView);
            this.auxiliaryMouseTask = null;
        }
        if (this.auxiliaryView != null) {
            this.auxiliaryView.setDisplay(null);
            this.auxiliaryView.finish();
        }
        this.auxiliaryView = view2;
        if (this.auxiliaryView != null) {
            this.auxiliaryView.setDisplay(this);
            this.installAuxiliaryMouseTask(this.auxiliaryView.getDefaultMouseTask());
        }
        this.auxiliaryViewPosition = n;
        this.auxiliaryViewIsResizable = bl;
        this.auxiliaryViewFraction = d;
        this.setStatus(STATUS_IDLE);
        this.setStatusText(null);
        this.mainViewRect = null;
        this.repaint();
        return true;
    }

    private void makeViewRects() {
        int n;
        int n2;
        Insets insets = this.getInsets();
        this.mainViewRect = insets == null ? new Rectangle(0, 0, this.getWidth(), this.getHeight()) : new Rectangle(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
        if (this.auxiliaryView == null) {
            this.dividingBarRect = null;
            this.auxViewRect = null;
            return;
        }
        this.auxViewRect = new Rectangle(this.mainViewRect);
        if (this.auxiliaryViewPosition == 3 || this.auxiliaryViewPosition == 2) {
            n2 = (int)(this.auxiliaryViewFraction * (double)(this.mainViewRect.height - 7));
            n = this.mainViewRect.height - 7 - n2;
        } else {
            n2 = (int)(this.auxiliaryViewFraction * (double)(this.mainViewRect.width - 7));
            n = this.mainViewRect.width - 7 - n2;
        }
        n2 = Math.max(n2, 0);
        n = Math.max(n, 0);
        if (n2 == 0 && n == 0) {
            this.dividingBarRect = this.mainViewRect;
            this.mainViewRect = this.auxViewRect = new Rectangle(0, 0, 0, 0);
            return;
        }
        switch (this.auxiliaryViewPosition) {
            case 0: {
                this.mainViewRect.x = this.mainViewRect.x + 7 + n2;
                this.mainViewRect.width = n;
                this.auxViewRect.width = n2;
                this.dividingBarRect = new Rectangle(this.auxViewRect.x + this.auxViewRect.width, this.auxViewRect.y, 7, this.auxViewRect.height);
                break;
            }
            case 1: {
                this.auxViewRect.x = this.auxViewRect.x + 7 + n;
                this.mainViewRect.width = n;
                this.auxViewRect.width = n2;
                this.dividingBarRect = new Rectangle(this.mainViewRect.x + this.mainViewRect.width, this.mainViewRect.y, 7, this.mainViewRect.height);
                break;
            }
            case 2: {
                this.mainViewRect.y = this.mainViewRect.y + 7 + n2;
                this.mainViewRect.height = n;
                this.auxViewRect.height = n2;
                this.dividingBarRect = new Rectangle(this.auxViewRect.x, this.auxViewRect.y + this.auxViewRect.height, this.auxViewRect.width, 7);
                break;
            }
            case 3: {
                this.auxViewRect.y = this.auxViewRect.y + 7 + n;
                this.mainViewRect.height = n;
                this.auxViewRect.height = n2;
                this.dividingBarRect = new Rectangle(this.mainViewRect.x, this.mainViewRect.y + this.mainViewRect.height, this.mainViewRect.width, 7);
            }
        }
    }

    public Exhibit getExhibit() {
        return this.mainView == null ? null : this.mainView.getExhibit();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.mainView == null) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            ((Graphics2D)graphics).setBackground(this.mainView.getBackground());
            graphics.setColor(this.mainView.getForeground());
            Insets insets = this.getInsets();
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            BufferedImage bufferedImage = null;
            if (this.animation != null && this.animation instanceof TimerAnimation) {
                bufferedImage = ((TimerAnimation)this.animation).getCurrentFilmstripFrame();
            }
            if (bufferedImage != null) {
                graphics.drawImage(bufferedImage, insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom, null);
            } else {
                Rectangle rectangle = new Rectangle(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
                if (this.mainViewRect == null || !rectangle.equals(this.basisUsedForComputingRects)) {
                    this.makeViewRects();
                    this.basisUsedForComputingRects = rectangle;
                }
                if (this.dividingBarRect != null) {
                    graphics.setColor(Color.GRAY);
                    graphics.fillRect(this.dividingBarRect.x, this.dividingBarRect.y, this.dividingBarRect.width, this.dividingBarRect.height);
                    graphics.setColor(Color.DARK_GRAY);
                    graphics.drawRect(this.dividingBarRect.x, this.dividingBarRect.y, this.dividingBarRect.width - 1, this.dividingBarRect.height - 1);
                    graphics.setColor(this.mainView.getForeground());
                }
                Graphics graphics2 = null;
                Graphics graphics3 = graphics.create(this.mainViewRect.x, this.mainViewRect.y, this.mainViewRect.width, this.mainViewRect.height);
                this.mainView.render((Graphics2D)graphics3, this.mainViewRect.width, this.mainViewRect.height);
                if (this.auxiliaryView != null) {
                    graphics2 = graphics.create(this.auxViewRect.x, this.auxViewRect.y, this.auxViewRect.width, this.auxViewRect.height);
                    this.auxiliaryView.render((Graphics2D)graphics2, this.auxViewRect.width, this.auxViewRect.height);
                    graphics2.dispose();
                }
                if (this.animation != null && this.animation instanceof TimerAnimation && ((TimerAnimation)this.animation).getUseFilmstrip()) {
                    int n;
                    int n2;
                    String string = "";
                    if (this.mainView.buildingImageForFilmstrip) {
                        n2 = Math.max(0, ((TimerAnimation)this.animation).getFrameNumber());
                        n = ((TimerAnimation)this.animation).getFrames();
                        string = n <= 0 ? I18n.tr("vmm.core.Display.BuildingFrameNum", "" + n2) + string : I18n.tr("vmm.core.Display.BuildingFrameNumOf", "" + n2, "" + n) + string;
                    } else if (((TimerAnimation)this.animation).getFrameNumber() >= 0) {
                        try {
                            BufferedImage bufferedImage2;
                            if (this.auxiliaryView == null) {
                                bufferedImage2 = this.mainView.getImage(true);
                            } else {
                                bufferedImage2 = new BufferedImage(this.getWidth() - insets.left - insets.right, this.getHeight() - insets.left - insets.right, 1);
                                Graphics graphics4 = bufferedImage2.getGraphics();
                                Graphics2D graphics2D = (Graphics2D)graphics4.create(this.mainViewRect.x - insets.left, this.mainViewRect.y - insets.top, this.mainViewRect.width, this.mainViewRect.height);
                                this.mainView.render(graphics2D, this.mainViewRect.width, this.mainViewRect.height);
                                graphics2D.dispose();
                                graphics2D = (Graphics2D)graphics4.create(this.auxViewRect.x - insets.left, this.auxViewRect.y - insets.top, this.auxViewRect.width, this.auxViewRect.height);
                                this.auxiliaryView.render(graphics2D, this.auxViewRect.width, this.auxViewRect.height);
                                graphics2D.dispose();
                                graphics4.setColor(Color.GRAY);
                                graphics4.fillRect(this.dividingBarRect.x - insets.left, this.dividingBarRect.y - insets.top, this.dividingBarRect.width, this.dividingBarRect.height);
                                graphics4.setColor(Color.DARK_GRAY);
                                graphics4.drawRect(this.dividingBarRect.x - insets.left, this.dividingBarRect.y - insets.top, this.dividingBarRect.width - 1, this.dividingBarRect.height - 1);
                                graphics4.dispose();
                            }
                            ((TimerAnimation)this.animation).saveCurrentFrame(bufferedImage2);
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            string = I18n.tr("vmm.core.Display.OutOfMemDuringAnimation");
                        }
                        n2 = ((TimerAnimation)this.animation).getFrameNumber();
                        n = ((TimerAnimation)this.animation).getFrames();
                        string = n <= 0 ? I18n.tr("vmm.core.Display.FrameNum", "" + n2) + string : I18n.tr("vmm.core.Display.FrameNumOf", "" + n2, "" + n) + string;
                    }
                    if (string.length() > 0) {
                        graphics3.dispose();
                        graphics3 = graphics.create();
                        FontMetrics fontMetrics = graphics3.getFontMetrics(graphics3.getFont());
                        n = fontMetrics.getAscent() + fontMetrics.getDescent() + 10;
                        int n3 = fontMetrics.stringWidth(string) + 10;
                        graphics3.setColor(Color.LIGHT_GRAY);
                        graphics3.fillRect(5 + insets.left, this.getHeight() - insets.bottom - n - 5, n3, n);
                        graphics3.setColor(Color.BLACK);
                        graphics3.drawRect(5 + insets.left, this.getHeight() - insets.bottom - n - 5, n3 - 1, n - 1);
                        graphics3.drawString(string, 10 + insets.left, this.getHeight() - insets.bottom - 10 - fontMetrics.getDescent());
                    }
                }
                graphics3.dispose();
                if (this.dragTask != null) {
                    if (this.auxiliaryView == null || this.draggingInMainView) {
                        graphics3 = graphics.create(this.mainViewRect.x, this.mainViewRect.y, this.mainViewRect.width, this.mainViewRect.height);
                        this.dragTask.drawWhileDragging((Graphics2D)graphics3, this, this.mainView, this.mainViewRect.width, this.mainViewRect.height);
                    } else {
                        graphics3 = graphics.create(this.auxViewRect.x, this.auxViewRect.y, this.auxViewRect.width, this.auxViewRect.height);
                        this.dragTask.drawWhileDragging((Graphics2D)graphics3, this, this.auxiliaryView, this.auxViewRect.width, this.auxViewRect.height);
                    }
                    graphics3.dispose();
                }
            }
        }
    }

    protected void chooseCursor() {
        Cursor cursor = null;
        if (this.animation != null && this.animation.isRunning()) {
            cursor = Cursor.getPredefinedCursor(3);
        } else if (this.oneShotMouseTask != null) {
            if (this.mouseInMainView && this.oneShotMouseTaskIsForMainView) {
                cursor = this.oneShotMouseTask.getCursor(this, this.mainView);
            } else if (this.mouseInAuxView && !this.oneShotMouseTaskIsForMainView) {
                cursor = this.oneShotMouseTask.getCursor(this, this.auxiliaryView);
            }
        } else if (this.mouseInMainView && this.mouseTask != null) {
            cursor = this.mouseTask.getCursor(this, this.mainView);
        } else if (this.mouseInAuxView && this.auxiliaryMouseTask != null) {
            cursor = this.auxiliaryMouseTask.getCursor(this, this.auxiliaryView);
        }
        if (cursor == null) {
            cursor = Cursor.getDefaultCursor();
        }
        this.setCursor(cursor);
    }

    public synchronized void installAnimation(Animation animation) {
        if (this.animation != null) {
            this.animation.cancel();
        }
        if (this.oneShotMouseTask != null) {
            this.oneShotMouseTask.finish(this, this.oneShotMouseTaskIsForMainView ? this.mainView : this.auxiliaryView);
        }
        this.dragTask = null;
        this.oneShotMouseTask = null;
        this.animation = animation;
        if (animation != null) {
            final Animation animation2 = animation;
            animation.setTimeDilation(this.timeDilationForAnimations);
            animation.addChangeListener(new ChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void stateChanged(ChangeEvent changeEvent) {
                    if (!animation2.isRunning()) {
                        Display display = Display.this;
                        synchronized (display) {
                            if (Display.this.animation == animation2) {
                                Display.this.stopAnimation();
                            }
                        }
                    }
                }
            });
            if (this.animation instanceof TimerAnimation) {
                ((TimerAnimation)this.animation).setDisplay(this);
                if (((TimerAnimation)this.animation).getUseFilmstrip()) {
                    this.setSavedFilmstrip(null, 0);
                }
            }
            animation.start();
            this.setStatus(STATUS_ANIMATION_RUNNING);
        } else {
            this.setStatus(STATUS_IDLE);
        }
        this.chooseCursor();
    }

    public synchronized void stopAnimation() {
        if (this.animation != null) {
            if (this.animation.isRunning()) {
                this.animation.cancel();
            }
            if (this.animation instanceof TimerAnimation) {
                ((TimerAnimation)this.animation).setDisplay(null);
                Filmstrip filmstrip = ((TimerAnimation)this.animation).getFilmstrip();
                if (filmstrip != null) {
                    filmstrip.stripNullFrames();
                    int n = ((TimerAnimation)this.animation).getLooping();
                    if (n == 1) {
                        filmstrip.setFrame(filmstrip.getFrameCount() + 1, null);
                    }
                    if (filmstrip.getFrameCount() > 1) {
                        this.setSavedFilmstrip(filmstrip, n);
                    }
                }
            }
            this.animation = null;
            this.setStatus(STATUS_IDLE);
            this.repaint();
        }
        this.chooseCursor();
    }

    public synchronized void toggleAnimationPaused() {
        if (this.animation != null && this.animation.isRunning()) {
            this.animation.setPaused(!this.animation.isPaused());
            this.setStatus(this.animation.isPaused() ? STATUS_ANIMATION_PAUSED : STATUS_ANIMATION_RUNNING);
        }
    }

    public synchronized void setTimeDilationForAnimations(double d) {
        if (d < 0.2) {
            d = 0.2;
        } else if (d > 100.0) {
            d = 100.0;
        }
        this.timeDilationForAnimations = d;
        if (this.animation != null) {
            this.animation.setTimeDilation(d);
        }
    }

    public double getTimeDilationForAnimations() {
        return this.timeDilationForAnimations;
    }

    public void discardFilmstrip() {
        this.setSavedFilmstrip(null, 0);
    }

    public void playFilmstrip(final Filmstrip filmstrip, int n, Dimension dimension) {
        if (filmstrip == null) {
            return;
        }
        final View view = this.mainView == null ? new View() : null;
        final boolean bl = this.getStopAnimationsOnResize();
        final Dimension dimension2 = dimension == null ? null : this.getSize();
        this.setStopAnimationsOnResize(false);
        if (dimension != null && !dimension.equals(this.getSize())) {
            if (dimension.equals(this.getPreferredSize())) {
                ++dimension.height;
            }
            this.setPreferredSize(dimension);
        }
        TimerAnimation timerAnimation = new TimerAnimation(){

            protected void drawFrame() {
                Display.this.repaint();
            }

            BufferedImage getCurrentFilmstripFrame() {
                return filmstrip.getFrame(this.frameNumber);
            }

            protected void animationStarting() {
                if (view != null) {
                    Display.this.mainView = view;
                }
            }

            protected void animationEnding() {
                if (view != null) {
                    Display.this.mainView = null;
                }
                if (dimension2 != null) {
                    Display.this.setPreferredSize(dimension2);
                }
                Display.this.setStopAnimationsOnResize(bl);
            }
        };
        timerAnimation.setFrames(filmstrip.getFrameCount() - 1);
        timerAnimation.setLooping(n);
        timerAnimation.setMillisecondsPerFrame(100);
        this.installAnimation(timerAnimation);
    }

    public void playFilmstrip() {
        if (this.savedFilmstrip == null) {
            return;
        }
        TimerAnimation timerAnimation = new TimerAnimation(){

            protected void drawFrame() {
            }
        };
        timerAnimation.setFilmstrip(this.savedFilmstrip);
        timerAnimation.setLooping(this.savedFilmstripLooping);
        timerAnimation.setMillisecondsPerFrame(100);
        this.installAnimation(timerAnimation);
    }

    public boolean getStopAnimationsOnResize() {
        return this.stopAnimationsOnResize;
    }

    public void setStopAnimationsOnResize(boolean bl) {
        this.stopAnimationsOnResize = bl;
    }

    public synchronized void installMouseTask(MouseTask mouseTask) {
        if (this.oneShotMouseTask != null && this.oneShotMouseTaskIsForMainView) {
            this.oneShotMouseTask.finish(this, this.mainView);
            this.setStatus(STATUS_IDLE);
            this.oneShotMouseTask = null;
        }
        this.dragTask = null;
        if (this.mouseTask != null) {
            this.mouseTask.finish(this, this.mainView);
        }
        this.mouseTask = mouseTask;
        if (this.mouseTask != null) {
            this.mouseTask.start(this, this.mainView);
        }
        this.chooseCursor();
        this.setStatusText(null);
    }

    public MouseTask getMouseTask() {
        return this.mouseTask;
    }

    public synchronized void installAuxiliaryMouseTask(MouseTask mouseTask) {
        if (this.auxiliaryView == null) {
            return;
        }
        if (this.oneShotMouseTask != null && !this.oneShotMouseTaskIsForMainView) {
            this.oneShotMouseTask.finish(this, this.auxiliaryView);
            this.setStatus(STATUS_IDLE);
            this.oneShotMouseTask = null;
        }
        this.dragTask = null;
        if (this.auxiliaryMouseTask != null) {
            this.auxiliaryMouseTask.finish(this, this.auxiliaryView);
        }
        this.auxiliaryMouseTask = mouseTask;
        if (this.auxiliaryMouseTask != null) {
            this.auxiliaryMouseTask.start(this, this.auxiliaryView);
        }
        this.chooseCursor();
        this.setStatusText(null);
    }

    public synchronized void installOneShotMouseTask(MouseTask mouseTask) {
        if (this.oneShotMouseTask != null) {
            this.oneShotMouseTask.finish(this, this.mainView);
        }
        this.oneShotMouseTaskIsForMainView = true;
        this.dragTask = null;
        this.oneShotMouseTask = mouseTask;
        if (this.oneShotMouseTask != null) {
            this.stopAnimation();
            this.oneShotMouseTask.start(this, this.mainView);
            this.setStatus(STATUS_ONE_SHOT_MOUSE_TASK);
        } else {
            this.setStatus(STATUS_IDLE);
        }
        this.chooseCursor();
    }

    public synchronized void installAuxiliaryOneShotMouseTask(MouseTask mouseTask) {
        if (this.auxiliaryView == null) {
            return;
        }
        if (this.oneShotMouseTask != null) {
            this.oneShotMouseTask.finish(this, this.oneShotMouseTaskIsForMainView ? this.mainView : this.auxiliaryView);
        }
        this.dragTask = null;
        this.oneShotMouseTaskIsForMainView = false;
        this.oneShotMouseTask = mouseTask;
        if (this.oneShotMouseTask != null) {
            this.stopAnimation();
            this.oneShotMouseTask.start(this, this.auxiliaryView);
            this.setStatus(STATUS_ONE_SHOT_MOUSE_TASK);
        } else {
            this.setStatus(STATUS_IDLE);
        }
        this.chooseCursor();
    }

    protected synchronized void cancelMouseTasks() {
        if (this.oneShotMouseTask != null) {
            this.oneShotMouseTask.finish(this, this.oneShotMouseTaskIsForMainView ? this.mainView : this.auxiliaryView);
        }
        if (this.auxiliaryMouseTask != null) {
            this.auxiliaryMouseTask.finish(this, this.auxiliaryView);
        }
        if (this.mouseTask != null) {
            this.mouseTask.finish(this, this.mainView);
        }
        this.auxiliaryMouseTask = null;
        this.mouseTask = null;
        this.oneShotMouseTask = null;
        this.dragTask = null;
        this.chooseCursor();
    }

    public void setShowStatusBar(boolean bl) {
        if (bl == this.showStatusBar) {
            return;
        }
        if (this.holder != null) {
            if (bl) {
                this.holder.add((Component)this.holder.statusBar, "South");
            } else {
                this.holder.remove(this.holder.statusBar);
            }
            this.validate();
        }
        this.showStatusBar = bl;
    }

    public boolean getShowStatusBar() {
        return this.showStatusBar;
    }

    public String getStatusText() {
        if (this.holder == null) {
            return null;
        }
        return this.holder.statusBar.getText();
    }

    public void setStatusText() {
        this.setStatusText(null);
    }

    public synchronized void setStatusText(String string) {
        if (this.holder != null) {
            if (string == null) {
                if (this.status == STATUS_EMPTY || this.getExhibit() == null) {
                    string = I18n.tr("vmm.core.Display.statusbar.noExhibit");
                } else if (this.status == STATUS_ANIMATION_RUNNING) {
                    string = this.animation.getStatusText(true);
                    if (string == null) {
                        string = I18n.tr("vmm.core.Display.statusbar.animationRunning");
                    }
                } else if (this.status == STATUS_ANIMATION_PAUSED) {
                    string = this.animation.getStatusText(false);
                    if (string == null) {
                        string = I18n.tr("vmm.core.Display.statusbar.animationPaused");
                    }
                } else if (this.status == STATUS_ONE_SHOT_MOUSE_TASK) {
                    string = this.oneShotMouseTask.getStatusText();
                    if (string == null) {
                        string = I18n.tr("vmm.core.Display.statusbar.oneShotMouseTask");
                    }
                } else {
                    if (this.mouseTask != null) {
                        string = this.mouseTask.getStatusText();
                    }
                    if (string == null) {
                        string = this.mainView.getStatusText();
                    }
                    if (string == null) {
                        string = this.getExhibit().getTitle();
                    }
                }
            }
            this.holder.statusBar.setText(string);
        }
    }

    public void addBorderComponent(Component component, Object object) {
        if (object != "North" && object != "East" && object != "West" && object != "South") {
            throw new IllegalArgumentException("Internal Error:  Border component position must be north, south, east, or west.");
        }
        if (this.holder != null) {
            if (object == "South" && this.showStatusBar) {
                this.holder.remove(this.holder.statusBar);
                this.showStatusBar = false;
            }
            this.holder.add(component, object);
            this.holder.validate();
        }
    }

    public void removeBorderComponent(Component component) {
        if (this.holder != null) {
            this.holder.remove(component);
            this.holder.validate();
        }
    }

    public JSplitPane split(Component component) {
        return this.split(component, false, false);
    }

    public JSplitPane split(Component component, boolean bl, boolean bl2) {
        if (this.holder != null) {
            if (this.holder.splitPane != null) {
                this.holder.remove(this.holder.splitPane);
            } else {
                this.holder.remove(this);
            }
            Component component2 = bl2 ? component : this;
            Component component3 = bl2 ? this : component;
            JSplitPane jSplitPane = bl ? new JSplitPane(0, component2, component3) : new JSplitPane(1, component2, component3);
            jSplitPane.setBorder(null);
            this.holder.add((Component)jSplitPane, "Center");
            this.holder.validate();
            jSplitPane.setDividerLocation(0.5);
            jSplitPane.setResizeWeight(0.5);
            this.holder.splitPane = jSplitPane;
            return this.holder.splitPane;
        }
        return null;
    }

    public void unsplit() {
        if (this.holder != null && this.holder.splitPane != null) {
            this.holder.remove(this.holder.splitPane);
            this.holder.splitPane = null;
            this.holder.add((Component)this, "Center");
            this.holder.validate();
        }
    }

    public void resetHolder() {
        if (this.holder != null) {
            this.holder.reset();
        }
    }

    public Container getHolder() {
        if (this.holder == null) {
            this.holder = new DisplayHolder();
        }
        return this.holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processComponentEvent(ComponentEvent componentEvent) {
        super.processComponentEvent(componentEvent);
        if (componentEvent.getID() == 101) {
            Object object;
            if (!this.stopAnimationsOnResize) {
                object = this;
                synchronized (object) {
                    if (this.animation == null || !(this.animation instanceof TimerAnimation) || !((TimerAnimation)this.animation).getUseFilmstrip()) {
                        return;
                    }
                }
            }
            if (this.previousSize != null && this.previousSize.equals(this.getSize())) {
                return;
            }
            this.previousSize = this.getSize();
            this.stopAnimation();
            if (this.getView() != null && this.getExhibit() != null) {
                object = this.getView();
                this.getView().setFastDrawing(true, false);
                if (this.resizeTimer != null) {
                    this.resizeTimer.stop();
                }
                this.resizeTimer = new Timer(0, new ActionListener((View)object){
                    final /* synthetic */ View val$view;
                    {
                        this.val$view = view;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.val$view.setFastDrawing(false, false);
                        Display.this.resizeTimer.stop();
                        Display.this.resizeTimer = null;
                    }
                });
                this.resizeTimer.setInitialDelay(500);
                this.resizeTimer.setRepeats(false);
                this.resizeTimer.start();
            }
        }
    }

    private class DisplayHolder
    extends JPanel {
        private JLabel statusBar;
        private JSplitPane splitPane;

        private DisplayHolder() {
            this.setLayout(new BorderLayout(1, 1));
            this.setBackground(Color.BLACK);
            this.statusBar = new JLabel(I18n.tr("vmm.core.Display.statusbar.noExhibit"));
            this.statusBar.setBorder(BorderFactory.createEmptyBorder(2, 2, 1, 1));
            this.statusBar.setBackground(Color.LIGHT_GRAY);
            this.statusBar.setForeground(Color.BLACK);
            this.statusBar.setOpaque(true);
            if (Display.this.showStatusBar) {
                this.add((Component)this.statusBar, "South");
            }
            this.add((Component)Display.this, "Center");
        }

        private void reset() {
            this.removeAll();
            this.setLayout(new BorderLayout(1, 1));
            this.setBackground(Color.BLACK);
            if (Display.this.showStatusBar) {
                this.add((Component)this.statusBar, "South");
            }
            this.add((Component)Display.this, "Center");
            this.statusBar.setText(I18n.tr("vmm.core.Display.statusbar.noExhibit"));
            this.validate();
        }
    }

    private class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        Rectangle rect;
        boolean draggingDividingBar;
        int barOffset;

        private MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (Display.this.dragTask != null) {
                return;
            }
            this.draggingDividingBar = false;
            if (Display.this.animation != null && Display.this.animation.isRunning()) {
                Display.this.stopAnimation();
                return;
            }
            if (Display.this.mainViewRect == null) {
                Display.this.makeViewRects();
            }
            if (Display.this.mainViewRect.contains(mouseEvent.getX(), mouseEvent.getY())) {
                this.rect = Display.this.mainViewRect;
                Display.this.mouseInMainView = (Display.this.draggingInMainView = true);
                Display.this.mouseInAuxView = false;
            } else if (Display.this.auxViewRect != null && Display.this.auxViewRect.contains(mouseEvent.getX(), mouseEvent.getY())) {
                this.rect = Display.this.auxViewRect;
                Display.this.mouseInMainView = (Display.this.draggingInMainView = false);
                Display.this.mouseInAuxView = true;
            } else {
                if (Display.this.dividingBarRect != null && Display.this.auxiliaryViewIsResizable && Display.this.dividingBarRect.contains(mouseEvent.getX(), mouseEvent.getY())) {
                    this.draggingDividingBar = true;
                    this.barOffset = Display.this.auxiliaryViewPosition == 0 || Display.this.auxiliaryViewPosition == 1 ? mouseEvent.getX() - ((Display)Display.this).dividingBarRect.x : mouseEvent.getY() - ((Display)Display.this).dividingBarRect.y;
                    Display.this.mainView.setFastDrawing(true);
                    Display.this.auxiliaryView.setFastDrawing(true);
                    return;
                }
                Display.this.mouseInMainView = (Display.this.mouseInAuxView = false);
                return;
            }
            mouseEvent.translatePoint(-this.rect.x, -this.rect.y);
            if (Display.this.oneShotMouseTask != null) {
                if (Display.this.auxiliaryView != null && Display.this.draggingInMainView != Display.this.oneShotMouseTaskIsForMainView) {
                    JOptionPane.showMessageDialog(Display.this, Display.this.oneShotMouseTaskIsForMainView ? I18n.tr("vmm.core.Display.PleaseClickRight") : I18n.tr("vmm.core.Display.PleaseClickLeft"));
                    return;
                }
                if (Display.this.oneShotMouseTask.doMouseDown(mouseEvent, Display.this, Display.this.oneShotMouseTaskIsForMainView ? Display.this.mainView : Display.this.auxiliaryView, this.rect.width, this.rect.height)) {
                    Display.this.dragTask = Display.this.oneShotMouseTask;
                } else if (!Display.this.oneShotMouseTask.wantsMoreClicks(Display.this, Display.this.oneShotMouseTaskIsForMainView ? Display.this.mainView : Display.this.auxiliaryView)) {
                    Display.this.oneShotMouseTask.finish(Display.this, Display.this.oneShotMouseTaskIsForMainView ? Display.this.mainView : Display.this.auxiliaryView);
                    Display.this.oneShotMouseTask = null;
                    Display.this.setStatus(Display.STATUS_IDLE);
                }
            } else if (Display.this.draggingInMainView) {
                if (Display.this.mouseTask != null && Display.this.mouseTask.doMouseDown(mouseEvent, Display.this, Display.this.mainView, this.rect.width, this.rect.height)) {
                    Display.this.dragTask = Display.this.mouseTask;
                }
            } else if (Display.this.auxiliaryMouseTask != null && Display.this.auxiliaryMouseTask.doMouseDown(mouseEvent, Display.this, Display.this.auxiliaryView, this.rect.width, this.rect.height)) {
                Display.this.dragTask = Display.this.auxiliaryMouseTask;
            }
            Cursor cursor = null;
            if (Display.this.dragTask != null) {
                cursor = Display.this.dragTask.getCursorForDragging(mouseEvent, Display.this, Display.this.draggingInMainView ? Display.this.mainView : Display.this.auxiliaryView);
                if (cursor != null) {
                    Display.this.setCursor(cursor);
                } else {
                    Display.this.setCursor(Cursor.getDefaultCursor());
                }
            } else {
                Display.this.chooseCursor();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.draggingDividingBar) {
                Display.this.mainView.setFastDrawing(false);
                Display.this.auxiliaryView.setFastDrawing(false);
                this.draggingDividingBar = false;
                Display.this.repaint();
            } else if (Display.this.dragTask != null) {
                mouseEvent.translatePoint(-this.rect.x, -this.rect.y);
                View view = Display.this.draggingInMainView ? Display.this.mainView : Display.this.auxiliaryView;
                Display.this.dragTask.doMouseUp(mouseEvent, Display.this, view, this.rect.width, this.rect.height);
                if (Display.this.dragTask == Display.this.oneShotMouseTask && Display.this.oneShotMouseTask != null && !Display.this.oneShotMouseTask.wantsMoreClicks(Display.this, view)) {
                    Display.this.oneShotMouseTask.finish(Display.this, view);
                    Display.this.oneShotMouseTask = null;
                    Display.this.setStatus(Display.STATUS_IDLE);
                }
                Display.this.dragTask = null;
                Display.this.chooseCursor();
                Display.this.repaint();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.draggingDividingBar) {
                Insets insets = Display.this.getInsets();
                if (insets == null) {
                    insets = new Insets(0, 0, 0, 0);
                }
                if (Display.this.auxiliaryViewPosition == 0 || Display.this.auxiliaryViewPosition == 1) {
                    int n = mouseEvent.getX() - this.barOffset;
                    if (n < insets.left) {
                        n = insets.left;
                    } else if (n > Display.this.getWidth() - insets.right - 7) {
                        n = Display.this.getWidth() - insets.right - 7;
                    }
                    if (n != ((Display)Display.this).dividingBarRect.x) {
                        double d = (double)(n - insets.left) / (double)(Display.this.getWidth() - insets.left - insets.right - 7);
                        if (d < 0.0) {
                            d = 0.0;
                        }
                        Display.this.auxiliaryViewFraction = Display.this.auxiliaryViewPosition == 0 ? d : 1.0 - d;
                        Display.this.mainViewRect = null;
                        Display.this.repaint();
                    }
                } else {
                    int n = mouseEvent.getY() - this.barOffset;
                    if (n < insets.top) {
                        n = insets.top;
                    } else if (n > Display.this.getHeight() - insets.bottom - 7) {
                        n = Display.this.getHeight() - insets.bottom - 7;
                    }
                    if (n != ((Display)Display.this).dividingBarRect.y) {
                        double d = (double)(n - insets.top) / (double)(Display.this.getHeight() - insets.top - insets.bottom - 7);
                        if (d < 0.0) {
                            d = 0.0;
                        }
                        Display.this.auxiliaryViewFraction = Display.this.auxiliaryViewPosition == 2 ? d : 1.0 - d;
                        Display.this.mainViewRect = null;
                        Display.this.repaint();
                    }
                }
            } else if (Display.this.dragTask != null) {
                mouseEvent.translatePoint(-this.rect.x, -this.rect.y);
                View view = Display.this.draggingInMainView ? Display.this.mainView : Display.this.auxiliaryView;
                Display.this.dragTask.doMouseDrag(mouseEvent, Display.this, view, this.rect.width, this.rect.height);
                Cursor cursor = Display.this.dragTask.getCursorForDragging(mouseEvent, Display.this, view);
                if (cursor != null) {
                    Display.this.setCursor(cursor);
                } else {
                    Display.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.checkCursor(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.checkCursor(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.checkCursor(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        private void checkCursor(int n, int n2) {
            if (Display.this.mainViewRect == null) {
                Display.this.makeViewRects();
            }
            Display.this.mouseInMainView = Display.this.mainViewRect.contains(n, n2);
            Display.this.mouseInAuxView = Display.this.auxViewRect != null && Display.this.auxViewRect.contains(n, n2);
            if (Display.this.auxiliaryView == null || Display.this.animation != null) {
                return;
            }
            if (Display.this.dividingBarRect.contains(n, n2)) {
                if (!Display.this.auxiliaryViewIsResizable) {
                    Display.this.setCursor(Cursor.getDefaultCursor());
                } else if (Display.this.auxiliaryViewPosition == 0 || Display.this.auxiliaryViewPosition == 1) {
                    Display.this.setCursor(Cursor.getPredefinedCursor(11));
                } else {
                    Display.this.setCursor(Cursor.getPredefinedCursor(8));
                }
            } else {
                Display.this.chooseCursor();
            }
        }
    }
}

