/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import vmm.core.Animateable;
import vmm.core.Complex;
import vmm.core.ComplexParam;
import vmm.core.Util;

public class ComplexParamAnimateable
extends ComplexParam
implements Animateable {
    private Complex animationStart;
    private Complex animationEnd;
    private Complex defaultAnimationStart;
    private Complex defaultAnimationEnd;
    private String animationStartString;
    private String animationEndString;
    private String defaultStartString;
    private String defaultEndString;

    public ComplexParamAnimateable() {
        this(null, (Complex)null);
    }

    public ComplexParamAnimateable(String string, Complex complex) {
        this(string, complex, complex, complex);
    }

    public ComplexParamAnimateable(String string, Complex complex, Complex complex2, Complex complex3) {
        super(string, complex);
        this.animationStart = this.defaultAnimationStart = new Complex(complex2);
        this.animationEnd = this.defaultAnimationEnd = new Complex(complex3);
    }

    public ComplexParamAnimateable(String string, String string2) {
        this(string, string2, string2, string2);
    }

    public ComplexParamAnimateable(String string, String string2, String string3, String string4) {
        super(string, string2);
        this.setAnimationStartFromString(string3);
        this.setAnimationEndFromString(string4);
        this.setDefaultAnimationStartFromString(string3);
        this.setDefaultAnimationEndFromString(string4);
    }

    public void reset(Complex complex) {
        complex = new Complex(complex);
        super.reset(complex);
        this.setAnimationLimitsAndDefaults(complex, complex);
    }

    public void reset(Complex complex, Complex complex2, Complex complex3) {
        super.reset(new Complex(complex));
        this.setAnimationLimitsAndDefaults(new Complex(complex2), new Complex(complex3));
    }

    public void reset(String string) {
        this.reset(string, string, string);
    }

    public void reset(String string, String string2, String string3) {
        super.reset(string);
        this.setAnimationStartFromString(string2);
        this.setAnimationEndFromString(string3);
        this.setDefaultAnimationStartFromString(string2);
        this.setDefaultAnimationEndFromString(string3);
    }

    public Complex getDefaultAnimationStart() {
        return this.defaultAnimationStart;
    }

    public Complex getDefaultAnimationEnd() {
        return this.defaultAnimationEnd;
    }

    public void setDefaultAnimationLimits(Complex complex, Complex complex2) {
        this.defaultAnimationStart = new Complex(complex);
        this.defaultAnimationEnd = new Complex(complex2);
        this.defaultEndString = null;
        this.defaultStartString = null;
    }

    public String getDefaultAnimationStartAsString() {
        return this.defaultStartString != null ? this.defaultStartString : Util.toExternalString(this.defaultAnimationStart);
    }

    public String getDefaultAnimationEndAsString() {
        return this.defaultEndString != null ? this.defaultEndString : Util.toExternalString(this.defaultAnimationEnd);
    }

    public void setDefaultAnimationStartFromString(String string) {
        Complex complex;
        this.defaultAnimationStart = complex = (Complex)this.stringToValueObject(string);
        this.defaultStartString = string;
    }

    public void setDefaultAnimationEndFromString(String string) {
        Complex complex;
        this.defaultAnimationEnd = complex = (Complex)this.stringToValueObject(string);
        this.defaultEndString = string;
    }

    public void setAnimationLimits(Complex complex, Complex complex2) {
        this.animationStart = new Complex(complex);
        this.animationEnd = new Complex(complex2);
    }

    public void setAnimationLimitsAndDefaults(Complex complex, Complex complex2) {
        this.setAnimationLimits(complex, complex2);
        this.setDefaultAnimationLimits(complex, complex2);
    }

    public void setAnimationStart(Complex complex) {
        this.animationStart = new Complex(complex);
        this.animationStartString = null;
    }

    public void setAnimationEnd(Complex complex) {
        this.animationEnd = new Complex(complex);
        this.animationEndString = null;
    }

    public Complex getAnimationStart() {
        return this.animationStart;
    }

    public Complex getAnimationEnd() {
        return this.animationEnd;
    }

    public void setAnimationStartFromString(String string) {
        Complex complex;
        this.animationStart = complex = (Complex)this.stringToValueObject(string);
        this.animationStartString = string;
    }

    public void setAnimationEndFromString(String string) {
        Complex complex;
        this.animationEnd = complex = (Complex)this.stringToValueObject(string);
        this.animationEndString = string;
    }

    public String getAnimationStartAsString() {
        return this.animationStartString != null ? this.animationStartString : Util.toExternalString(this.animationStart);
    }

    public String getAnimationEndAsString() {
        return this.animationEndString != null ? this.animationEndString : Util.toExternalString(this.animationEnd);
    }

    public void setFractionComplete(double d) {
        this.setValueObject(new Complex(this.animationStart.re + d * (this.animationEnd.re - this.animationStart.re), this.animationStart.im + d * (this.animationEnd.im - this.animationStart.im)));
    }

    public boolean reallyAnimated() {
        return !this.animationStart.equals(this.animationEnd);
    }
}

