/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import vmm.core.Complex;
import vmm.core.I18n;
import vmm.core.Parameter;
import vmm.core.Util;
import vmm.functions.ComplexExpression;
import vmm.functions.ParseError;

public class ComplexParam
extends Parameter {
    private Complex minimumValueForInput = new Complex(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    private Complex maximumValueForInput = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    public ComplexParam() {
        this(null, (Complex)null);
    }

    public ComplexParam(String string, Complex complex) {
        super(string, new Complex(complex));
    }

    public ComplexParam(String string, String string2) throws NumberFormatException {
        super(string, string2);
    }

    public void reset(Complex complex) {
        this.reset(new Complex(complex));
    }

    public void setValue(Complex complex) {
        this.setValueObject(new Complex(complex));
    }

    public Complex getValue() {
        Complex complex = (Complex)this.getValueObject();
        if (complex == null) {
            return new Complex(0.0, 0.0);
        }
        return complex;
    }

    public void setDefaultValue(double d) {
        this.setDefaultValueObject(new Complex(d));
    }

    public void setValueAndDefault(Complex complex) {
        Complex complex2 = new Complex(complex);
        this.setValueObject(complex2);
        this.setDefaultValueObject(complex2);
    }

    public Complex getDefaultValue() {
        Complex complex = (Complex)this.getDefaultValueObject();
        if (complex == null) {
            return new Complex();
        }
        return complex;
    }

    public Complex getMaximumValueForInput() {
        return this.maximumValueForInput;
    }

    public void setMaximumValueForInput(Complex complex) {
        if (complex == null) {
            complex = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        this.maximumValueForInput = new Complex(complex);
    }

    public Complex getMinimumValueForInput() {
        return this.minimumValueForInput;
    }

    public void setMinimumValueForInput(Complex complex) {
        if (complex == null) {
            complex = new Complex(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        }
        this.minimumValueForInput = new Complex(complex);
    }

    protected Object stringToValueObject(String string) throws NumberFormatException {
        ComplexExpression complexExpression;
        try {
            complexExpression = Util.parseComplexConstantExpression(string);
        }
        catch (ParseError parseError) {
            try {
                return Util.externalStringToValue(string, Complex.class);
            }
            catch (Exception exception) {
                throw new NumberFormatException(I18n.tr("vmm.core.ComplexParam.badExpression", string, parseError.getMessage()));
            }
        }
        Complex complex = complexExpression.value();
        if (Double.isNaN(complex.re) || Double.isInfinite(complex.re) || Double.isNaN(complex.im) || Double.isInfinite(complex.im)) {
            throw new NumberFormatException(I18n.tr("vmm.core.ComplexParam.undefined", string));
        }
        return complex;
    }

    protected String valueObjectToString(Object object) {
        return Util.toExternalString(object);
    }
}

