/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

public class Complex {
    public static final Complex ZERO_C = new Complex(0.0, 0.0);
    public static final Complex ONE_C = new Complex(1.0, 0.0);
    public static final Complex I_C = new Complex(0.0, 1.0);
    public double re;
    public double im;

    public Complex() {
    }

    public Complex(double d) {
        this.re = d;
    }

    public Complex(double d, double d2) {
        this.re = d;
        this.im = d2;
    }

    public Complex(Complex complex) {
        if (complex != null) {
            this.re = complex.re;
            this.im = complex.im;
        }
    }

    public boolean equals(Object object) {
        try {
            Complex complex = (Complex)object;
            return complex.re == this.re && complex.im == this.im;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Complex conj() {
        return new Complex(this.re, -this.im);
    }

    public static Complex polar(double d, double d2) {
        return new Complex(d * Math.cos(d2), d * Math.sin(d2));
    }

    public Complex plus(Complex complex) {
        return new Complex(this.re + complex.re, this.im + complex.im);
    }

    public Complex minus(Complex complex) {
        return new Complex(this.re - complex.re, this.im - complex.im);
    }

    public Complex times(Complex complex) {
        return new Complex(this.re * complex.re - this.im * complex.im, this.re * complex.im + this.im * complex.re);
    }

    public Complex dividedBy(Complex complex) {
        double d = complex.re * complex.re + complex.im * complex.im;
        if (d == 0.0) {
            return new Complex(Double.NaN, Double.NaN);
        }
        return new Complex((this.re * complex.re + this.im * complex.im) / d, (this.im * complex.re - this.re * complex.im) / d);
    }

    public Complex times(double d) {
        return new Complex(this.re * d, this.im * d);
    }

    public Complex plus(double d) {
        return new Complex(this.re + d, this.im);
    }

    public Complex minus(double d) {
        return new Complex(this.re - d, this.im);
    }

    public Complex dividedBy(double d) {
        return new Complex(this.re / d, this.im / d);
    }

    public Complex realLinComb(double d, double d2, Complex complex) {
        return new Complex(d * this.re + d2 * complex.re, d * this.im + d2 * complex.im);
    }

    public Complex complexLinComb(Complex complex, Complex complex2, Complex complex3) {
        return new Complex(this.times(complex).plus(complex3.times(complex2)));
    }

    public double dot(Complex complex) {
        return this.re * complex.re + this.im * complex.im;
    }

    public double abs2() {
        return this.re * this.re + this.im * this.im;
    }

    public double r() {
        return Math.sqrt(this.re * this.re + this.im * this.im);
    }

    public double theta() {
        return Math.atan2(this.im, this.re);
    }

    public Complex exponential() {
        double d = Math.exp(this.re);
        return new Complex(d * Math.cos(this.im), d * Math.sin(this.im));
    }

    public Complex inverse() {
        double d = this.re * this.re + this.im * this.im;
        Complex complex = d == 0.0 ? new Complex(Double.NaN, Double.NaN) : new Complex(this.re / d, -this.im / d);
        return complex;
    }

    public Complex log() {
        double d = Math.sqrt(this.re * this.re + this.im * this.im);
        double d2 = Math.atan2(this.im, this.re);
        return new Complex(Math.log(d), d2);
    }

    public Complex logNearer(Complex complex) {
        Complex complex2 = new Complex(this.log());
        double d = (complex2.im - complex.im) / (Math.PI * 2);
        double d2 = Math.PI * 2 * Math.floor(d + 0.5);
        complex2.im -= d2;
        return complex2;
    }

    public double sinh(double d) {
        return (Math.exp(d) - Math.exp(-d)) / 2.0;
    }

    public double cosh(double d) {
        return (Math.exp(d) + Math.exp(-d)) / 2.0;
    }

    public Complex sine() {
        Complex complex = new Complex(0.0, 0.0);
        double d = this.re;
        double d2 = this.im;
        complex.re = Math.sin(d) * this.cosh(d2);
        complex.im = Math.cos(d) * this.sinh(d2);
        return complex;
    }

    public Complex power(double d) {
        double d2 = Math.sqrt(this.re * this.re + this.im * this.im);
        double d3 = Math.atan2(this.im, this.re);
        double d4 = Math.log(d2);
        double d5 = d3;
        double d6 = d * d4;
        double d7 = d * d5;
        double d8 = Math.exp(d6);
        return new Complex(d8 * Math.cos(d7), d8 * Math.sin(d7));
    }

    public Complex integerPower(int n) {
        double d;
        double d2;
        double d3;
        boolean bl = false;
        if (n < 0) {
            n = -n;
            bl = true;
        }
        if (n == 0) {
            d3 = 1.0;
            d2 = 0.0;
        } else if (n == 1) {
            d3 = this.re;
            d2 = this.im;
        } else if (n == 2) {
            d3 = this.re * this.re - this.im * this.im;
            d2 = 2.0 * this.re * this.im;
        } else if (n == 3) {
            double d4 = this.re * this.re - this.im * this.im;
            double d5 = 2.0 * this.re * this.im;
            d3 = this.re * d4 - this.im * d5;
            d2 = this.re * d5 + this.im * d4;
        } else if (n == 4) {
            double d6 = this.re * this.re - this.im * this.im;
            double d7 = 2.0 * this.re * this.im;
            d3 = d6 * d6 - d7 * d7;
            d2 = 2.0 * d6 * d7;
        } else if (n == 5) {
            double d8 = this.re * this.re - this.im * this.im;
            double d9 = 2.0 * this.re * this.im;
            double d10 = d8 * d8 - d9 * d9;
            double d11 = 2.0 * d8 * d9;
            d3 = this.re * d10 - this.im * d11;
            d2 = this.re * d11 + this.im * d10;
        } else if (n == 6) {
            double d12 = this.re * this.re - this.im * this.im;
            double d13 = 2.0 * this.re * this.im;
            double d14 = d12 * d12 - d13 * d13;
            double d15 = 2.0 * d12 * d13;
            d3 = d12 * d14 - d13 * d15;
            d2 = d12 * d15 + d13 * d14;
        } else if (n == 7) {
            double d16 = this.re * this.re - this.im * this.im;
            double d17 = 2.0 * this.re * this.im;
            d3 = d16 * d16 - d17 * d17;
            d2 = 2.0 * d16 * d17;
            double d18 = d16 * d3 - d17 * d2;
            double d19 = d16 * d2 + d17 * d3;
            d3 = d18 * this.re - d19 * this.im;
            d2 = d18 * this.im + d19 * this.re;
        } else if (n == 8) {
            double d20 = this.re * this.re - this.im * this.im;
            double d21 = 2.0 * this.re * this.im;
            double d22 = d20 * d20 - d21 * d21;
            double d23 = 2.0 * d20 * d21;
            d3 = d22 * d22 - d23 * d23;
            d2 = 2.0 * d22 * d23;
        } else if (n == 9) {
            double d24 = this.re * this.re - this.im * this.im;
            double d25 = 2.0 * this.re * this.im;
            double d26 = d24 * d24 - d25 * d25;
            double d27 = 2.0 * d24 * d25;
            d24 = d26 * d26 - d27 * d27;
            d25 = 2.0 * d26 * d27;
            d3 = this.re * d24 - this.im * d25;
            d2 = this.re * d25 + this.im * d24;
        } else if (n == 10) {
            double d28 = this.re * this.re - this.im * this.im;
            double d29 = 2.0 * this.re * this.im;
            double d30 = d28 * d28 - d29 * d29;
            double d31 = 2.0 * d28 * d29;
            d28 = this.re * d30 - this.im * d31;
            d29 = this.re * d31 + this.im * d30;
            d3 = d28 * d28 - d29 * d29;
            d2 = 2.0 * d28 * d29;
        } else {
            d = this.r();
            double d32 = this.theta();
            if (d32 < 0.0) {
                d32 += Math.PI * 2;
            }
            d = Math.pow(d, n);
            d3 = d * Math.cos(d32 *= (double)n);
            d2 = d * Math.sin(d32);
        }
        if (bl) {
            d = d3 * d3 + d2 * d2;
            if (d == 0.0) {
                d3 = Double.NaN;
                d2 = Double.NaN;
            } else {
                d3 /= d;
                d2 = -d2 / d;
            }
        }
        return new Complex(d3, d2);
    }

    public Complex integerRoot(int n) {
        double d;
        double d2;
        double d3;
        boolean bl = false;
        if (n < 0) {
            n = -n;
            bl = true;
        }
        if (n == 0) {
            d3 = 1.0;
            d2 = 0.0;
        } else if (n == 1) {
            d3 = this.re;
            d2 = this.im;
        } else {
            d = this.r();
            double d4 = this.theta();
            if (d4 < 0.0) {
                d4 += Math.PI * 2;
            }
            d = Math.pow(d, 1.0 / (double)n);
            d3 = d * Math.cos(d4 /= (double)n);
            d2 = d * Math.sin(d4);
        }
        if (bl) {
            d = d3 * d3 + d2 * d2;
            if (d == 0.0) {
                d3 = Double.NaN;
                d2 = Double.NaN;
            } else {
                d3 /= d;
                d2 = -d2 / d;
            }
        }
        return new Complex(d3, d2);
    }

    public Complex squareRootNearer(Complex complex) {
        Complex complex2 = this.integerRoot(2);
        if (complex2.re * complex.re + complex2.im * complex.im < 0.0) {
            complex2.re = -complex2.re;
            complex2.im = -complex2.im;
        }
        return new Complex(complex2.re, complex2.im);
    }

    public Complex mobius1_1(double d) {
        Complex complex = this.times(d);
        Complex complex2 = complex.plus(this);
        complex.re = complex.re + 1.0 + d;
        complex2.re += d;
        return complex2.dividedBy(complex);
    }

    public double[] stereographicProjection() {
        double[] dArray = new double[3];
        double d = this.re * this.re + this.im * this.im;
        double d2 = d + 1.0;
        dArray[0] = 2.0 * this.re / d2;
        dArray[1] = 2.0 * this.im / d2;
        dArray[2] = (d - 1.0) / d2;
        return dArray;
    }

    public void assign(double d, double d2) {
        this.re = d;
        this.im = d2;
    }

    public String toString() {
        if (Double.isNaN(this.re) || Double.isNaN(this.im) || Double.isInfinite(this.re) || Double.isInfinite(this.im)) {
            String string;
            String string2 = Double.isNaN(this.re) ? "NaN" : (this.re == Double.POSITIVE_INFINITY ? "+INF" : (string = this.re == Double.NEGATIVE_INFINITY ? "-INF" : "" + this.re));
            String string3 = Double.isNaN(this.im) ? "NaN" : (this.im == Double.POSITIVE_INFINITY ? "+INF" : (this.im == Double.NEGATIVE_INFINITY ? "-INF" : "" + this.im));
            return "(" + string + ") + i*(" + string3 + ")";
        }
        if (this.im == 0.0) {
            return "" + this.re;
        }
        if (this.im < 0.0) {
            if (this.re == 0.0) {
                return this.im == -1.0 ? "-i" : "-i*" + -this.im;
            }
            return this.re + (this.im == -1.0 ? " - i" : " - i*" + -this.im);
        }
        if (this.re == 0.0) {
            return this.im == 1.0 ? "i" : "i*" + this.im;
        }
        return this.re + (this.im == 1.0 ? " + i" : " + i*" + this.im);
    }

    public void assign(Complex complex) {
        this.re = complex.re;
        this.im = complex.im;
    }

    public double det(Complex complex) {
        return this.re * complex.im - this.im * complex.re;
    }

    public void assignTimes(double d) {
        this.re *= d;
        this.im *= d;
    }

    public void assignInvert() {
        double d = this.re * this.re + this.im * this.im;
        this.re /= d;
        this.im = -this.im / d;
    }

    public void assignPow(Complex complex, double d) {
        double d2 = Math.sqrt(complex.re * complex.re + complex.im * complex.im);
        double d3 = Math.atan2(complex.im, complex.re);
        double d4 = Math.log(d2);
        double d5 = d3;
        double d6 = d * d4;
        double d7 = d * d5;
        double d8 = Math.exp(d6);
        this.re = d8 * Math.cos(d7);
        this.im = d8 * Math.sin(d7);
    }

    public void assignPlus(Complex complex, Complex complex2) {
        this.re = complex.re + complex2.re;
        this.im = complex.im + complex2.im;
    }

    public void assignPlus(Complex complex) {
        this.re += complex.re;
        this.im += complex.im;
    }

    public void assignMinus(Complex complex) {
        this.re += -complex.re;
        this.im += -complex.im;
    }

    public void assignTimes(Complex complex, double d) {
        this.re = complex.re * d;
        this.im = complex.im * d;
    }

    public void assignTimes(Complex complex) {
        double d = this.re * complex.re - this.im * complex.im;
        this.im = this.re * complex.im + this.im * complex.re;
        this.re = d;
    }

    public void assignTimes(Complex complex, Complex complex2) {
        this.re = complex.re * complex2.re - complex.im * complex2.im;
        this.im = complex.re * complex2.im + complex.im * complex2.re;
    }

    public void assignDivide(Complex complex) {
        double d = complex.re * complex.re + complex.im * complex.im;
        double d2 = (this.re * complex.re + this.im * complex.im) / d;
        this.im = (this.im * complex.re - this.re * complex.im) / d;
        this.re = d2;
    }

    public void assignTimesTimes(Complex complex, double d) {
        this.assignTimes(complex);
        this.assignTimes(d);
    }

    public void assignPlusTimes(Complex complex, Complex complex2) {
        this.assignPlus(complex);
        this.assignTimes(complex2);
    }

    public void assignTimesPlus(Complex complex, Complex complex2) {
        this.assignTimes(complex);
        this.assignPlus(complex2);
    }

    public void assign_PlusTimes(Complex complex, Complex complex2) {
        this.re += complex.re * complex2.re - complex.im * complex2.im;
        this.im += complex.re * complex2.im + complex.im * complex2.re;
    }

    public void assign_PlusTimes(Complex complex, double d) {
        this.re += complex.re * d;
        this.im += complex.im * d;
    }

    public void assignTimes_PlusTimes(Complex complex, Complex complex2, double d) {
        this.assignTimes(complex);
        this.re += complex2.re * d;
        this.im += complex2.im * d;
    }

    public Complex invert() {
        return this.inverse();
    }
}

