/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import vmm.core.Display;
import vmm.core.MouseTask;
import vmm.core.Transform;
import vmm.core.View;

public class BasicMouseTask2D
extends MouseTask {
    private int operation;
    private static final int NONE = 0;
    private static final int DRAG = 1;
    private static final int ZOOM = 2;
    private static final int ZOOM_RECT = 3;
    private int startx;
    private int starty;
    private int prevx;
    private int prevy;
    private double[] startWindow;
    private double requestedAspectRatio;
    private Rectangle scaleRect;
    private long mouseDownTime;
    private boolean startedDragging;
    private boolean saveFastDrawing;

    public boolean doMouseDown(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
        this.operation = 0;
        if (view.getExhibit() == null) {
            return false;
        }
        this.startx = this.prevx = mouseEvent.getX();
        this.starty = this.prevy = mouseEvent.getY();
        this.startWindow = view.getWindow();
        Transform transform = view.getTransform();
        this.requestedAspectRatio = Math.abs((transform.getYmaxRequested() - transform.getYminRequested()) / (transform.getXmaxRequested() - transform.getXminRequested()));
        if (mouseEvent.isAltDown() || mouseEvent.isShiftDown()) {
            this.operation = 2;
        } else if (mouseEvent.isControlDown() || mouseEvent.isMetaDown()) {
            this.operation = 3;
            this.scaleRect = null;
        } else {
            this.operation = 1;
        }
        this.saveFastDrawing = view.getFastDrawing();
        this.mouseDownTime = mouseEvent.getWhen();
        this.startedDragging = false;
        return true;
    }

    public void doMouseDrag(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
        if (!this.startedDragging && mouseEvent.getWhen() - this.mouseDownTime < 300L && Math.abs(mouseEvent.getX() - this.startx) < 3 && Math.abs(mouseEvent.getY() - this.starty) < 3) {
            return;
        }
        if (!this.startedDragging) {
            this.startedDragging = true;
            if (this.operation != 3) {
                view.setFastDrawing(true);
            }
        }
        if (this.operation == 1 && !mouseEvent.isControlDown() && !mouseEvent.isMetaDown()) {
            if (mouseEvent.isAltDown() || mouseEvent.isShiftDown()) {
                this.operation = 2;
                this.startx = mouseEvent.getX();
                this.starty = mouseEvent.getY();
                this.startWindow = view.getWindow();
                return;
            }
        } else if (this.operation == 2 && !mouseEvent.isAltDown() && !mouseEvent.isShiftDown()) {
            this.operation = 1;
            this.startx = mouseEvent.getX();
            this.starty = mouseEvent.getY();
            this.startWindow = view.getWindow();
            return;
        }
        switch (this.operation) {
            case 1: {
                double d = Math.abs(this.startWindow[1] - this.startWindow[0]) / (double)n;
                double d2 = Math.abs(this.startWindow[3] - this.startWindow[2]) / (double)n2;
                double d3 = (double)(this.startx - mouseEvent.getX()) * d;
                double d4 = (double)(-(this.starty - mouseEvent.getY())) * d2;
                this.newWindow(view, this.startWindow[0] + d3, this.startWindow[1] + d3, this.startWindow[2] + d4, this.startWindow[3] + d4);
                display.repaint();
                break;
            }
            case 2: {
                double d = (double)(-(this.starty - mouseEvent.getY())) / 200.0;
                double d5 = Math.exp(d);
                double d6 = this.startWindow[0] + (double)this.startx * ((this.startWindow[1] - this.startWindow[0]) / (double)n);
                double d7 = this.startWindow[2] + (double)(n2 - this.starty) * ((this.startWindow[3] - this.startWindow[2]) / (double)n2);
                double d8 = (this.startWindow[1] - this.startWindow[0]) * d5;
                double d9 = (this.startWindow[3] - this.startWindow[2]) * d5;
                double d10 = d8 / (double)n;
                double d11 = d9 / (double)n2;
                double d12 = d6 - d10 * (double)this.startx;
                double d13 = d12 + d8;
                double d14 = d7 - d11 * (double)(n2 - this.starty);
                double d15 = d14 + d9;
                this.newWindow(view, d12, d13, d14, d15);
                display.repaint();
                break;
            }
            case 3: {
                if (mouseEvent.isShiftDown()) {
                    if (this.scaleRect != null) {
                        int n3 = mouseEvent.getX() - this.prevx;
                        int n4 = mouseEvent.getY() - this.prevy;
                        this.startx += n3;
                        this.starty += n4;
                        this.prevx = mouseEvent.getX();
                        this.prevy = mouseEvent.getY();
                        this.scaleRect.translate(n3, n4);
                    }
                } else {
                    this.prevx = mouseEvent.getX();
                    this.prevy = mouseEvent.getY();
                    if (this.prevx < 0) {
                        this.prevx = 0;
                    } else if (this.prevx >= n) {
                        this.prevx = n - 1;
                    }
                    if (this.prevy < 0) {
                        this.prevy = 0;
                    } else if (this.prevy >= n2) {
                        this.prevy = n2 - 1;
                    }
                    if (Math.abs(this.prevx - this.startx) < 3 || Math.abs(this.prevy - this.starty) < 3) {
                        this.scaleRect = null;
                    } else {
                        if (this.scaleRect == null) {
                            this.scaleRect = new Rectangle();
                        }
                        this.scaleRect.setBounds(this.startx, this.starty, 0, 0);
                        if (view.getPreserveAspect()) {
                            int n5;
                            double d = (double)n / (double)n2;
                            int n6 = Math.abs(this.prevx - this.startx);
                            double d16 = (double)n6 / (double)(n5 = Math.abs(this.prevy - this.starty));
                            if (d > d16) {
                                n6 = (int)((double)n6 * d / d16 + 0.499);
                            } else if (d < d16) {
                                n5 = (int)((double)n5 * d16 / d + 0.499);
                            }
                            this.scaleRect.add(this.prevx > this.startx ? this.startx + n6 : this.startx - n6, this.prevy > this.starty ? this.starty + n5 : this.starty - n5);
                        } else {
                            this.scaleRect.add(this.prevx, this.prevy);
                        }
                    }
                }
                display.repaint();
            }
        }
    }

    private void newWindow(View view, double d, double d2, double d3, double d4) {
        double d5 = Math.abs((d4 - d3) / (d2 - d));
        if (d5 > this.requestedAspectRatio) {
            double d6 = this.requestedAspectRatio / d5;
            double d7 = (d4 - d3) * d6;
            double d8 = (d4 + d3) / 2.0;
            d3 = d8 - d7 / 2.0;
            d4 = d8 + d7 / 2.0;
        } else {
            double d9 = d5 / this.requestedAspectRatio;
            double d10 = (d2 - d) * d9;
            double d11 = (d2 + d) / 2.0;
            d = d11 - d10 / 2.0;
            d2 = d11 + d10 / 2.0;
        }
        view.setWindow(d, d2, d3, d4);
    }

    public void doMouseUp(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
        if (!this.startedDragging) {
            return;
        }
        if (this.operation == 3 && this.scaleRect != null) {
            double d = (this.startWindow[1] - this.startWindow[0]) / (double)n;
            double d2 = (this.startWindow[3] - this.startWindow[2]) / (double)n2;
            double d3 = this.startWindow[0] + (double)this.scaleRect.x * d;
            double d4 = d3 + (double)this.scaleRect.width * d;
            double d5 = this.startWindow[3] - (double)this.scaleRect.y * d2;
            double d6 = d5 - (double)this.scaleRect.height * d2;
            this.newWindow(view, d3, d4, d6, d5);
            display.repaint();
        }
        view.setFastDrawing(this.saveFastDrawing);
    }

    public Cursor getCursorForDragging(MouseEvent mouseEvent, Display display, View view) {
        if (this.operation == 3) {
            return Cursor.getPredefinedCursor(1);
        }
        if (this.operation == 1) {
            return Cursor.getPredefinedCursor(13);
        }
        if (this.operation == 2) {
            return Cursor.getPredefinedCursor(9);
        }
        return null;
    }

    public void drawWhileDragging(Graphics2D graphics2D, Display display, View view, int n, int n2) {
        if (this.operation != 3 || this.scaleRect == null) {
            return;
        }
        if (Math.abs(this.startx - this.prevx) < 3 || Math.abs(this.starty - this.prevy) < 3) {
            return;
        }
        graphics2D.setColor(Color.WHITE);
        graphics2D.drawRect(this.scaleRect.x - 1, this.scaleRect.y - 1, this.scaleRect.width + 2, this.scaleRect.height + 2);
        graphics2D.drawRect(this.scaleRect.x + 1, this.scaleRect.y + 1, this.scaleRect.width - 2, this.scaleRect.height - 2);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(this.scaleRect.x, this.scaleRect.y, this.scaleRect.width, this.scaleRect.height);
    }
}

