/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.util.ArrayList;
import vmm.core.Animateable;
import vmm.core.Complex;
import vmm.core.ComplexParam;
import vmm.core.ComplexParamAnimateable;
import vmm.core.IntegerParam;
import vmm.core.Parameter;
import vmm.core.RealParam;
import vmm.core.RealParamAnimateable;
import vmm.core.TimerAnimation;

public class BasicAnimator
extends TimerAnimation {
    private ArrayList<Animateable> animatedItems = new ArrayList();
    private ArrayList<Object[]> customLimitAnimatedParameters = null;
    private ArrayList<Object[]> initialParameterValues;
    private boolean restoreParameterValues = true;

    public BasicAnimator() {
        this((Animateable[])null, 100, 50);
    }

    public BasicAnimator(int n) {
        this((Animateable[])null, n, 50);
    }

    public BasicAnimator(Animateable animateable) {
        this(new Animateable[]{animateable}, 100, 50);
    }

    public BasicAnimator(Animateable animateable, int n, int n2) {
        this(new Animateable[]{animateable}, n, n2);
    }

    public BasicAnimator(Animateable[] animateableArray, int n, int n2) {
        super(n, n2);
        if (animateableArray != null) {
            for (int i = 0; i < animateableArray.length; ++i) {
                this.animatedItems.add(animateableArray[i]);
            }
        }
    }

    public boolean getRestoreParameterValues() {
        return this.restoreParameterValues;
    }

    public void setRestoreParameterValues(boolean bl) {
        this.restoreParameterValues = bl;
    }

    public synchronized void addAnimatedItem(Animateable animateable) {
        if (animateable != null && !this.animatedItems.contains(animateable)) {
            this.animatedItems.add(animateable);
        }
    }

    public synchronized void addWithCustomValue(IntegerParam integerParam, int n) {
        if (integerParam == null) {
            return;
        }
        if (this.customLimitAnimatedParameters == null) {
            this.customLimitAnimatedParameters = new ArrayList();
        }
        this.customLimitAnimatedParameters.add(new Object[]{integerParam, n});
    }

    public synchronized void addWithCustomValue(RealParam realParam, double d) {
        if (realParam == null) {
            return;
        }
        if (this.customLimitAnimatedParameters == null) {
            this.customLimitAnimatedParameters = new ArrayList();
        }
        this.customLimitAnimatedParameters.add(new Object[]{realParam, d});
    }

    public synchronized void addWithCustomValue(ComplexParam complexParam, Complex complex) {
        if (complexParam == null) {
            return;
        }
        if (this.customLimitAnimatedParameters == null) {
            this.customLimitAnimatedParameters = new ArrayList();
        }
        if (complex == null) {
            complex = new Complex();
        }
        this.customLimitAnimatedParameters.add(new Object[]{complexParam, complex});
    }

    public synchronized void addWithCustomLimits(RealParamAnimateable realParamAnimateable, double d, double d2) {
        if (realParamAnimateable == null) {
            return;
        }
        if (this.customLimitAnimatedParameters == null) {
            this.customLimitAnimatedParameters = new ArrayList();
        }
        this.customLimitAnimatedParameters.add(new Object[]{realParamAnimateable, d, d2});
    }

    public synchronized void addWithCustomLimits(ComplexParamAnimateable complexParamAnimateable, Complex complex, Complex complex2) {
        if (complexParamAnimateable == null) {
            return;
        }
        if (complex == null) {
            complex = new Complex();
        }
        if (complex2 == null) {
            complex2 = new Complex();
        }
        if (this.customLimitAnimatedParameters == null) {
            this.customLimitAnimatedParameters = new ArrayList();
        }
        this.customLimitAnimatedParameters.add(new Object[]{complexParamAnimateable, complex, complex2});
    }

    public final synchronized void start() {
        if (this.isRunning()) {
            this.cancel();
        }
        this.initialParameterValues = null;
        if (this.restoreParameterValues) {
            Parameter parameter;
            this.initialParameterValues = new ArrayList();
            for (Animateable objectArray : this.animatedItems) {
                if (!(objectArray instanceof Parameter)) continue;
                parameter = (Parameter)((Object)objectArray);
                this.initialParameterValues.add(new Object[]{parameter, parameter.getValueObject()});
            }
            if (this.customLimitAnimatedParameters != null) {
                for (Object[] objectArray : this.customLimitAnimatedParameters) {
                    parameter = (Parameter)objectArray[0];
                    this.initialParameterValues.add(new Object[]{parameter, parameter.getValueObject()});
                }
            }
        }
        super.start();
    }

    public final synchronized void cancel() {
        if (this.initialParameterValues != null) {
            for (Object[] objectArray : this.initialParameterValues) {
                Parameter parameter = (Parameter)objectArray[0];
                parameter.setValueObject(objectArray[1]);
            }
            this.initialParameterValues = null;
        }
        super.cancel();
    }

    protected void drawFrame() {
        if (this.animatedItems.size() == 0 && this.customLimitAnimatedParameters == null) {
            this.cancel();
        }
        double d = (double)this.frameNumber / (double)this.getFrames();
        for (Animateable objectArray : this.animatedItems) {
            objectArray.setFractionComplete(d);
        }
        if (this.customLimitAnimatedParameters != null) {
            for (Object[] objectArray : this.customLimitAnimatedParameters) {
                double d2;
                double d3;
                Parameter parameter;
                if (objectArray.length == 2) {
                    if (objectArray[0] instanceof IntegerParam) {
                        ((IntegerParam)objectArray[0]).setValue((Integer)objectArray[1]);
                        continue;
                    }
                    if (objectArray[0] instanceof RealParam) {
                        ((RealParam)objectArray[0]).setValue((Double)objectArray[1]);
                        continue;
                    }
                    ((ComplexParam)objectArray[0]).setValue((Complex)objectArray[1]);
                    continue;
                }
                if (objectArray[0] instanceof RealParamAnimateable) {
                    parameter = (RealParamAnimateable)objectArray[0];
                    double d4 = (Double)objectArray[1];
                    d3 = (Double)objectArray[2];
                    d2 = d4 + d * (d3 - d4);
                    ((RealParam)parameter).setValue(d2);
                    continue;
                }
                parameter = (ComplexParamAnimateable)objectArray[0];
                Complex complex = (Complex)objectArray[1];
                Complex complex2 = (Complex)objectArray[2];
                d3 = complex.re + d * (complex2.re - complex.re);
                d2 = complex.im + d * (complex2.re - complex.re);
                ((ComplexParam)parameter).setValue(new Complex(d3, d2));
            }
        }
        if (this.display != null && this.display.getView() != null) {
            this.display.getView().forceRedraw();
        }
    }

    public String getStatusText(boolean bl) {
        return null;
    }
}

