/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.awt.Color;
import java.awt.Graphics2D;
import vmm.core.Decoration;
import vmm.core.Transform;
import vmm.core.VMMSave;
import vmm.core.View;

public class Axes2D
extends Decoration {
    @VMMSave
    private Color color = Color.gray;

    public Axes2D() {
        this.setLayer(-100);
    }

    public void setColor(Color color) {
        this.color = color == null ? Color.gray : color;
    }

    public Color getColor() {
        return this.color;
    }

    public void doDraw(Graphics2D graphics2D, View view, Transform transform) {
        Color color = graphics2D.getColor();
        graphics2D.setColor(this.color);
        if (this.between(0.0, transform.getYmin(), transform.getYmax())) {
            view.drawLine(transform.getXmin(), 0.0, transform.getXmax(), 0.0);
        }
        if (this.between(0.0, transform.getXmin(), transform.getYmax())) {
            view.drawLine(0.0, transform.getYmax(), 0.0, transform.getYmin());
        }
        graphics2D.setColor(color);
    }

    private boolean between(double d, double d2, double d3) {
        if (d <= d2 && d >= d3) {
            return true;
        }
        return d >= d2 && d <= d3;
    }
}

