/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import vmm.core.Animateable;
import vmm.core.BasicAnimator;
import vmm.core.Display;
import vmm.core.Exhibit;
import vmm.core.I18n;
import vmm.core.Parameter;
import vmm.core.ParameterInput;
import vmm.core.SettingsDialog;
import vmm.core.View;

public class AnimationLimitsDialog
extends SettingsDialog {
    private Parameter[] parameters;
    private ParameterInput[][] inputBoxes;

    public static boolean showDialog(Component component, String string, Parameter[] parameterArray) {
        boolean bl = false;
        if (parameterArray != null) {
            for (int i = 0; i < parameterArray.length; ++i) {
                if (!(parameterArray[i] instanceof Animateable)) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            JOptionPane.showMessageDialog(component, I18n.tr("vmm.core.AnimationLimitsDialog.noMorphing"));
            return false;
        }
        AnimationLimitsDialog animationLimitsDialog = new AnimationLimitsDialog(component, string, parameterArray);
        animationLimitsDialog.setVisible(true);
        return !animationLimitsDialog.canceled;
    }

    public AnimationLimitsDialog(Component component, String string, Parameter[] parameterArray) {
        super(component, string, true, false);
        Serializable serializable;
        if (component != null && component instanceof Display) {
            final Display display = (Display)component;
            serializable = new AbstractAction(I18n.tr("vmm.core.AnimatinonLimitsDialog.MorphButtonName")){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (!AnimationLimitsDialog.this.doOK()) {
                        return;
                    }
                    View view = display.getView();
                    if (view == null) {
                        return;
                    }
                    Exhibit exhibit = view.getExhibit();
                    if (exhibit == null) {
                        return;
                    }
                    BasicAnimator basicAnimator = exhibit.getMorphingAnimation(view, 2);
                    if (basicAnimator != null) {
                        AnimationLimitsDialog.this.canceled = false;
                        AnimationLimitsDialog.this.dispose();
                        display.installAnimation(basicAnimator);
                    }
                }
            };
            this.buttonBar.add((Component)new JButton((Action)((Object)serializable)), 2);
        }
        int n = 0;
        if (parameterArray != null) {
            for (int i = 0; i < parameterArray.length; ++i) {
                if (!(parameterArray[i] instanceof Animateable)) continue;
                ++n;
            }
        }
        if (n == parameterArray.length) {
            this.parameters = parameterArray;
        } else {
            this.parameters = new Parameter[n];
            int n2 = 0;
            for (int i = 0; i < parameterArray.length; ++i) {
                if (!(parameterArray[i] instanceof Animateable)) continue;
                this.parameters[n2++] = parameterArray[i];
            }
        }
        serializable = new JPanel();
        ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ((Container)serializable).setLayout(new GridLayout(1, 0, 5, 5));
        ((Container)serializable).add(new JLabel(I18n.tr("vmm.core.ParameterDialog.ParameterName"), 0));
        ((Container)serializable).add(new JLabel(I18n.tr("vmm.core.ParameterDialog.AnimationStartValue"), 0));
        ((Container)serializable).add(new JLabel(I18n.tr("vmm.core.ParameterDialog.AnimationEndValue"), 0));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.inputBoxes = new ParameterInput[this.parameters.length][2];
        jPanel.setLayout(new GridLayout(0, 3, 5, 5));
        for (int i = 0; i < this.parameters.length; ++i) {
            JLabel jLabel = new JLabel(this.parameters[i].getTitle(), 0);
            String string2 = this.parameters[i].getHint();
            if (string2 != null) {
                jLabel.setToolTipText(string2);
            }
            jPanel.add(jLabel);
            this.inputBoxes[i][0] = this.parameters[i].createParameterInput(1);
            jPanel.add(this.inputBoxes[i][0]);
            this.inputBoxes[i][0].setMargin(new Insets(3, 3, 3, 3));
            this.inputBoxes[i][1] = this.parameters[i].createParameterInput(2);
            jPanel.add(this.inputBoxes[i][1]);
            this.inputBoxes[i][1].setMargin(new Insets(3, 3, 3, 3));
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)serializable, "North");
        this.addInputPanel(jPanel2);
        this.setResizable(false);
    }

    protected boolean doOK() {
        int n;
        for (n = 0; n < this.parameters.length; ++n) {
            String string = this.inputBoxes[n][0].checkContents();
            if (string != null) {
                this.errorMessage(string);
                return false;
            }
            string = this.inputBoxes[n][1].checkContents();
            if (string == null) continue;
            this.errorMessage(string);
            return false;
        }
        for (n = 0; n < this.parameters.length; ++n) {
            this.inputBoxes[n][0].setValueFromContents();
            this.inputBoxes[n][1].setValueFromContents();
        }
        return true;
    }

    private void errorMessage(String string) {
        JOptionPane.showMessageDialog(this, string, I18n.tr("vmm.core.ParameterDialog.errorTitle"), 0);
    }

    protected void doDefaults() {
        for (int i = 0; i < this.parameters.length; ++i) {
            this.inputBoxes[i][0].defaultVal();
            this.inputBoxes[i][1].defaultVal();
        }
    }
}

