/*
 * Decompiled with CFR 0.152.
 */
package vmm.conformalmap;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import vmm.conformalmap.ConformalMap;
import vmm.core.Complex;
import vmm.core.ComplexODE;
import vmm.core.ComplexParamAnimateable;
import vmm.core3D.Transform3D;
import vmm.core3D.View3D;

public class Weierstrass_p
extends ConformalMap {
    private ComplexParamAnimateable branch = new ComplexParamAnimateable("vmm.conformalmap.Weierstrass_p.branchPoint", "0.8 + 0.6*i", "0.8", "0.8 + i");
    private final Complex zero = new Complex(Complex.ZERO_C);
    private final Complex one = new Complex(Complex.ONE_C);
    private final Complex iC = new Complex(Complex.I_C);
    private ComplexODE myODE = new ComplexODE(this.zero, this.one.times(2.0), this.zero, this.one.times(-2.0), this.zero);
    private Complex branchP = this.branch.getValue();
    private Complex approxInitDeriv = new Complex(this.one.plus(this.iC));
    private Complex period1 = new Complex(1.0, 0.0);
    private Complex period2 = new Complex(0.0, 1.0);
    private Complex periodAverage = new Complex(0.5, 0.5);
    private boolean needsInvers = false;
    private double detPeriod = 1.0;
    private Complex localArg = new Complex(1.0, 0.0);
    private Complex localVal = new Complex(1.0, 0.0);
    private Complex[][] argumentGridPart2;
    private Complex[][] ValueGridPart2;

    public Weierstrass_p() {
        this.addParameter(this.branch);
        this.umin.reset(-1.0);
        this.umax.reset(1.0);
        this.vmin.reset(0.0);
        this.vmax.reset(0.5);
        this.removeParameter(this.umin);
        this.removeParameter(this.umax);
        this.removeParameter(this.vmin);
        this.removeParameter(this.vmax);
        this.vres.setValueAndDefault(8);
        this.ures.setValueAndDefault(4 * this.vres.getDefaultValue());
        this.setDefaultWindow2D(-5.0, 5.0, -4.0, 4.0);
        this.gridTypeSelect.setEnabled(false);
        this.setFramesForMorphing(20);
        this.setUseFilmstripForMorphing(true);
    }

    protected void computeDrawData3D(View3D view3D, boolean bl, Transform3D transform3D, Transform3D transform3D2) {
        if (bl) {
            int n;
            int n2;
            this.branchP = this.branch.getValue();
            this.myODE.setPoly(this.zero, this.one, this.branchP.minus(this.branchP.inverse()), this.one.times(-1.0), this.zero);
            this.period1 = this.ComputeFirstPeriod();
            this.period2 = this.ComputeSecondPeriod();
            this.periodAverage = this.period1.plus(this.period2).times(0.5);
            this.detPeriod = this.period1.det(this.period2);
            Complex[] complexArray = new Complex[2];
            Complex complex = new Complex(this.one.plus(this.iC));
            int n3 = this.ures.getValue() * 4;
            int n4 = this.vres.getValue() * 4;
            this.valueGrid = new Complex[n3 + 1][n4 + 1];
            this.argumentGrid = new Complex[n3 + 1][n4 + 1];
            double d = this.umin.getValue();
            double d2 = this.vmin.getValue();
            double d3 = this.umax.getValue();
            double d4 = this.vmax.getValue();
            double d5 = (d3 - d) / (double)n3;
            double d6 = (d4 - d2) / (double)n4;
            for (n2 = 0; n2 <= n3; ++n2) {
                for (n = 0; n <= n4; ++n) {
                    this.argumentGrid[n2][n] = this.gridMap(d + (double)n2 * d5, d2 + (double)n * d6);
                }
            }
            for (n2 = 0; n2 <= n3; ++n2) {
                complexArray = n2 == 0 ? this.myODE.ODEstep4(this.periodAverage, this.argumentGrid[0][0], this.iC, this.one.plus(this.iC), 24) : this.myODE.ODEstep4(this.argumentGrid[n2 - 1][0], this.argumentGrid[n2][0], this.valueGrid[n2 - 1][0], complex, 16);
                this.valueGrid[n2][0] = complexArray[0];
                complex = complexArray[1];
                for (n = 1; n <= n4; ++n) {
                    complexArray = this.myODE.ODEstep4(this.argumentGrid[n2][n - 1], this.argumentGrid[n2][n], complexArray[0], complexArray[1], 16);
                    this.valueGrid[n2][n] = complexArray[0];
                }
            }
            this.argumentGridPart2 = new Complex[n3 + 1][n4 + 1];
            this.ValueGridPart2 = new Complex[n3 + 1][n4 + 1];
            for (n2 = 0; n2 <= n3; ++n2) {
                for (n = 0; n <= n4; ++n) {
                    this.argumentGridPart2[n2][n] = this.argumentGrid[n2][n];
                    this.argumentGrid[n2][n] = this.argumentGrid[n2][n].times(-1.0).plus(this.period2);
                    this.ValueGridPart2[n2][n] = this.valueGrid[n2][n];
                    this.valueGrid[n2][n] = this.valueGrid[n2][n].inverse().times(-1.0);
                }
            }
        }
    }

    protected void doDraw3D(Graphics2D graphics2D, View3D view3D, Transform3D transform3D) {
        boolean bl = ((ConformalMap.ConformalMapView)view3D).getUseColor();
        ((ConformalMap.ConformalMapView)view3D).setUseColor(false);
        super.doDraw3D(graphics2D, view3D, transform3D);
        if (!((ConformalMap.ConformalMapView)view3D).getDrawValueGrid()) {
            int n = 7;
            for (int i = -n; i <= n; i += 2) {
                graphics2D.draw(new Line2D.Double((double)(-n) * this.period1.re - (double)i * this.period2.re, (double)(-n) * this.period1.im - (double)i * this.period2.im, (double)n * this.period1.re - (double)i * this.period2.re, (double)n * this.period1.im - (double)i * this.period2.im));
                graphics2D.draw(new Line2D.Double((double)i * this.period1.re - (double)n * this.period2.re, (double)i * this.period1.im - (double)n * this.period2.im, (double)i * this.period1.re + (double)n * this.period2.re, (double)i * this.period1.im + (double)n * this.period2.im));
            }
        }
        Complex[][] complexArray = this.argumentGrid;
        this.argumentGrid = this.argumentGridPart2;
        this.argumentGridPart2 = complexArray;
        complexArray = this.valueGrid;
        this.valueGrid = this.ValueGridPart2;
        this.ValueGridPart2 = complexArray;
        ((ConformalMap.ConformalMapView)view3D).setUseColor(bl);
        super.doDraw3D(graphics2D, view3D, transform3D);
        complexArray = this.argumentGrid;
        this.argumentGrid = this.argumentGridPart2;
        this.argumentGridPart2 = complexArray;
        complexArray = this.valueGrid;
        this.valueGrid = this.ValueGridPart2;
        this.ValueGridPart2 = complexArray;
    }

    private Complex ComputeFirstPeriod() {
        Complex[] complexArray = new Complex[2];
        Complex complex = this.branchP.inverse();
        complex.assignTimes(-0.5);
        complexArray = this.myODE.ComplexMultiStepIntegrator(this.iC, complex, this.zero, this.approxInitDeriv, 32.0);
        complexArray = this.myODE.ComplexMultiStepIntegrator(complex, this.iC.times(-1.0), complexArray[1], complexArray[0], 32.0);
        complexArray[1].assignTimes(-1.0);
        return complexArray[1];
    }

    private Complex ComputeSecondPeriod() {
        Complex[] complexArray = new Complex[2];
        complexArray = this.myODE.ComplexMultiStepIntegrator(this.iC, this.branchP.times(0.5), this.zero, this.approxInitDeriv, 32.0);
        complexArray = this.myODE.ComplexMultiStepIntegrator(this.branchP.times(0.5), this.iC.times(-1.0), complexArray[1], complexArray[0], 32.0);
        complexArray[1].assignTimes(-1.0);
        return complexArray[1];
    }

    protected Complex gridMap(double d, double d2) {
        return new Complex(d * this.period1.re + d2 * this.period2.re, d * this.period1.im + d2 * this.period2.im);
    }

    private Complex reduceModPeriods(Complex complex) {
        double d = complex.det(this.period2) / this.detPeriod;
        double d2 = this.period1.det(complex) / this.detPeriod;
        if (d > 1.0) {
            d -= 2.0 * Math.floor((1.0 + d) / 2.0);
        } else if (d < -1.0) {
            d -= 2.0 * Math.floor((1.0 + d) / 2.0);
        }
        if (d2 > 1.0) {
            d2 -= 2.0 * Math.floor((1.0 + d2) / 2.0);
        } else if (d2 < -1.0) {
            d2 -= 2.0 * Math.floor((1.0 + d2) / 2.0);
        }
        Complex complex2 = new Complex(d * this.period1.re + d2 * this.period2.re, d * this.period1.im + d2 * this.period2.im);
        if (d2 > 0.5) {
            this.needsInvers = true;
            complex2.re = -complex2.re + this.period1.re + this.period2.re;
            complex2.im = -complex2.im + this.period1.im + this.period2.im;
        } else if (d2 < -0.5) {
            this.needsInvers = true;
            complex2.re = -complex2.re + this.period1.re - this.period2.re;
            complex2.im = -complex2.im + this.period1.im - this.period2.im;
        }
        return complex2;
    }

    protected Complex function(Complex complex) {
        this.needsInvers = false;
        this.localArg = this.reduceModPeriods(complex);
        this.localVal = this.myODE.ODEstep4(this.periodAverage, this.localArg, this.iC, this.one.plus(this.iC), 16)[0];
        if (this.needsInvers) {
            this.localVal.assignInvert();
            this.localVal.assignTimes(-1.0);
        }
        return this.localVal;
    }
}

