/*
 * Decompiled with CFR 0.152.
 */
package vmm.conformalmap;

import java.awt.FlowLayout;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import vmm.conformalmap.ConformalMap;
import vmm.core.Complex;
import vmm.core.ComplexVariableParamAnimateable;
import vmm.core.Display;
import vmm.core.I18n;
import vmm.core.UserExhibit;
import vmm.core.View;
import vmm.core3D.UserExhibit3D;

public class UserConformalMap
extends ConformalMap
implements UserExhibit3D {
    private UserExhibit3D.Support userExhibitSupport;
    private UserExhibit.FunctionInfo func;

    public UserConformalMap() {
        this.umin.reset(-2.0);
        this.umax.reset("-0.0001");
        this.vmin.reset("0.0001");
        this.vmax.reset("2 * pi");
        this.ures.reset(7);
        this.vres.reset(20);
        this.setDefaultWindow2D(-1.5, 1.5, -1.5, 1.5);
        this.userExhibitSupport = new UserExhibit3D.Support(this){
            GridTypeInput gridTypeInput;
            {
                this.gridTypeInput = new GridTypeInput();
            }

            protected void finish(UserExhibit.Support.Dialog dialog, View view, boolean bl) {
                double[] dArray = dialog.getWindow();
                UserConformalMap.this.setDefaultWindow2D(dArray);
                if (view instanceof ConformalMap.ConformalMapView) {
                    ((ConformalMap.ConformalMapView)view).setWindowForUseWhileThreeDDisabled(dArray[0], dArray[1], dArray[2], dArray[3]);
                }
                if (this.gridTypeInput.cartesianButton.isSelected()) {
                    UserConformalMap.this.resetGridType(0);
                } else if (this.gridTypeInput.polarButton.isSelected()) {
                    UserConformalMap.this.resetGridType(1);
                } else {
                    UserConformalMap.this.resetGridType(2);
                }
            }

            protected UserExhibit.Support.Dialog createDialog(Display display, View view, boolean bl) {
                UserExhibit.Support.Dialog dialog = super.createDialog(display, view, bl);
                if (!bl) {
                    if (UserConformalMap.this.getGridType() == 0) {
                        this.gridTypeInput.cartesianButton.setSelected(true);
                    } else if (UserConformalMap.this.getGridType() == 1) {
                        this.gridTypeInput.polarButton.setSelected(true);
                    } else {
                        this.gridTypeInput.polarconformalButton.setSelected(true);
                    }
                }
                dialog.addExtraPanel(this.gridTypeInput);
                return dialog;
            }

            class GridTypeInput
            extends UserExhibit.Support.ExtraPanel {
                JRadioButton cartesianButton;
                JRadioButton polarButton;
                JRadioButton polarconformalButton;

                GridTypeInput() {
                    super(I18n.tr("vmm.conformalmap.ConformalMap.gridChoice"));
                    this.setLayout(new FlowLayout(1));
                    ButtonGroup buttonGroup = new ButtonGroup();
                    this.cartesianButton = new JRadioButton(I18n.tr("vmm.conformalmap.ConformalMap.cartesian"), true);
                    buttonGroup.add(this.cartesianButton);
                    this.add(this.cartesianButton);
                    this.polarButton = new JRadioButton(I18n.tr("vmm.conformalmap.ConformalMap.polar"), true);
                    buttonGroup.add(this.polarButton);
                    this.add(this.polarButton);
                    this.polarconformalButton = new JRadioButton(I18n.tr("vmm.conformalmap.ConformalMap.polarconformal"), true);
                    buttonGroup.add(this.polarconformalButton);
                    this.add(this.polarconformalButton);
                }

                public void checkData() throws IllegalArgumentException {
                }
            }
        };
        this.userExhibitSupport.addFunctionParameter(new ComplexVariableParamAnimateable("a", new Complex(0.66667)));
        this.userExhibitSupport.addFunctionParameter(new ComplexVariableParamAnimateable("c", new Complex(), new Complex(), new Complex(0.5)));
        this.func = this.userExhibitSupport.addComplexFunction("f", "((i*tan(i*z/2)+c)/(1+conj(c)*i*tan(i*z/2)))^a", "z");
        this.userExhibitSupport.setShowViewpoint(false);
    }

    protected Complex function(Complex complex) {
        return this.func.complexFunctionValue(complex);
    }

    public UserExhibit.Support getUserExhibitSupport() {
        return this.userExhibitSupport;
    }
}

