/*
 * Decompiled with CFR 0.152.
 */
package vmm.conformalmap;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.conformalmap.ConformalMap;
import vmm.core.BasicAnimator;
import vmm.core.Complex;
import vmm.core.ComplexParamAnimateable;
import vmm.core.I18n;
import vmm.core.View;
import vmm.core3D.Transform3D;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;

public class HyperbolicIsometry
extends ConformalMap {
    private ComplexParamAnimateable c = new ComplexParamAnimateable("c", "0.5", "-0.9", "0.9");
    private boolean in2ndMorph = false;
    private Vector3D[] equator;
    private Point2D[] unitCircle;

    public HyperbolicIsometry() {
        this.addParameter(this.c);
        this.setGridType(1);
        this.umin.reset(0.0);
        this.umax.reset(0.7);
        this.vmin.reset(0.0);
        this.vmax.reset("2 pi");
        this.ures.reset(6);
        this.vres.reset(36);
        this.setDefaultWindow2D(-1.0, 1.0, -1.0, 1.0);
        this.equator = new Vector3D[121];
        this.unitCircle = new Point2D[121];
        for (int i = 0; i <= 120; ++i) {
            double d = (double)(i * 3) / 180.0 * Math.PI;
            this.equator[i] = new Vector3D(Math.cos(d), Math.sin(d), 0.0);
            this.unitCircle[i] = new Point2D.Double(Math.cos(d), Math.sin(d));
        }
    }

    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actionList = super.getAdditionalAnimationsForView(view);
        actionList.add(new AbstractActionVMM(I18n.tr("vmm.conformalmap.HyperbolicIsometry.Rotation")){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicAnimator basicAnimator = new BasicAnimator();
                basicAnimator.setLooping(1);
                basicAnimator.setUseFilmstrip(HyperbolicIsometry.this.getUseFilmstripForMorphing());
                basicAnimator.setFrames(HyperbolicIsometry.this.getFramesForMorphing());
                basicAnimator.setMillisecondsPerFrame(200);
                basicAnimator.addWithCustomValue(HyperbolicIsometry.this.ures, 6);
                basicAnimator.addWithCustomValue(HyperbolicIsometry.this.vres, 12);
                basicAnimator.addWithCustomValue(HyperbolicIsometry.this.umin, 0.0);
                basicAnimator.addWithCustomValue(HyperbolicIsometry.this.umax, 0.7);
                basicAnimator.addWithCustomLimits(HyperbolicIsometry.this.vmin, 0.0, Math.PI * 2);
                basicAnimator.addWithCustomLimits(HyperbolicIsometry.this.vmax, 1.5707963267948966, 7.853981633974483);
                basicAnimator.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        if (((BasicAnimator)changeEvent.getSource()).isRunning()) {
                            HyperbolicIsometry.this.in2ndMorph = true;
                        } else {
                            HyperbolicIsometry.this.in2ndMorph = false;
                        }
                    }
                });
                view.getDisplay().installAnimation(basicAnimator);
            }
        });
        return actionList;
    }

    protected Complex function(Complex complex) {
        Complex complex2 = this.c.getValue();
        return complex.plus(complex2).dividedBy(complex.times(complex2.conj()).plus(1.0));
    }

    protected void doDraw3D(Graphics2D graphics2D, View3D view3D, Transform3D transform3D) {
        super.doDraw3D(graphics2D, view3D, transform3D);
        view3D.setColor(null);
        if (view3D.getEnableThreeD()) {
            view3D.drawCurve(this.equator);
        } else {
            view3D.drawCurve(this.unitCircle);
        }
    }
}

