/*
 * Decompiled with CFR 0.152.
 */
package vmm.conformalmap;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import vmm.conformalmap.ConformalMap;
import vmm.core.Complex;
import vmm.core.Decoration;
import vmm.core.Transform;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;

@VMMSave
public class ConformalMapFigure
extends Decoration {
    public static final int LINE_SEGMENT = 0;
    public static final int LINE = 1;
    public static final int CIRCLE = 2;
    public static final int DEFAULT_POINTS_ON_CIRCLE = 256;
    public static final int DEFAULT_POINTS_ON_SEGMENT = 250;
    public static final int DEFAULT_POINTS_ON_LINE = 500;
    @VMMSave
    private int shape = 0;
    @VMMSave
    private Color color;
    private Complex[] arguments;
    private Complex[] values;
    @VMMSave
    private Point2D p1;
    @VMMSave
    private Point2D p2;
    @VMMSave
    private int pointCount;

    public ConformalMapFigure() {
    }

    public ConformalMapFigure(Point2D point2D, Point2D point2D2, int n) {
        this(point2D, point2D2, n, 0);
    }

    public ConformalMapFigure(Point2D point2D, Point2D point2D2, int n, int n2) {
        this.setShape(n);
        this.setPointCount(n2);
        this.p1 = point2D;
        this.p2 = point2D2;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.fireDecorationChangeEvent();
    }

    public Point2D getP1() {
        return this.p1;
    }

    public void setP1(Point2D point2D) {
        this.p1 = point2D;
        this.fireDecorationChangeEvent();
    }

    public Point2D getP2() {
        return this.p2;
    }

    public void setP2(Point2D point2D) {
        this.p2 = point2D;
        this.fireDecorationChangeEvent();
    }

    public int getShape() {
        return this.shape;
    }

    public void setShape(int n) {
        if (n != 0 && n != 1 && n != 2) {
            return;
        }
        this.shape = n;
        this.fireDecorationChangeEvent();
    }

    public int getPointCount() {
        return this.pointCount;
    }

    public void setPointCount(int n) {
        if (n < 2) {
            switch (this.shape) {
                case 2: {
                    n = 256;
                    break;
                }
                case 1: {
                    n = 500;
                    break;
                }
                default: {
                    n = 250;
                }
            }
        }
        this.pointCount = n;
    }

    public void computeDrawData(View view, boolean bl, Transform transform, Transform transform2) {
        if (this.p1 == null || this.p2 == null) {
            return;
        }
        ConformalMap conformalMap = (ConformalMap)view.getExhibit();
        if (this.values == null || bl) {
            switch (this.shape) {
                case 0: {
                    this.arguments = new Complex[2];
                    this.arguments[0] = new Complex(this.p1.getX(), this.p1.getY());
                    this.arguments[1] = new Complex(this.p2.getX(), this.p2.getY());
                    if (this.values == null) {
                        this.values = new Complex[this.pointCount];
                    }
                    Complex complex = this.arguments[1].minus(this.arguments[0]).dividedBy(this.pointCount - 1);
                    for (int i = 0; i < this.pointCount; ++i) {
                        Complex complex2 = this.arguments[0].plus(complex.times(i));
                        this.values[i] = conformalMap.composedFunction(complex2);
                    }
                    break;
                }
                case 1: {
                    double d = transform2.getXmin();
                    double d2 = transform2.getXmax();
                    double d3 = transform2.getYmin();
                    double d4 = transform2.getYmax();
                    double d5 = Math.abs(d2 - d) + Math.abs(d4 - d3);
                    double d6 = this.p2.getX() - this.p1.getX();
                    double d7 = this.p2.getY() - this.p1.getY();
                    double d8 = Math.sqrt(d6 * d6 + d7 * d7);
                    this.arguments = new Complex[2];
                    this.arguments[0] = new Complex(this.p1.getX() - 2.0 * d5 * (d6 /= d8), this.p1.getY() - 2.0 * d5 * (d7 /= d8));
                    this.arguments[1] = new Complex(this.p2.getX() + 2.0 * d5 * d6, this.p2.getY() + 2.0 * d5 * d7);
                    if (this.values == null) {
                        this.values = new Complex[this.pointCount];
                    }
                    Complex complex = this.arguments[1].minus(this.arguments[0]).dividedBy(this.pointCount - 1);
                    for (int i = 0; i < this.values.length; ++i) {
                        Complex complex3 = this.arguments[0].plus(complex.times(i));
                        this.values[i] = conformalMap.composedFunction(complex3);
                    }
                    break;
                }
                case 2: {
                    int n;
                    double d = Math.sqrt((this.p1.getX() - this.p2.getX()) * (this.p1.getX() - this.p2.getX()) + (this.p1.getY() - this.p2.getY()) * (this.p1.getY() - this.p2.getY()));
                    this.arguments = new Complex[this.pointCount];
                    double d9 = Math.PI * 2 / (double)this.pointCount;
                    for (n = 0; n < this.pointCount; ++n) {
                        this.arguments[n] = new Complex(this.p1.getX() + d * Math.cos((double)n * d9), this.p1.getY() + d * Math.sin((double)n * d9));
                    }
                    if (this.values == null) {
                        this.values = new Complex[this.pointCount];
                    }
                    for (n = 0; n <= this.pointCount - 1; ++n) {
                        this.values[n] = conformalMap.composedFunction(this.arguments[n]);
                    }
                    break;
                }
            }
        }
    }

    private void whereToDraw(ConformalMap.ConformalMapView conformalMapView, Complex complex, Complex complex2) {
        if (conformalMapView.getUse3D()) {
            Vector3D vector3D;
            Vector3D vector3D2;
            if (complex.abs2() > 100000.0) {
                vector3D2 = new Vector3D(0.0, 0.0, 1.0);
            } else {
                double[] dArray = complex.stereographicProjection();
                vector3D2 = new Vector3D(dArray[0], dArray[1], dArray[2]);
            }
            if (complex2.abs2() > 100000.0) {
                vector3D = new Vector3D(0.0, 0.0, 1.0);
            } else {
                double[] dArray = complex2.stereographicProjection();
                vector3D = new Vector3D(dArray[0], dArray[1], dArray[2]);
            }
            conformalMapView.drawLine(vector3D2, vector3D);
        } else if (complex.abs2() + complex2.abs2() < 1000000.0) {
            conformalMapView.drawLine(complex.re, complex.im, complex2.re, complex2.im);
        }
    }

    public void doDraw(Graphics2D graphics2D, View view, Transform transform) {
        if (this.p1 == null || this.p2 == null) {
            return;
        }
        ConformalMap.ConformalMapView conformalMapView = (ConformalMap.ConformalMapView)view;
        Color color = graphics2D.getColor();
        Color color2 = this.color;
        if (color2 == null) {
            color2 = view.getForeground();
        }
        graphics2D.setColor(((View3D)view).getViewStyle() == 1 ? Color.WHITE : this.color);
        switch (this.shape) {
            case 0: {
                if (conformalMapView.getDrawValueGrid()) {
                    for (int i = 0; i < this.pointCount - 1; ++i) {
                        this.whereToDraw(conformalMapView, this.values[i], this.values[i + 1]);
                    }
                    break;
                }
                view.drawLine(this.arguments[0].re, this.arguments[0].im, this.arguments[1].re, this.arguments[1].im);
                break;
            }
            case 1: {
                if (conformalMapView.getDrawValueGrid()) {
                    for (int i = 0; i < this.values.length - 1; ++i) {
                        this.whereToDraw(conformalMapView, this.values[i], this.values[i + 1]);
                    }
                    break;
                }
                view.drawLine(this.arguments[0].re, this.arguments[0].im, this.arguments[1].re, this.arguments[1].im);
                break;
            }
            case 2: {
                if (conformalMapView.getDrawValueGrid()) {
                    for (int i = 0; i < this.pointCount - 1; ++i) {
                        this.whereToDraw(conformalMapView, this.values[i], this.values[i + 1]);
                    }
                    this.whereToDraw(conformalMapView, this.values[this.pointCount - 1], this.values[0]);
                    break;
                }
                for (int i = 0; i < this.pointCount - 1; ++i) {
                    view.drawLine(this.arguments[i].re, this.arguments[i].im, this.arguments[i + 1].re, this.arguments[i + 1].im);
                }
                view.drawLine(this.arguments[this.pointCount - 1].re, this.arguments[this.pointCount - 1].im, this.arguments[0].re, this.arguments[0].im);
            }
        }
        graphics2D.setColor(color);
    }
}

