/*
 * Decompiled with CFR 0.152.
 */
package vmm.conformalmap;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.actions.ActionRadioGroup;
import vmm.actions.ToggleAction;
import vmm.conformalmap.ConformalMapFigure;
import vmm.core.Animation;
import vmm.core.BasicMouseTask2D;
import vmm.core.Complex;
import vmm.core.Decoration;
import vmm.core.Display;
import vmm.core.Exhibit;
import vmm.core.I18n;
import vmm.core.IntegerParam;
import vmm.core.MouseTask;
import vmm.core.RealParamAnimateable;
import vmm.core.SaveAndRestore;
import vmm.core.ThreadedAnimation;
import vmm.core.TwoPointInput;
import vmm.core.Util;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.core3D.BasicMouseTask3D;
import vmm.core3D.Exhibit3D;
import vmm.core3D.Transform3D;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;

public abstract class ConformalMap
extends Exhibit3D {
    public static final int IDENTITY = 0;
    public static final int INVERSION = 1;
    public static final int FRACTIONAL = 2;
    public static final int SQRROOT = 3;
    public static final int CARTESIAN = 0;
    public static final int POLAR = 1;
    public static final int POLARCONFORMAL = 2;
    private double[][] gridData = new double[][]{{-1.0, 1.0, -1.0, 1.0, 20.0, 20.0}, {0.0, 1.0, 0.0, Math.PI * 2, 7.0, 42.0}, {-0.5, 0.5, 0.0, Math.PI * 2, 7.0, 42.0}};
    protected RealParamAnimateable umin = new RealParamAnimateable("vmm.conformalmap.ConformalMap.umin", -1.0);
    protected RealParamAnimateable umax = new RealParamAnimateable("vmm.conformalmap.ConformalMap.umax", 1.0);
    protected RealParamAnimateable vmin = new RealParamAnimateable("vmm.conformalmap.ConformalMap.vmin", -1.0);
    protected RealParamAnimateable vmax = new RealParamAnimateable("vmm.conformalmap.ConformalMap.vmax", 1.0);
    protected IntegerParam ures = new IntegerParam("vmm.conformalmap.ConformalMap.ures", 20);
    protected IntegerParam vres = new IntegerParam("vmm.conformalmap.ConformalMap.vres", 20);
    protected static final int POINTS_PER_INTERVAL = 4;
    protected int pointsOnCircleFigure = 256;
    protected int pointsOnLineFigure = 500;
    protected int pointsOnLineSegmentFigure = 250;
    protected Complex[][] argumentGrid;
    protected Complex[][] valueGrid;
    @VMMSave
    private int preCompFunction = 0;
    @VMMSave
    private int postCompFunction = 0;
    @VMMSave
    private int gridType = 0;
    private ActionRadioGroup preCompSelect;
    private ActionRadioGroup postCompSelect;
    protected ActionRadioGroup gridTypeSelect;
    private double[] defaultWindow2D = new double[]{-3.0, 3.0, -3.0, 3.0};

    protected abstract Complex function(Complex var1);

    public ConformalMap() {
        this.setDefaultBackground(Color.BLACK);
        this.addParameter(this.vres);
        this.addParameter(this.ures);
        this.addParameter(this.vmax);
        this.addParameter(this.vmin);
        this.addParameter(this.umax);
        this.addParameter(this.umin);
        this.vres.setMinimumValueForInput(1);
        this.ures.setMinimumValueForInput(1);
        this.setDefaultWindow(-1.5, 1.5, -1.5, 1.5);
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setUseFilmstripForMorphing(true);
        this.setFramesForMorphing(25);
        ActionRadioGroup actionRadioGroup = new ActionRadioGroup(){

            public void optionSelected(int n) {
                ConformalMap.this.setPreCompFunction(n);
            }
        };
        actionRadioGroup.addItem(I18n.tr("vmm.conformalmap.ConformalMap.id"));
        actionRadioGroup.addItem(I18n.tr("vmm.conformalmap.ConformalMap.inverse"));
        actionRadioGroup.addItem(I18n.tr("vmm.conformalmap.ConformalMap.fractlin"));
        actionRadioGroup.addItem(I18n.tr("vmm.conformalmap.ConformalMap.sqrt"));
        actionRadioGroup.setSelectedIndex(0);
        this.preCompSelect = actionRadioGroup;
        actionRadioGroup = new ActionRadioGroup(){

            public void optionSelected(int n) {
                ConformalMap.this.setPostCompFunction(n);
            }
        };
        actionRadioGroup.addItem(I18n.tr("vmm.conformalmap.ConformalMap.id"));
        actionRadioGroup.addItem(I18n.tr("vmm.conformalmap.ConformalMap.inverse"));
        actionRadioGroup.addItem(I18n.tr("vmm.conformalmap.ConformalMap.fractlin"));
        actionRadioGroup.addItem(I18n.tr("vmm.conformalmap.ConformalMap.sqrt"));
        actionRadioGroup.setSelectedIndex(0);
        this.postCompSelect = actionRadioGroup;
        actionRadioGroup = new ActionRadioGroup(){

            public void optionSelected(int n) {
                ConformalMap.this.setGridType(n);
            }
        };
        actionRadioGroup.addItem(I18n.tr("vmm.conformalmap.ConformalMap.cartesian"));
        actionRadioGroup.addItem(I18n.tr("vmm.conformalmap.ConformalMap.polar"));
        actionRadioGroup.addItem(I18n.tr("vmm.conformalmap.ConformalMap.polarconformal"));
        actionRadioGroup.setSelectedIndex(0);
        this.gridTypeSelect = actionRadioGroup;
    }

    public int getPostCompFunction() {
        return this.postCompFunction;
    }

    public void setPostCompFunction(int n) {
        if (this.postCompFunction != n) {
            this.postCompFunction = n;
            this.postCompSelect.setSelectedIndex(n);
            this.forceRedraw();
        }
    }

    public int getPreCompFunction() {
        return this.preCompFunction;
    }

    public void setPreCompFunction(int n) {
        if (this.preCompFunction != n) {
            this.preCompFunction = n;
            this.preCompSelect.setSelectedIndex(n);
            this.forceRedraw();
        }
    }

    public int getGridType() {
        return this.gridType;
    }

    public void setGridType(int n) {
        if (n != 0 && n != 1 && n != 2) {
            return;
        }
        if (this.gridType != n) {
            this.gridData[this.gridType][0] = this.umin.getValue();
            this.gridData[this.gridType][1] = this.umax.getValue();
            this.gridData[this.gridType][2] = this.vmin.getValue();
            this.gridData[this.gridType][3] = this.vmax.getValue();
            this.gridData[this.gridType][4] = this.ures.getValue();
            this.gridData[this.gridType][5] = this.vres.getValue();
            this.gridType = n;
            this.umin.reset(this.gridData[this.gridType][0]);
            this.umax.reset(this.gridData[this.gridType][1]);
            this.vmin.reset(this.gridData[this.gridType][2]);
            this.vmax.reset(this.gridData[this.gridType][3]);
            this.ures.reset((int)this.gridData[this.gridType][4]);
            this.vres.reset((int)this.gridData[this.gridType][5]);
            this.gridTypeSelect.setSelectedIndex(n);
            this.forceRedraw();
        }
    }

    protected void resetGridType(int n) {
        this.gridType = n;
        this.gridTypeSelect.setSelectedIndex(n);
    }

    protected Complex composedFunction(Complex complex) {
        Complex complex2 = null;
        switch (this.preCompFunction) {
            case 0: {
                complex2 = complex;
                break;
            }
            case 1: {
                complex2 = complex.inverse();
                break;
            }
            case 2: {
                complex2 = complex.minus(1.0).dividedBy(complex.plus(1.0)).times(-1.0);
                break;
            }
            case 3: {
                complex2 = complex.power(0.5);
            }
        }
        complex = this.function(complex2);
        switch (this.postCompFunction) {
            case 0: {
                complex2 = complex;
                break;
            }
            case 1: {
                complex2 = complex.inverse();
                break;
            }
            case 2: {
                complex2 = complex.minus(1.0).dividedBy(complex.plus(1.0)).times(-1.0);
                break;
            }
            case 3: {
                complex2 = complex.power(0.5);
            }
        }
        return complex2;
    }

    public double[] getDefaultWindow2D() {
        return this.defaultWindow2D;
    }

    public void setDefaultWindow2D(double[] dArray) {
        if (dArray != null) {
            if (dArray.length < 4) {
                throw new IllegalArgumentException("Internal Error: Array is too short.");
            }
            this.defaultWindow2D = dArray;
        }
    }

    public void setDefaultWindow2D(double d, double d2, double d3, double d4) {
        this.setDefaultWindow2D(new double[]{d, d2, d3, d4});
    }

    protected Complex gridMap(double d, double d2) {
        Complex complex = new Complex(d, d2);
        switch (this.gridType) {
            case 0: {
                break;
            }
            case 1: {
                complex.re = d * Math.cos(d2);
                complex.im = d * Math.sin(d2);
                break;
            }
            case 2: {
                complex = complex.exponential();
            }
        }
        return complex;
    }

    protected void computeDrawData3D(View3D view3D, boolean bl, Transform3D transform3D, Transform3D transform3D2) {
        if (bl) {
            int n = this.ures.getValue() * 4;
            int n2 = this.vres.getValue() * 4;
            this.valueGrid = new Complex[n + 1][n2 + 1];
            this.argumentGrid = new Complex[n + 1][n2 + 1];
            double d = this.umin.getValue();
            double d2 = this.vmin.getValue();
            double d3 = this.umax.getValue();
            double d4 = this.vmax.getValue();
            double d5 = (d3 - d) / (double)n;
            double d6 = (d4 - d2) / (double)n2;
            for (int i = 0; i <= n; ++i) {
                for (int j = 0; j <= n2; ++j) {
                    this.argumentGrid[i][j] = this.gridMap(d + (double)i * d5, d2 + (double)j * d6);
                    this.valueGrid[i][j] = this.composedFunction(this.argumentGrid[i][j]);
                }
            }
        }
    }

    protected void doDraw3D(Graphics2D graphics2D, View3D view3D, Transform3D transform3D) {
        int n = this.ures.getValue() * 4;
        int n2 = this.vres.getValue() * 4;
        if (!(view3D instanceof ConformalMapView) || ((ConformalMapView)view3D).getDrawValueGrid()) {
            if (!view3D.getEnableThreeD()) {
                this.drawGrid(graphics2D, view3D, this.valueGrid, n, n2);
            } else {
                this.drawGrid3D(graphics2D, view3D, this.valueGrid, n, n2);
            }
        } else {
            this.drawGrid(graphics2D, view3D, this.argumentGrid, n, n2);
        }
    }

    private void drawGrid(Graphics2D graphics2D, View3D view3D, Complex[][] complexArray, int n, int n2) {
        int n3;
        Color color;
        boolean bl;
        Point2D[] point2DArray;
        int n4;
        boolean bl2 = Color.WHITE.equals(view3D.getBackground());
        boolean bl3 = true;
        int n5 = -1;
        int n6 = -1;
        Color color2 = view3D.getColor();
        if (view3D instanceof ConformalMapView) {
            bl3 = ((ConformalMapView)view3D).getUseColor();
            n5 = ((ConformalMapView)view3D).getUHilite();
            n6 = ((ConformalMapView)view3D).getVHilite();
        }
        boolean bl4 = n5 >= 0 || n6 >= 0;
        for (n4 = 0; n4 <= n; n4 += 4) {
            point2DArray = new Point2D[n2 + 1];
            bl = n5 == n4;
            color = null;
            if (bl3) {
                if (!bl4 || !bl) {
                    n3 = bl4 && !bl2 ? 175 : 255;
                    color = new Color(n3, (int)((double)n3 * ((double)(n - n4) / (double)n)), 0);
                }
            } else if (bl4 && bl) {
                color = Color.RED;
            }
            view3D.setColor(color);
            for (n3 = 0; n3 <= n2; ++n3) {
                point2DArray[n3] = new Point2D.Double(complexArray[n4][n3].re, complexArray[n4][n3].im);
            }
            if (bl4 && bl) {
                view3D.setStrokeSizeMultiplier(2);
                view3D.drawCurve(point2DArray);
                view3D.setStrokeSizeMultiplier(1);
                continue;
            }
            view3D.drawCurve(point2DArray);
        }
        for (n4 = 0; n4 <= n2; n4 += 4) {
            point2DArray = new Point2D[n + 1];
            bl = n6 == n4;
            color = null;
            if (bl3) {
                if (!bl4 || !bl) {
                    n3 = bl4 && !bl2 ? 175 : 255;
                    color = new Color(n3 / 3, (int)((double)n3 * ((double)(n2 - n4) / (double)n2)), (int)((double)n3 * ((double)n4 / (double)n2)));
                }
            } else if (bl4 && bl) {
                color = Color.RED;
            }
            view3D.setColor(color);
            for (n3 = 0; n3 <= n; ++n3) {
                point2DArray[n3] = new Point2D.Double(complexArray[n3][n4].re, complexArray[n3][n4].im);
            }
            if (bl4 && bl) {
                view3D.setStrokeSizeMultiplier(2);
                view3D.drawCurve(point2DArray);
                view3D.setStrokeSizeMultiplier(1);
                continue;
            }
            view3D.drawCurve(point2DArray);
        }
        view3D.setColor(color2);
    }

    private void drawGrid3D(Graphics2D graphics2D, View3D view3D, Complex[][] complexArray, int n, int n2) {
        double[] dArray;
        int n3;
        Color color;
        boolean bl;
        Vector3D[] vector3DArray;
        int n4;
        boolean bl2 = Color.WHITE.equals(view3D.getBackground());
        boolean bl3 = true;
        int n5 = -1;
        int n6 = -1;
        if (view3D instanceof ConformalMapView) {
            bl3 = ((ConformalMapView)view3D).getUseColor();
            n5 = ((ConformalMapView)view3D).getUHilite();
            n6 = ((ConformalMapView)view3D).getVHilite();
        }
        boolean bl4 = n5 >= 0 || n6 >= 0;
        Color color2 = view3D.getColor();
        for (n4 = 0; n4 <= n; n4 += 4) {
            vector3DArray = new Vector3D[n2 + 1];
            bl = n5 == n4;
            color = null;
            if (bl3) {
                if (!bl4 || !bl) {
                    n3 = bl4 && !bl2 ? 175 : 255;
                    color = new Color(n3, (int)((double)n3 * ((double)(n - n4) / (double)n)), 0);
                }
            } else if (bl4 && bl) {
                color = Color.RED;
            }
            view3D.setColor(color);
            for (n3 = 0; n3 <= n2; ++n3) {
                if (complexArray[n4][n3].abs2() > 1000000.0) {
                    vector3DArray[n3] = new Vector3D(0.0, 0.0, 1.0);
                    continue;
                }
                dArray = complexArray[n4][n3].stereographicProjection();
                vector3DArray[n3] = new Vector3D(dArray[0], dArray[1], dArray[2]);
            }
            if (bl4 && bl) {
                view3D.setStrokeSizeMultiplier(2);
                view3D.drawCurve(vector3DArray);
                view3D.setStrokeSizeMultiplier(1);
                continue;
            }
            view3D.drawCurve(vector3DArray);
        }
        for (n4 = 0; n4 <= n2; n4 += 4) {
            vector3DArray = new Vector3D[n + 1];
            bl = n6 == n4;
            color = null;
            if (bl3) {
                if (!bl4 || !bl) {
                    n3 = bl4 && !bl2 ? 175 : 255;
                    color = new Color(n3 / 3, (int)((double)n3 * ((double)(n2 - n4) / (double)n2)), (int)((double)n3 * ((double)n4 / (double)n2)));
                }
            } else if (bl4 && bl) {
                color = Color.RED;
            }
            view3D.setColor(color);
            for (n3 = 0; n3 <= n; ++n3) {
                if (complexArray[n3][n4].abs2() > 1000000.0) {
                    vector3DArray[n3] = new Vector3D(0.0, 0.0, 1.0);
                    continue;
                }
                dArray = complexArray[n3][n4].stereographicProjection();
                vector3DArray[n3] = new Vector3D(dArray[0], dArray[1], dArray[2]);
            }
            if (bl4 && bl) {
                view3D.setStrokeSizeMultiplier(2);
                view3D.drawCurve(vector3DArray);
                view3D.setStrokeSizeMultiplier(1);
                continue;
            }
            view3D.drawCurve(vector3DArray);
        }
        view3D.setColor(color2);
    }

    public Animation getCreateAnimation(View view) {
        if (!(view instanceof ConformalMapView)) {
            return null;
        }
        final ConformalMapView conformalMapView = (ConformalMapView)view;
        if (conformalMapView.getViewStyle() != 0 && conformalMapView.getViewStyle() != 1) {
            return null;
        }
        return new ThreadedAnimation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runAnimation() {
                try {
                    int n;
                    int n2 = conformalMapView.getShowBothArgAndValue() ? 100 : 50;
                    int n3 = ConformalMap.this.ures.getValue() * 4;
                    int n4 = ConformalMap.this.vres.getValue() * 4;
                    if (!conformalMapView.getShowBothArgAndValue()) {
                        conformalMapView.setDrawValueGrid(false);
                    }
                    this.pause(300);
                    for (n = 0; n <= n3; n += 4) {
                        conformalMapView.setHilite(n, n4 + 1);
                        this.pause(n2);
                    }
                    conformalMapView.setHilite(n3 + 1, n4 + 1);
                    this.pause(120);
                    for (n = 0; n <= n4; n += 4) {
                        conformalMapView.setHilite(n3 + 1, n);
                        this.pause(n2);
                    }
                    if (conformalMapView.getShowBothArgAndValue()) {
                        return;
                    }
                    conformalMapView.setHilite(-1, -1);
                    this.pause(300);
                    conformalMapView.setDrawValueGrid(true);
                    this.pause(300);
                    n2 = 80;
                    for (n = 0; n <= n3; n += 4) {
                        conformalMapView.setHilite(n, n4 + 1);
                        this.pause(n2);
                    }
                    conformalMapView.setHilite(n3 + 1, n4 + 1);
                    this.pause(120);
                    for (n = 0; n <= n4; n += 4) {
                        conformalMapView.setHilite(n3 + 1, n);
                        this.pause(n2);
                    }
                }
                finally {
                    conformalMapView.setHilite(-1, -1);
                    conformalMapView.setDrawValueGrid(true);
                }
            }
        };
    }

    public View getDefaultView() {
        ConformalMapView conformalMapView = new ConformalMapView();
        conformalMapView.setShowBothArgAndValue(true);
        return conformalMapView;
    }

    public ActionList getActionsForView(final View view) {
        ActionList actionList = super.getActionsForView(view);
        if (!(view instanceof ConformalMapView)) {
            return actionList;
        }
        actionList.add(null);
        actionList.add(new AbstractActionVMM(I18n.tr("vmm.conformalmap.ConformalMap.GetLineSegment")){

            public void actionPerformed(ActionEvent actionEvent) {
                new GetFigure((ConformalMapView)view, 0, 1);
            }
        });
        actionList.add(new AbstractActionVMM(I18n.tr("vmm.conformalmap.ConformalMap.GetLine")){

            public void actionPerformed(ActionEvent actionEvent) {
                new GetFigure((ConformalMapView)view, 1, 1);
            }
        });
        actionList.add(new AbstractActionVMM(I18n.tr("vmm.conformalmap.ConformalMap.GetLCircle")){

            public void actionPerformed(ActionEvent actionEvent) {
                new GetFigure((ConformalMapView)view, 2, 2);
            }
        });
        actionList.add(new AbstractActionVMM(I18n.tr("vmm.conformalmap.ConformalMap.RemoveFigures")){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ConformalMapView)view).removeFigures();
            }
        });
        actionList.add(null);
        ActionList actionList2 = new ActionList(I18n.tr("vmm.conformalmap.ConformalMap.preComp"));
        actionList2.add(this.preCompSelect);
        actionList.add(actionList2);
        actionList2 = new ActionList(I18n.tr("vmm.conformalmap.ConformalMap.postComp"));
        actionList2.add(this.postCompSelect);
        actionList.add(actionList2);
        actionList2 = new ActionList(I18n.tr("vmm.conformalmap.ConformalMap.gridChoice"));
        actionList2.add(this.gridTypeSelect);
        actionList.add(actionList2);
        return actionList;
    }

    public void addExtraXML(Document document, Element element) {
        super.addExtraXML(document, element);
        this.gridData[this.gridType][0] = this.umin.getValue();
        this.gridData[this.gridType][1] = this.umax.getValue();
        this.gridData[this.gridType][2] = this.vmin.getValue();
        this.gridData[this.gridType][3] = this.vmax.getValue();
        this.gridData[this.gridType][4] = this.ures.getValue();
        this.gridData[this.gridType][5] = this.vres.getValue();
        Element element2 = document.createElement("gridLimits");
        element2.setAttribute("cartesian", Util.toExternalString(this.gridData[0]));
        element2.setAttribute("polar", Util.toExternalString(this.gridData[1]));
        element2.setAttribute("polarconformal", Util.toExternalString(this.gridData[2]));
        element.appendChild(element2);
    }

    public void readExtraXML(Element element) throws IOException {
        super.readExtraXML(element);
        Element element2 = SaveAndRestore.getChildElement(element, "gridLimits");
        if (element2 == null) {
            return;
        }
        String string = element2.getAttribute("cartesian").trim();
        if (string.length() == 0) {
            throw new IOException(I18n.tr("vmm.conformalmap.ConformalMap.MissingAttributeError", "cartesian"));
        }
        double[] dArray = (double[])Util.externalStringToValue(string, double[].class);
        if (dArray.length != 6) {
            throw new IOException(I18n.tr("vmm.conformalmap.ConformalMap.IncorrectArrayLength", "cartesian"));
        }
        string = element2.getAttribute("polar").trim();
        if (string.length() == 0) {
            throw new IOException(I18n.tr("vmm.conformalmap.ConformalMap.MissingAttributeError", "polar"));
        }
        double[] dArray2 = (double[])Util.externalStringToValue(string, double[].class);
        if (dArray2.length != 6) {
            throw new IOException(I18n.tr("vmm.conformalmap.ConformalMap.IncorrectArrayLength", "polar"));
        }
        string = element2.getAttribute("polarconformal").trim();
        if (string.length() == 0) {
            throw new IOException(I18n.tr("vmm.conformalmap.ConformalMap.MissingAttributeError", "polarconformal"));
        }
        double[] dArray3 = (double[])Util.externalStringToValue(string, double[].class);
        if (dArray3.length != 6) {
            throw new IOException(I18n.tr("vmm.conformalmap.ConformalMap.IncorrectArrayLength", "polarconformal"));
        }
        this.gridData = new double[][]{dArray, dArray2, dArray3};
        this.umin.reset(this.gridData[this.gridType][0]);
        this.umax.reset(this.gridData[this.gridType][1]);
        this.vmin.reset(this.gridData[this.gridType][2]);
        this.vmax.reset(this.gridData[this.gridType][3]);
        this.ures.reset((int)this.gridData[this.gridType][4]);
        this.vres.reset((int)this.gridData[this.gridType][5]);
    }

    public static class ConformalMapView
    extends View3D {
        @VMMSave
        private boolean use3D;
        @VMMSave
        private boolean useColor = true;
        private boolean drawValueGrid = true;
        private int uHilite = -1;
        private int vHilite = -1;
        @VMMSave
        private boolean showBothArgAndValue;
        private ConformalMapView argView;
        private boolean isArgView;
        private ToggleAction useColorToggle = new ToggleAction(I18n.tr("vmm.conformalmap.ConformalMap.ToggleUseColor"), true){

            public void actionPerformed(ActionEvent actionEvent) {
                ConformalMapView.this.setUseColor(!ConformalMapView.this.useColor);
            }
        };
        private ToggleAction showArgAndValueToggle = new ToggleAction(I18n.tr("vmm.conformalmap.ConformalMap.ToggleShowArgAndValue"), false){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ConformalMapView.this.getDisplay() != null) {
                    ConformalMapView.this.getDisplay().stopAnimation();
                }
                ConformalMapView.this.setShowBothArgAndValue(this.getState());
            }
        };
        protected ToggleAction use3DToggle = new ToggleAction(I18n.tr("vmm.conformalmap.ConformalMap.ToggleUse3D"), false){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ConformalMapView.this.getDisplay() != null) {
                    ConformalMapView.this.getDisplay().stopAnimation();
                }
                ConformalMapView.this.setUse3D(ConformalMapView.this.use3DToggle.getState());
            }
        };

        public ConformalMapView() {
            this.setAntialiased(true);
            this.setEnableThreeD(false);
            this.setShowAxes(true);
        }

        public void removeFigures() {
            Decoration[] decorationArray = this.getDecorations();
            for (int i = decorationArray.length - 1; i >= 0; --i) {
                if (!(decorationArray[i] instanceof ConformalMapFigure)) continue;
                this.removeDecoration(decorationArray[i]);
            }
            if (this.argView != null) {
                this.argView.removeFigures();
            }
        }

        public void setExhibit(Exhibit exhibit) {
            if (exhibit == this.getExhibit()) {
                return;
            }
            super.setExhibit(exhibit);
            if (exhibit != null && exhibit instanceof ConformalMap) {
                ConformalMap conformalMap = (ConformalMap)exhibit;
                double[] dArray = conformalMap.getDefaultWindow2D();
                this.setWindowForUseWhileThreeDDisabled(dArray[0], dArray[1], dArray[2], dArray[3]);
                if (this.showBothArgAndValue) {
                    this.setUpArgView();
                }
            }
        }

        public boolean getUseColor() {
            return this.useColor;
        }

        public void setUseColor(boolean bl) {
            if (bl == this.useColor) {
                return;
            }
            this.useColorToggle.setState(bl);
            this.forceRedraw();
            this.useColor = bl;
            if (this.argView != null) {
                this.argView.useColor = bl;
                this.argView.forceRedraw();
            }
        }

        public synchronized boolean getDrawValueGrid() {
            return this.drawValueGrid;
        }

        private synchronized void setDrawValueGrid(boolean bl) {
            if (bl != this.drawValueGrid) {
                this.drawValueGrid = bl;
                if (this.use3D) {
                    this.setEnableThreeD(this.drawValueGrid);
                }
                this.forceRedraw();
            }
        }

        public MouseTask getDefaultMouseTask() {
            if (this.isArgView) {
                return new BasicMouseTask2D();
            }
            if (this.showBothArgAndValue) {
                if (this.use3D) {
                    return new BasicMouseTask3D();
                }
                return new BasicMouseTask2D();
            }
            if (this.use3D) {
                return new ConformalMapMouseTask3D();
            }
            return new ConformalMapMouseTask2D();
        }

        public ActionList getActions() {
            ActionList actionList = super.getActions();
            actionList.add(this.showArgAndValueToggle);
            actionList.add(this.useColorToggle);
            actionList.add(this.use3DToggle);
            return actionList;
        }

        public void takeExhibit(View view, boolean bl) {
            super.takeExhibit(view, bl);
            if (bl && view instanceof ConformalMapView) {
                this.setUse3D(((ConformalMapView)view).getUse3D());
            }
        }

        public boolean getUse3D() {
            return this.use3D;
        }

        public void setUse3D(boolean bl) {
            if (this.use3D == bl) {
                return;
            }
            this.use3D = bl;
            this.use3DToggle.setState(bl);
            this.setEnableThreeD(bl);
            if (this.getDisplay() != null) {
                this.getDisplay().installMouseTask(this.getDefaultMouseTask());
            }
            if (this.showBothArgAndValue) {
                this.viewStyleCommands.setEnabled(false);
            }
        }

        private synchronized void setHilite(int n, int n2) {
            this.uHilite = n;
            this.vHilite = n2;
            this.forceRedraw();
            if (this.argView != null) {
                this.argView.uHilite = n;
                this.argView.vHilite = n2;
                this.argView.forceRedraw();
            }
        }

        private synchronized int getUHilite() {
            return this.uHilite;
        }

        private synchronized int getVHilite() {
            return this.vHilite;
        }

        public boolean getShowBothArgAndValue() {
            return this.showBothArgAndValue;
        }

        public void setShowBothArgAndValue(boolean bl) {
            if (this.showBothArgAndValue == bl) {
                return;
            }
            this.showBothArgAndValue = bl;
            this.showArgAndValueToggle.setState(bl);
            if (bl) {
                this.argView = new ConformalMapView();
                this.argView.isArgView = true;
                this.setUpArgView();
                if (this.getDisplay() != null) {
                    this.getDisplay().installMouseTask(this.getDefaultMouseTask());
                    this.getDisplay().installAuxiliaryView(this, this.argView);
                }
            } else {
                if (this.getDisplay() != null) {
                    this.getDisplay().installMouseTask(this.getDefaultMouseTask());
                    this.getDisplay().installAuxiliaryView(this, null);
                }
                this.argView = null;
                if (this.getUse3D()) {
                    this.viewStyleCommands.setEnabled(true);
                }
            }
        }

        private void setUpArgView() {
            if (this.argView != null) {
                if (this.getUse3D()) {
                    this.setViewStyle(0);
                }
                this.viewStyleCommands.setEnabled(false);
                if (this.getExhibit() != null) {
                    this.argView.takeExhibit(this, true);
                }
                this.argView.setUse3D(false);
                this.argView.setDrawValueGrid(false);
                this.argView.setBackground(this.getBackground());
                this.argView.setShowAxes(this.getShowAxes());
                this.argView.useColor = this.useColor;
                for (Decoration decoration : this.getDecorations()) {
                    if (!(decoration instanceof ConformalMapFigure)) continue;
                    ConformalMapFigure conformalMapFigure = (ConformalMapFigure)decoration;
                    ConformalMapFigure conformalMapFigure2 = new ConformalMapFigure(conformalMapFigure.getP1(), conformalMapFigure.getP2(), conformalMapFigure.getShape(), conformalMapFigure.getPointCount());
                    conformalMapFigure2.setColor(conformalMapFigure.getColor());
                    this.argView.addDecoration(conformalMapFigure2);
                }
            }
        }

        public void setDisplay(Display display) {
            super.setDisplay(display);
            if (display != null) {
                display.setStopAnimationsOnResize(false);
            }
            if (display != null && this.showBothArgAndValue) {
                display.installAuxiliaryView(this, this.argView);
            }
        }

        public void setBackground(Color color) {
            super.setBackground(color);
            if (this.argView != null) {
                this.argView.setBackground(color);
            }
        }

        public void setShowAxes(boolean bl) {
            super.setShowAxes(bl);
            if (this.argView != null) {
                this.argView.setShowAxes(bl);
            }
        }

        public void addDecoration(Decoration decoration) {
            super.addDecoration(decoration);
            if (decoration instanceof ConformalMapFigure && this.argView != null) {
                ConformalMapFigure conformalMapFigure = (ConformalMapFigure)decoration;
                ConformalMapFigure conformalMapFigure2 = new ConformalMapFigure(conformalMapFigure.getP1(), conformalMapFigure.getP2(), conformalMapFigure.getShape(), conformalMapFigure.getPointCount());
                conformalMapFigure2.setColor(conformalMapFigure.getColor());
                this.argView.addDecoration(conformalMapFigure2);
            }
        }

        public void readExtraXML(Element element) throws IOException {
            super.readExtraXML(element);
            if (this.showBothArgAndValue) {
                this.argView.setTransform(this.getEnableThreeD() ? this.getSavedAuxiliaryTransformForEnableThreeD() : this.getTransform());
            }
        }
    }

    private class GetFigure
    extends TwoPointInput {
        boolean canceled = true;
        int shape;
        int pointCount;
        ConformalMapView mainView;
        boolean forAuxiliaryView;

        GetFigure(ConformalMapView conformalMapView, int n, int n2) {
            this.mainView = conformalMapView;
            conformalMapView.getDisplay().stopAnimation();
            conformalMapView.use3DToggle.setEnabled(false);
            this.shape = n;
            this.pointCount = n == 2 ? ConformalMap.this.pointsOnCircleFigure : (n == 1 ? ConformalMap.this.pointsOnLineFigure : ConformalMap.this.pointsOnLineSegmentFigure);
            this.setFigureToDraw(n2);
            this.setDrawColor(conformalMapView.getForeground());
            if (conformalMapView.getShowBothArgAndValue()) {
                conformalMapView.getDisplay().installAuxiliaryOneShotMouseTask(this);
                this.forAuxiliaryView = true;
            } else {
                conformalMapView.setDrawValueGrid(false);
                conformalMapView.getDisplay().installOneShotMouseTask(this);
                this.forAuxiliaryView = false;
            }
        }

        protected void gotPoints(Display display, View view, int n, int n2, int n3, int n4) {
            this.canceled = false;
            Point2D.Double double_ = new Point2D.Double(n, n2);
            Point2D.Double double_2 = new Point2D.Double(n3, n4);
            view.getTransform().viewportToWindow(double_);
            view.getTransform().viewportToWindow(double_2);
            ConformalMapFigure conformalMapFigure = new ConformalMapFigure(double_, double_2, this.shape, this.pointCount);
            if (this.shape == 2) {
                conformalMapFigure.setColor(Color.GREEN);
            } else {
                conformalMapFigure.setColor(Color.RED);
            }
            this.mainView.addDecoration(conformalMapFigure);
            if (!this.forAuxiliaryView) {
                display.installAnimation(new ThreadedAnimation(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void runAnimation() {
                        try {
                            this.pause(1000);
                        }
                        finally {
                            GetFigure.this.mainView.setDrawValueGrid(true);
                        }
                    }
                });
            }
        }

        public void finish(Display display, View view) {
            if (this.canceled && !this.forAuxiliaryView) {
                this.mainView.setDrawValueGrid(true);
            }
            this.mainView.use3DToggle.setEnabled(true);
        }

        public String getStatusText() {
            return I18n.tr("vmm.conformalmap.ConformalMap.inputFigurePrompt");
        }
    }

    private static class ConformalMapMouseTask3D
    extends BasicMouseTask3D {
        private boolean commandShifted;

        private ConformalMapMouseTask3D() {
        }

        public boolean doMouseDown(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
            if (mouseEvent.isShiftDown() && mouseEvent.isMetaDown()) {
                ConformalMapView conformalMapView = (ConformalMapView)display.getView();
                conformalMapView.setDrawValueGrid(false);
                conformalMapView.forceRedraw();
                this.commandShifted = true;
                return true;
            }
            this.commandShifted = false;
            return super.doMouseDown(mouseEvent, display, view, n, n2);
        }

        public void doMouseDrag(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
            if (!this.commandShifted) {
                super.doMouseDrag(mouseEvent, display, view, n, n2);
            }
        }

        public void doMouseUp(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
            if (this.commandShifted) {
                ConformalMapView conformalMapView = (ConformalMapView)display.getView();
                conformalMapView.setDrawValueGrid(true);
                conformalMapView.drawValueGrid = true;
                conformalMapView.forceRedraw();
            } else {
                super.doMouseUp(mouseEvent, display, view, n, n2);
            }
        }
    }

    private static class ConformalMapMouseTask2D
    extends BasicMouseTask2D {
        private boolean commandShifted;

        private ConformalMapMouseTask2D() {
        }

        public boolean doMouseDown(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
            if (mouseEvent.isShiftDown() && mouseEvent.isMetaDown()) {
                ConformalMapView conformalMapView = (ConformalMapView)display.getView();
                conformalMapView.setDrawValueGrid(false);
                conformalMapView.forceRedraw();
                this.commandShifted = true;
                return true;
            }
            this.commandShifted = false;
            return super.doMouseDown(mouseEvent, display, view, n, n2);
        }

        public void doMouseDrag(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
            if (!this.commandShifted) {
                super.doMouseDrag(mouseEvent, display, view, n, n2);
            }
        }

        public void doMouseUp(MouseEvent mouseEvent, Display display, View view, int n, int n2) {
            if (this.commandShifted) {
                ConformalMapView conformalMapView = (ConformalMapView)display.getView();
                conformalMapView.setDrawValueGrid(true);
                conformalMapView.forceRedraw();
            } else {
                super.doMouseUp(mouseEvent, display, view, n, n2);
            }
        }
    }
}

