/*
 * Decompiled with CFR 0.152.
 */
package vmm.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import vmm.actions.ActionItem;

public class ActionRadioGroup
implements ActionItem {
    private ArrayList<AbstractAction> actions;
    private int selectedIndex;
    private boolean enabled = true;

    public ActionRadioGroup() {
        this(null, -1);
    }

    public ActionRadioGroup(String[] stringArray) {
        this(stringArray, -1);
    }

    public ActionRadioGroup(String[] stringArray, int n) {
        if (stringArray == null || n < 0 || n >= stringArray.length || stringArray[n] == null) {
            n = -1;
        }
        this.actions = new ArrayList();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.addItem(stringArray[i]);
            }
        }
        this.selectedIndex = -1;
        this.setSelectedIndex(n);
    }

    public void optionSelected(int n) {
    }

    public JRadioButtonMenuItem[] createRadioButtonMenuItems() {
        JRadioButtonMenuItem[] jRadioButtonMenuItemArray = new JRadioButtonMenuItem[this.actions.size()];
        for (int i = 0; i < jRadioButtonMenuItemArray.length; ++i) {
            if (this.actions.get(i) == null) continue;
            jRadioButtonMenuItemArray[i] = new ActionRadioButtonMenuItem(i);
        }
        return jRadioButtonMenuItemArray;
    }

    public JRadioButton[] createRadioButtons() {
        JRadioButton[] jRadioButtonArray = new JRadioButton[this.actions.size()];
        for (int i = 0; i < jRadioButtonArray.length; ++i) {
            if (this.actions.get(i) == null) continue;
            jRadioButtonArray[i] = new ActionRadioButton(i);
        }
        return jRadioButtonArray;
    }

    public int addItem(String string) {
        if (string == null) {
            this.actions.add(null);
        } else {
            final int n = this.actions.size();
            AbstractAction abstractAction = new AbstractAction(string){

                public void actionPerformed(ActionEvent actionEvent) {
                    ActionRadioGroup.this.setSelectedIndex(n);
                    ActionRadioGroup.this.optionSelected(n);
                }
            };
            abstractAction.putValue("RadioState", new Boolean(false));
            abstractAction.setEnabled(this.enabled);
            this.actions.add(abstractAction);
        }
        return this.actions.size() - 1;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int n) {
        if (n < 0 || n >= this.actions.size() || this.actions.get(n) == null) {
            n = -1;
        }
        if (this.selectedIndex >= 0) {
            this.actions.get(this.selectedIndex).putValue("RadioState", new Boolean(false));
        }
        if (n >= 0) {
            this.actions.get(n).putValue("RadioState", new Boolean(true));
        }
        this.selectedIndex = n;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled != bl) {
            this.enabled = bl;
            for (int i = 0; i < this.actions.size(); ++i) {
                this.actions.get(i).setEnabled(bl);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public JMenuItem[] getMenuItems() {
        return this.createRadioButtonMenuItems();
    }

    public int getItemCount() {
        return this.actions.size();
    }

    private class ActionRadioButton
    extends JRadioButton
    implements PropertyChangeListener {
        ActionRadioButton(int n) {
            super((Action)ActionRadioGroup.this.actions.get(n));
            AbstractAction abstractAction = (AbstractAction)ActionRadioGroup.this.actions.get(n);
            this.setSelected((Boolean)abstractAction.getValue("RadioState"));
            abstractAction.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("RadioState")) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                if (this.isSelected() != bl) {
                    this.setSelected(bl);
                }
            }
        }
    }

    private class ActionRadioButtonMenuItem
    extends JRadioButtonMenuItem
    implements PropertyChangeListener {
        ActionRadioButtonMenuItem(int n) {
            super((Action)ActionRadioGroup.this.actions.get(n));
            AbstractAction abstractAction = (AbstractAction)ActionRadioGroup.this.actions.get(n);
            this.setSelected((Boolean)abstractAction.getValue("RadioState"));
            abstractAction.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("RadioState")) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                if (this.isSelected() != bl) {
                    this.setSelected(bl);
                }
            }
        }
    }
}

